/*
   File: dcg_xput.h
   Defines transput routines

   Copyright (C) 2008 Marc Seutter

   This library is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published
   by the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with this library.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: dcg_xput.h,v 1.12 2008/06/28 13:41:17 marcs Exp $"
*/
#ifndef IncDcgXput
#define IncDcgXput

/* Standard includes */
#include <stdlib.h>
#include <stdio.h>

/* Local includes */
#include "dcg.h"
#include "dcg_string.h"

/* Estimate printing of standard types */
#define MAXWIDTH 80
#define PTRWIDTH (sizeof (vptr) + 8)
int est_int (int x);
int est_u_int (u_int x);
#define est_int64(x) 20
#define est_u_int64(x) 21
int est_real (real x);
int est_string (string x);
#define est_char(x) 3
#define est_vptr(x) PTRWIDTH

/* Define support for pretty printing */
void pppindent (FILE *f, int ind);
void pppdelim (FILE *f, int horiz, int ind, char x);
#define pppstring(f,x) fputs(x,f)

/* Define pretty printing of standard types */
#define ppp_int(f,hor,ind,x) fprintf (f,"%d",x)
#define ppp_u_int(f,hor,ind,x) fprintf (f,"%u",x)
#define ppp_int64(f,hor,ind,x) { fprintf (f, "0x%08x", ((int) (x >> 32))); \
				 fprintf (f, "%08xLL", ((int) x)); }
#define ppp_u_int64(f,hor,ind,x) { fprintf (f, "0x%08x", ((int) (x >> 32))); \
				   fprintf (f, "%08xULL", ((int) x)); }
#define ppp_real(f,hor,ind,x) fprintf (f,"%g",x)
#define ppp_string(f,hor,ind,x) fprintf (f,"\"%s\"",x)
#define ppp_char(f,hor,ind,x) fprintf (f,"'%c'",x)
#define ppp_vptr(f,hor,ind,x) fprintf (f, "--> %p", x)

#define pp_char(f,ind,x) fprintf (f,"'%c'",x)
#define pp_int(f,ind,x) fprintf (f,"%d",x)
#define pp_u_int(f,ind,x) fprintf (f,"%u",x)
#define pp_int64(f,ind,x) { fprintf (f, "0x%08x", ((int) (x >> 32)); \
			    fprintf (f, "%08xLL", ((int) x)); }
#define pp_u_int64(f,ind,x) { fprintf (f, "0x%08x", ((int) (x >> 32)); \
			      fprintf (f, "%08xULL", ((int) x)); }
#define pp_real(f,ind,x) fprintf (f,"%g",x)
#define pp_string(f,ind,x) fprintf (f,"\"%s\"",x)
#define pp_vptr(f,ind,x) ppp_vptr (f,0,0,x)

/* Define support for saving */ 
void initsave (FILE *f);
void finishsave (FILE *f);
void savechar (FILE *f, char x);

/* Define saving for standard types */
void save_int (FILE *f, int x);
void save_u_int (FILE *f, u_int x);
void save_int64 (FILE *f, int64 x);
void save_u_int64 (FILE *f, u_int64 x);
void save_real (FILE *f, real x);
void save_string (FILE *f, string x);
void savesize (FILE *f, int sz);
#define save_char(f,x) savechar(f,x)
#define save_vptr(f,x)

/* Define support for loading */ 
void initload (FILE *f);
int finishload (FILE *f);
int loadchar (FILE *f, char *x);

/* Define loading for standard types */
#define load_char(f,x) loadchar(f,x)
int load_int (FILE *f, int *x);
int load_u_int (FILE *f, u_int *x);
int load_int64 (FILE *f, int64 *x);
int load_u_int64 (FILE *f, u_int64 *x);
int load_real (FILE *f, real *x);
int load_string (FILE *f, string *x);
int load_vptr (FILE *f, vptr *x);
int loadsize (FILE *f, int *x);

#endif /* IncDcgXput */
