/*
   File: dcg_alloc.h
   Provides basic allocation routines and garbage collection
   while lessening the overhead caused by malloc and free.
   Note that an initial call to init_alloc () is required.

   Copyright (C) 2008 Marc Seutter

   This library is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published
   by the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with this library.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: dcg_alloc.h,v 1.9 2008/06/28 13:41:16 marcs Exp $"
*/
#ifndef IncDcgAlloc
#define IncDcgAlloc

/* Local includes */
#include "dcg.h"

/* Basic allocation routines */
char *dcg_malloc (int size);
char *dcg_attach (char *ptr);
void dcg_detach (char **ptr);
char *dcg_predetach (char **ptr);
void dcg_cknonshared (char *ptr);
void dcg_mkconstant (char *ptr);

/* Derived routines */
char *dcg_calloc (int nr, int size);
void dcg_realloc (char **ptr, int size);
void dcg_recalloc (char **ptr, int nr, int size);

/* Convenience macro */
#define nonrec_detach(x) dcg_detach((char **) x)

/* Initialization and inspection of the garbage collector */
void init_alloc ();
void report_alloc ();

#endif /* IncDcgAlloc */
