/*
   File: dcg_string.h
   Defines string operations

   Copyright (C) 2008 Marc Seutter

   This library is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published
   by the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with this library.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: dcg_string.h,v 1.11 2008/06/28 13:41:17 marcs Exp $"
*/
#ifndef IncDcgString
#define IncDcgString

/* include string for ops */
#include <string.h>

/* Local includes */
#include "dcg_alloc.h"

/* Introduce type string */
#define MAXSTRLEN 65536
typedef char *string;
#define string_nil ((string) NULL)
#define streq(s1,s2) (strcmp((s1),(s2)) == 0)
#define strlt(s1,s2) (strcmp((s1),(s2)) < 0)

/* Introduce attach/detach ops */
#define attach_string(t) dcg_attach(t)
#define att_string(t) (void) dcg_attach(t)
#define rdup_string(t) dcg_attach(t)
#define detach_string(t) dcg_detach(t)

/* Introduce support ops */
string new_string (char *t);
string alloc_string (char *t);
string concat_string (string t1, string t2);
string new_fmtd_string (char *format, ...);
string alloc_fmtd_string (char *format, ...);
int equal_string_nocase (string t1,string t2);
#define cmp_string(t1,t2) strcmp((t1),(t2))
#define equal_string(t1,t2) streq(t1,t2)

/* Introduce initialization */
void init_string_adm ();

#endif /* IncDcgString */
