/*
   File: dcg.h
   Defines some global definitions

   Copyright (C) 2008 Marc Seutter

   This library is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published   
   by the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU Lesser General Public License
   along with this library.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: dcg.h,v 1.16 2008/06/28 13:41:16 marcs Exp $"
*/
#ifndef IncDcg
#define IncDcg

/*
   Define the 64 bit ints and constants
*/
#if defined(WIN32) && !defined(__MINGW32__)

/* WIN32 with Visual C++ */
typedef unsigned int u_int;
typedef __int64 int64;
typedef unsigned __int64 u_int64;
#define int64_const(x) (x##i64)
#define u_int64_const(x) (x##ui64)

#else

/* MINGW with gcc */
/* Unix with gcc */
#include <sys/types.h>
#if defined(__STRICT_ANSI__) || defined(__MINGW32__)
/* usually present in sys/types.h */
typedef unsigned int u_int;
#endif /* defined(__STRICT_ANSI__) || defined(__MINGW32__) */

typedef long long int int64;
typedef unsigned long long int u_int64;
#define int64_const(x) (x##LL)
#define u_int64_const(x) (x##ULL)

#endif /* defined(WIN32) && !defined(__MINGW32__) */

/* Introduce other types */
typedef double real;
typedef void *vptr;

#define int_nil 0
#define u_int_nil 0
#define int64_nil int64_const(0)
#define u_int64_nil u_int64_const(0)
#define real_nil 0.0
#define char_nil '\0'
#define vptr_nil ((vptr) NULL)

#define detach_int(old) 
#define detach_u_int(old)
#define detach_int64(old) 
#define detach_u_int64(old)
#define detach_real(old) 
#define detach_char(old) 
#define detach_vptr(old)

#define rdup_int(old)  (old)
#define rdup_u_int(old) (old)
#define rdup_int64(old)  (old)
#define rdup_u_int64(old) (old)
#define rdup_real(old)  (old)
#define rdup_char(old)  (old)
#define rdup_vptr(old) (old)

#define cmp_int(a,b)     (((a)<(b))?-1:((a)>(b))?1:0)
#define cmp_u_int(a,b)   (((a)<(b))?-1:((a)>(b))?1:0)
#define cmp_int64(a,b)   (((a)<(b))?-1:((a)>(b))?1:0)
#define cmp_u_int64(a,b) (((a)<(b))?-1:((a)>(b))?1:0)
#define cmp_real(a,b)    (((a)<(b))?-1:((a)>(b))?1:0)
#define cmp_char(a,b)    (((a)<(b))?-1:((a)>(b))?1:0)

#define equal_int(a,b)     ((a) == (b))
#define equal_u_int(a,b)   ((a) == (b))
#define equal_int64(a,b)   ((a) == (b))
#define equal_u_int64(a,b) ((a) == (b))
#define equal_real(a,b)    ((a) == (b))
#define equal_char(a,b)    ((a) == (b))
#define equal_vptr(a,b)    ((a) == (b))

#endif /* IncDcg */
