/*
   File: rts_texts.c
   Provides text engine
*/

/* global includes */
#include <stdio.h>
#include <string.h>

/* local includes */
#include <rts_error.h>
#include <rts_alloc.h>
#include <rts_texts.h>

char *rts_whole_int_int (int v, int width)
	{ char buf[64];				/* should be enough */
	  char *ptr = buf;
	  int len, ix;
	  char *new;

	  /* Do the actual conversion, taking sign and width into account */
	  if (v < 0) { *ptr++ = '-'; v = -v; }
	  else if (width > 0) *ptr++ = '+';
	  sprintf (ptr, "%u", (unsigned) v);

	  /* Calculate the length, if width = 0, just copy */
	  len = strlen (buf);
	  if (!width)
	     { new = rts_malloc (len + 1);		/* include '\0' */
	       strcpy (new, buf);
	       return (new);
	     };

	  /* Allocate for 'width' characters, fill and copy */
	  if (width < 0) width = -width;
	  new = rts_malloc (width + 1);
	  if (width < len)
	     { for (ix = 0; ix < width; ix++) new[ix] = '*';
	       new[width] = '\0';
	     }
	  else
	     { for (ix = 0; ix < width - len; ix++) new[ix] = ' ';
	       strcpy (new + (width - len), buf);
	     };
	  return (new);
	};

