/*
   File: rts_xput.c
   Provides elementary transput
*/

/* global includes */
#include <stdio.h>
#include <ctype.h>
#include <string.h>

/* local includes */
#include <rts_error.h>
#include <rts_alloc.h>
#include <rts_xput.h>

void rts_print_string (char *s)
	{ if (s == NULL)
	     rts_error ("PROC print (STRING) called with uninitialized object");
	  fputs (s, stdout);
	};

void rts_print_nl_string (char *s)
	{ if (s == NULL)
	     rts_error ("PROC print nl (STRING) called with uninitialized object");
	  fprintf (stdout, "%s\n", s);
	};

void rts_get_ref_string (char **s)
	{ char buf[MAXSTRLEN + 1];
	  char *new_string;
	  int len;

	  /* Read a line from stdin, check for exceptions */
	  if (fgets (buf, MAXSTRLEN, stdin) == NULL)
	    rts_error ("I/O error in PROC read (REF STRING)");

	  /* Discard trailing newline */
	  len = strlen (buf);
	  if (buf[len - 1] == '\n')
	    { buf[len - 1] = '\0';
	      len--;
	    };

	  /* Allocate string and copy the buffer */
	  new_string = rts_malloc (len + 1);
	  strcpy (new_string, buf);

	  /* Copy the new string to its destination */
	  if (s == NULL)
	    rts_panic ("PROC read (REF STRING) called with null pointer");
	  rts_detach (s);
	  *s = new_string;
	};

void rts_read_ref_int (int *s)
	{ if (s == NULL)
	    rts_panic ("PROC read (REF INT) called with null pointer");

	  while (1)
	    { char buf[MAXSTRLEN + 1];
	      char *ptr = buf;
	      int value = 0;
	      int has_sign = 0;
	      if (fgets (buf, MAXSTRLEN, stdin) == NULL)
	         rts_error ("I/O error in rts_read_ref_int");
	
	      /* skip leading spaces, parse sign */
	      while (isspace (*ptr)) ptr++;
	      if (*ptr == '-') { has_sign = 1; ptr++; }
	      else if (*ptr == '+') ptr++;

	      if (!isdigit (*ptr))
	         rts_warning ("integer expected in rts_read_ref_int, redo");
	      else
	 	 { while (isdigit (*ptr))
		      { int dig = (*ptr) - '0';
		        value = 10 * value + dig;
			ptr++;
		      };
		   if (has_sign) value = -value;
		   while (isspace (*ptr)) ptr++;
		   if (*ptr) rts_warning ("trailing garbage in rts_read_ref_int, redo");
		   else
		      { *s = value;
			return;
		      };
		 };
	     };
	};

