/*
   File: eag3_test_regexp.c
   Simple test program to check reading and searching lexicon regexps

   Copyright 2011 Radboud University of Nijmegen

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: eag3_test_regexp.c,v 1.2 2012/07/04 11:58:19 marcs Exp $"
*/

/* standard includes */
#include <stdio.h>

/* libdcg includes */
#include <dcg_error.h>
#include <dcg_alloc.h>

/* local includes */
#include <ebase_lexicon.h>
#include <ebase_lexicon_impl.h>
#include <ebase_input.h>
#include <ebase_utils.h>
#include <ebase_regexp_search.h>

static void test_lexicon (Lexicon lex, char *input)
{ LexiconRegexpIterator iter;
  char *inp = input;
  char *end;

  (void) ebs_is_white_spaces (lex, &inp);
  iter = ebs_init_lexicon_regexp_match (lex, inp, RegexpAll);
  while ((end = ebs_next_lexicon_regexp_match (iter)) != NULL)
    { int regexp_nr, regexp_kind, marker;
      char *ptr, *origin;
      ebs_get_lexicon_regexp_match_info (iter, &regexp_nr, &regexp_kind, &marker);
      origin = lex -> rt_regexp_nfas -> array[regexp_nr] -> origin;
      dcg_wlog ("Recognized regexp %d ('%s'), kind %d, marker %d",
		regexp_nr, origin, regexp_kind, marker);
      dcg_eprint ("Matched input: '");
      for (ptr = inp; ptr != end; ptr++) dcg_eprint ("%c", *ptr);
      dcg_wlog ("'");
    };
  ebs_finish_lexicon_regexp_match (&iter);
}

int main (int argc, char **argv)
{ char buffer[256];
  Lexicon my_lex;

  /* Initialize the stuff */
  dcg_init_error (stderr, "eag3 test lexicon tool", NULL);
  dcg_init_alloc ("eag3 test lexicon", 0);
  ebs_read_lexicon (".", (argc > 1)?argv[1]:"npx", &my_lex);

  while (fgets (buffer, 255, stdin) != NULL)
    test_lexicon (my_lex, buffer);
  return (0);
}
