/*
   File: eag3_rt_sizes.c
   Simple program to dump the sizes of the runtime objects

   Copyright 2012 Radboud University of Nijmegen

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: $"
*/

/* standard includes */
#include <stdio.h>

/* libdcg includes */
#include <dcg.h>
#include <dcg_error.h>
#include <dcg_alloc.h>

/* local includes */
#include <ebase_ds.h>

/* libeagrts includes */
#include <erts_handle.h>
#include <erts_trellis.h>
#include <erts_tree.h>
#include <erts_handle_impl.h>
#include <erts_trellis_impl.h>
#include <erts_tree_impl.h>

static void dump_size (char *what, int size)
{ fprintf (stdout, "Size of %s is %d bytes plus 8 bytes admin overhead for a total of %d bytes\n",
           what, size, size + 8);
}

int main ()
{ fprintf (stdout, "\nSizes of parse tree objects\n");
  dump_size ("tree node", sizeof (struct tree_rec));
  dump_size ("position", sizeof (struct position_rec));
  dump_size ("affix expression", sizeof (struct affix_expr_rec));
  dump_size ("affix node", sizeof (struct affix_node_rec));
  dump_size ("affix link", sizeof (struct affix_link_rec));
  dump_size ("affix value", sizeof (struct str_affix_value));
  fprintf (stdout, "\nSizes of trellis objects\n");
  dump_size ("state node", sizeof (struct state_rec));
  dump_size ("transition", sizeof (struct transition_rec));
  dump_size ("trellis", sizeof (struct trellis_rec));
  fprintf (stdout, "\nOther sizes\n");
  dump_size ("eagrts handle", sizeof (struct eagrts_handle_rec));
  return (0);
}
