/*
   File: erun.c
   EAG3 run driver

   Copyright 2012 Marc Seutter

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: erun.c,v 1.5 2012/12/05 14:12:00 marcs Exp $"
*/

/* standard includes */
#include <stdio.h>

/* libdcg includes */
#include <dcg.h>
#include <dcg_error.h>
#include <dcg_alloc.h>

/* libeagbase includes */
#include <ebase_lexicon.h>

/* libeagrts includes */
#include <erts_handle.h>
#include <erts_handle_impl.h>
#include <erts_predefs.h>
#include <erts_main.h>

/* local includes */
#include "erun_options.h"
 
int main (int argc, char **argv)
{ EagrtsHandle hnd;
  dcg_init_error (stderr, "eag3-run", NULL);
  dcg_init_alloc ("eag3-run", 0);

  /* Initialize the parameters structure and parse the command line */
  hnd = erts_init_handle ();
  parse_command_line (hnd, argc, argv);

  /* Load the lexicon, grammar pragmats/options and coded grammar */
  ebs_read_lexicon (hnd -> dir_name, hnd -> grammar_name, &hnd -> lexicon); 
  erts_read_runtime_information (hnd);
  erts_resolve_predefs (hnd);

  /* Overrule the pragmats from the compiler */
  overrule_grammar_options (hnd);
  try_show_options (hnd);

  /* All prepared, start to parse */
  erts_main (hnd);

  /* Done */
  /* erts_release_handle (&hnd); */
  return (0);
}
