/*
   File: erts_trellis.h
   Defines the basic trellis code for the EAG3 runtime system.

   Copyright 2012 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: erts_trellis.h,v 1.14 2013/03/13 14:32:49 marcs Exp $"
*/

#ifndef IncErtsTrellis
#define IncErtsTrellis

/* libeagbase includes */
#include <ebase_input.h>
#include <ebase_lexicon.h>

/* local includes */
#include "erts_handle.h"

/* Define State, Transition and Trellis as opaque types */
typedef struct state_rec *State;
typedef struct transition_rec *Transition;
typedef struct trellis_rec *Trellis;

#define state_nil ((State) NULL)
#define transition_nil ((Transition) NULL)
#define trellis_nil ((Trellis) NULL)

/* Define the top level trellis functions */
State erts_init_trellis (EagrtsHandle hnd, char *input, int length, int linenr, int colnr);
State erts_determine_next_start_state (EagrtsHandle hnd);
void erts_set_start_state (EagrtsHandle hnd, State start_state);
void erts_release_trellis (EagrtsHandle hnd);

/* Define the scanner functions */
State erts_handle_epsilon_transition (Trellis trel, State state);
State erts_handle_glue (Trellis trel, State state);
int erts_state_matches_separator (Trellis trel, State state);
void erts_scan_phases (Trellis trel, State state, uchar max_phase);
Transition erts_scan_eos_transition (Trellis trel, State state);
void erts_scan_any_transition (Trellis trel, State state);
void erts_write_transition (Lexicon lex, Transition trans);
void erts_write_trellis_state (State state);
void erts_dump_trellis (Trellis trel);

#endif /* IncErtsTrellis */
