/*
   File: erts_tree.h
   Defines the data structures necessary to store the parse tree,
   affix positions and propagation links. Defines the functions
   necessary to build the parse tree.

   Copyright 2012 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: erts_tree.h,v 1.17 2013/01/11 14:52:05 marcs Exp $"
*/
#ifndef IncErtsTree
#define IncErtsTree

/* libebase includes */
#include <ebase_ds.h>

#include "erts_handle.h"
#include "erts_trellis.h"

/* Introduce parse trees, positions, affix nodes and links as opaque types */
typedef struct tree_rec *Tree;
typedef struct position_rec *Position;
typedef struct affix_expr_rec *AffixExpr;
typedef struct affix_node_rec *AffixNode;
typedef struct affix_link_rec *AffixLink;

/* Introduce null pointers */
#define tree_nil ((Tree) NULL)
#define trees_nil ((Tree *) NULL)
#define position_nil ((Position) NULL)
#define positions_nil ((Position *) NULL)
#define affix_expr_nil ((AffixExpr) NULL)
#define affix_node_nil ((AffixNode) NULL)
#define affix_link_nil ((AffixLink) NULL)
#define affix_exprs_nil ((AffixExpr *) NULL)
#define affix_frame_nil ((AffixNode *) NULL)

/* Building affix nodes */
AffixNode erts_make_affix_from_value (char *name, affix_value value);
AffixNode erts_make_affix_from_constant (char *name, EagrtsHandle hnd, int nr);

/* Type of delayed evaluation proc */
typedef void (*DelayedEvalFunc)(EagrtsHandle, Position *);
#define delayed_eval_func_nil ((DelayedEvalFunc) NULL)

/* Functions for parsing */
void erts_make_affix_link (EagrtsHandle hnd);
void erts_make_normal_node (EagrtsHandle hnd, int node_nr, int nr_sons, int nr_pos,
			    AffixNode *frame);
void erts_make_simple_node (EagrtsHandle hnd, int node_nr, int nr_sons, AffixNode *frame);
void erts_make_anonymous_node (EagrtsHandle hnd, int node_nr, int nr_sons, AffixNode *frame);
void erts_make_predicate_node (EagrtsHandle hnd, int node_nr, int nr_pos, AffixNode *frame,
			       DelayedEvalFunc delayed_func);
void erts_make_penalty_node (EagrtsHandle hnd, int delta_penalty);
void erts_make_confrontation_node (EagrtsHandle hnd, propagation_kind kind);
void erts_make_leaf_node (EagrtsHandle hnd, Transition trans, int nr_pos);
void erts_make_quasi_node (EagrtsHandle hnd, int quasi_nr, affix_value value, int nr_pos);
void erts_make_lex_nont_node (EagrtsHandle hnd, Transition trans);
void erts_update_predicate_node (EagrtsHandle hnd, Tree node, int nr_sons, AffixNode *frame);
void erts_link_predicate_son (EagrtsHandle hnd);
void erts_link_son (EagrtsHandle hnd);
void erts_exchange_top (EagrtsHandle hnd);
AffixNode *erts_locate_frame (EagrtsHandle hnd, int nodenr);

#endif /* IncErtsTree */
