/*
   File: erts_trace.h
   Defines tracing support

   Copyright 2012 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: "
*/
#ifndef IncErtsTrace
#define IncErtsTrace

#include "erts_trellis.h"
#include "erts_handle.h"

/* Routines to trace the 1st level */
void erts_trace_enter_function (EagrtsHandle hnd, char *function_name, int nont_nr);
void erts_trace_alternative (EagrtsHandle hnd, int nont_nr, int alt_nr);
void erts_trace_leave_function (EagrtsHandle hnd, char *function_name, int nont_nr);
void erts_trace_enter_transition (EagrtsHandle hnd, Transition trans);
void erts_trace_leave_transition (EagrtsHandle hnd, Transition trans);

/* Routines to trace the linking of affixes and sons */
void erts_trace_tree_node (EagrtsHandle hnd, Tree tree);
void erts_trace_enter_make_affix_link (EagrtsHandle hnd, Tree son_tree);
void erts_trace_leave_make_affix_link (EagrtsHandle hnd, Tree son_tree);
void erts_trace_enter_link_son (EagrtsHandle hnd, Tree son_tree, int sonnr);
void erts_trace_leave_link_son (EagrtsHandle hnd, Tree son_tree, int sonnr);

/* Routines to trace affix propagation */
void erts_trace_position (EagrtsHandle hnd, Position pos);
void erts_trace_restriction (EagrtsHandle hnd, Position pos, affix_value meet_value);

#endif /* IncErtsTrace */
