/*
   File: erts_predefs.h
   Defines the predefined predicates for the EAG3 runtime system.
   It also handles all quasi terminals that are not linked to transitions.

   Copyright 2012 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: erts_predefs.h,v 1.2 2013/01/11 14:52:03 marcs Exp $"
*/

#ifndef IncErtsPredefs
#define IncErtsPredefs

/* local includes */
#include "erts_handle.h"

/* Predefined quasi terminals */
char *name_from_quasi (int quasi_nr);
void erts_yield_line (EagrtsHandle hnd);
void erts_yield_column (EagrtsHandle hnd);
void erts_yield_pos (EagrtsHandle hnd);
void erts_match_separator (EagrtsHandle hnd);

/* Predefined predicates */
void erts_resolve_predefs (EagrtsHandle hnd);
void erts_convert_int_to_text (EagrtsHandle hnd);
void erts_convert_text_to_int (EagrtsHandle hnd);
void erts_convert_real_to_text (EagrtsHandle hnd);
void erts_convert_text_to_real (EagrtsHandle hnd);

#endif /* IncErtsPredefs */
