/*
   File: erts_memory.h
   Maintains free lists for all really dynamic objects in the runtime system

   Copyright 2012 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: erts_memory.h,v 1.2 2012/10/31 16:07:13 marcs Exp $"
*/
#ifndef IncErtsMemory
#define IncErtsMemory

#include "erts_tree.h"

/* Allocation of tree nodes */
Tree erts_make_tree_node (tree_kind kind, int number);
void erts_free_tree_node (Tree old_tree);

/* Allocation of tree sons */
Tree *erts_make_tree_sons (int nr_sons);
void erts_free_tree_sons (Tree *old_sons, int nr_sons);

/* Allocation of affix positions */
Position erts_make_affix_position (Tree my_tree);
void erts_free_affix_position (Position old_position);

/* Allocation of affix position space */
Position *erts_make_affix_positions (int nr_pos);
void erts_free_affix_positions (Position *old_pos, int nr_pos);

/* Allocation of affix expr nodes */
AffixExpr erts_make_affix_expr (affix_expr_kind kind);
void erts_free_affix_expr (AffixExpr old_expr);

/* Allocation of affix expr space */
AffixExpr *erts_make_affix_expressions (int nr_exp);
void erts_free_affix_expressions (AffixExpr *old_exprs, int nr_exp);

/* Allocation of affix nodes */
AffixNode erts_make_affix_node (char *name);
void erts_free_affix_node (AffixNode old_node);

/* Allocation of affix frames */
AffixNode *erts_make_affix_frame (int nr);
void erts_free_affix_frame (AffixNode *old_frame, int nr);

/* Allocation of affix links */
AffixLink erts_make_link_node ();
void erts_free_link_node (AffixLink old_link);

void erts_dump_memory ();
void erts_init_memory ();

#endif /* IncErtsMemory */
