/*
   File: ebase_utils.h
   Utilities used by all

   Copyright (C) 2012 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: ebase_utils.h,v 1.7 2012/12/27 17:59:49 marcs Exp $
*/
#ifndef IncEbaseUtils
#define IncEbaseUtils

/* libdcg, libdcg2 includes */
#include <dcg.h>
#include <dcg_plist.h>
#include <dcg_dstring.h>

/* local includes */
#include "ebase_ds.h"
#include "ebase_lexicon.h"

/* Exported conversions */
char *ebs_string_from_operator (operator op);
char *ebs_string_from_propagation_kind (propagation_kind kind);

/* Non utf8 conversion */
char *ebs_convert_non_utf8_string (int_list char_encs);

/* UTF8 conversions */
char *ebs_convert_utf8_char (int char_enc);
char *ebs_convert_utf8_string (int_list char_encs);
string_list ebs_convert_utf8_chars (int_list char_encs);

/* Debugging support */
void ebs_dump_text (FILE *info, char *text);
void ebs_dump_text_from_to (FILE *info, char *from, char *to);
void ebs_dump_affix_value (FILE *info, affix_value value, rt_domain_list domains);
void ebs_dump_domain (FILE *info, int idx, rt_domain dom, int wval);
void ebs_dump_type (FILE *info, rt_type rt, int wval);
void ebs_dump_lex_nont (FILE *info, lex_nont nont);
void ebs_dump_call (FILE *info, Lexicon lex, int call_id);

#endif /* IncEbaseUtils */
