/*
   File: ebase_hash.c
   Simple collection of hash functions

   Copyright (C) 2012 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: ebase_hash.c,v 1.1 2012/04/21 16:22:44 marcs Exp $"
*/

/* standard includes */
#include <stdio.h>
#include <math.h>
#include <stdlib.h>

/* Local includes */
#include "ebase_hash.h"

/*
   Create hash functions for INTs, REALs and TEXTs
*/
int ebs_hash_int (int nr, int hsize)
{ unsigned result = ((unsigned) nr) % ((unsigned) hsize);
  return ((int) result);        /* and known to in 0..hsize - 1 */
}

int ebs_hash_real (double nr, int hsize)
{ double off01 = floor ((atan (nr) + M_PI_2)/M_PI * hsize);
  return (ebs_hash_int ((int) off01, hsize));
}

unsigned int ebs_hash_continued_int (int k, unsigned int value)
{ return (value + 13 * (unsigned int ) k);
}

unsigned int ebs_hash_continued_text (char *s, unsigned int value)
{ char *ptr;
  for (ptr = s; *ptr; ptr++) value = (131 * value + ((unsigned int) (*ptr))) & 0x7ffffff;
  return (value);
}

int ebs_hash_text (char *s, int hsize)
{ unsigned value = ebs_hash_continued_text (s, 0);
  unsigned result = value % ((unsigned) hsize);
  return ((int) result);        /* and known to in 0..hsize -1 */
}

int ebs_hash_search_key (int_list key, int hsize)
{ unsigned int value = 0;
  int ix;
  for (ix = 0; ix < key -> size; ix++)
    value = (127 * value + ((unsigned int) key -> array[ix] & 0xffffff)) & 0xffffff;
  return ((int) value % hsize);
}


