/*
   File: ebase_fact_table.h
   Stores a fact table (by which we mean the datastructure through which
   facts can be entered with their appropriate information) for later
   retrieval. Since the number of individual facts in a fact table may
   easily be of the order of one million, the fact table is stored as
   a hash table. The triple database is stored is an implicit extra fact
   table whose resultant lookup directly results in a frequency instead
   of an entry list index.

   Copyright 2012 Marc Seutter
 
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: ebase_fact_table.h,v 1.3 2012/07/27 09:30:22 marcs Exp $"
*/
#ifndef IncEbaseFactTable
#define IncEbaseFactTable

/* libdcg includes */
#include <dcg.h>
#include <dcg_binfile.h>

/* local includes */
#include "ebase_lexicon.h"

/* Export FactTable as a struct pointer */
typedef struct fact_table_rec
{ int hash_size;		/* A bit redundant */
  int lex_nont_nr;		/* Maps into rt nont table */
  int_list *buckets;		/* A bit more compressed */
} *FactTable;
#define fact_table_nil ((FactTable) NULL)

/* Exported code */
int ebs_lookup_critical_text (Lexicon lex, char *text);

#endif /* IncEbaseFactTable */
