/*
   File: ebase_ds.h
   Generated on Sat Apr 13 13:13:03 2013
*/
#ifndef IncEbase_ds
#define IncEbase_ds

/* standard includes */
#include <stdio.h>

/* support lib includes */
#include <dcg.h>
#include <dcg_alloc.h>
#include <dcg_string.h>
#include <dcg_binfile.h>

/* Introduce record type definitions */
typedef struct str_affix_value *affix_value;
typedef struct str_rt_element *rt_element;
typedef struct str_rt_domain *rt_domain;
typedef struct str_rt_elem *rt_elem;
typedef struct str_rt_alt *rt_alt;
typedef struct str_rt_type *rt_type;
typedef struct str_cset_part *cset_part;
typedef struct str_cset *cset;
typedef struct str_terminal *terminal;
typedef struct str_nfa_state *nfa_state;
typedef struct str_nfa_trans *nfa_trans;
typedef struct str_nfa *nfa;
typedef struct str_lex_nont *lex_nont;
typedef struct str_rt_nont *rt_nont;
typedef struct str_ext_nont *ext_nont;
typedef struct str_director_set *director_set;
typedef struct str_trans_pair *trans_pair;

/* Introduce type_list definitions */
typedef struct str_affix_value_list *affix_value_list;
typedef struct str_rt_element_list *rt_element_list;
typedef struct str_rt_domain_list *rt_domain_list;
typedef struct str_rt_elem_list *rt_elem_list;
typedef struct str_rt_alt_list *rt_alt_list;
typedef struct str_rt_type_list *rt_type_list;
typedef struct str_cset_part_list *cset_part_list;
typedef struct str_cset_list *cset_list;
typedef struct str_terminal_list *terminal_list;
typedef struct str_nfa_state_list *nfa_state_list;
typedef struct str_nfa_trans_list *nfa_trans_list;
typedef struct str_nfa_list *nfa_list;
typedef struct str_lex_nont_list *lex_nont_list;
typedef struct str_rt_nont_list *rt_nont_list;
typedef struct str_ext_nont_list *ext_nont_list;
typedef struct str_trans_pair_list *trans_pair_list;
typedef struct str_int_list_list *int_list_list;
typedef struct str_u_int64_list *u_int64_list;

/* Introduce enumeration types */
typedef enum
{ normal_node, simple_node, anonymous_node,
  leaf_node, lex_nont_node, predicate_node,
  confrontation_node, penalty_node, quasi_node
} tree_kind;

typedef enum
{ single_affix_node, ast_node, concat_node,
  dyop_arith_node, monop_arith_node
} affix_expr_kind;

typedef enum
{ p_bidirectional, p_left_to_right, p_lower_to_upper,
  p_equal, p_unequal, p_restrict
} propagation_kind;

typedef enum
{ times, modulo, divides,
  plus, minus, a_union,
  a_part, shift_left, shift_right,
  bitwise_xor, bitwise_not, bitwise_or,
  bitwise_and, int_times_int, real_times_real,
  int_times_text, int_plus_int, real_plus_real,
  text_plus_text, int_minus_int, real_minus_real
} operator;

/* Include imported defs */
#include <dcg_plist.h>

/* Introduce record nils */
#define affix_value_nil ((affix_value) NULL)
#define rt_element_nil ((rt_element) NULL)
#define rt_domain_nil ((rt_domain) NULL)
#define rt_elem_nil ((rt_elem) NULL)
#define rt_alt_nil ((rt_alt) NULL)
#define rt_type_nil ((rt_type) NULL)
#define cset_part_nil ((cset_part) NULL)
#define cset_nil ((cset) NULL)
#define terminal_nil ((terminal) NULL)
#define nfa_state_nil ((nfa_state) NULL)
#define nfa_trans_nil ((nfa_trans) NULL)
#define nfa_nil ((nfa) NULL)
#define lex_nont_nil ((lex_nont) NULL)
#define rt_nont_nil ((rt_nont) NULL)
#define ext_nont_nil ((ext_nont) NULL)
#define director_set_nil ((director_set) NULL)
#define trans_pair_nil ((trans_pair) NULL)

/* Introduce type_list nils */
#define affix_value_list_nil ((affix_value_list) NULL)
#define rt_element_list_nil ((rt_element_list) NULL)
#define rt_domain_list_nil ((rt_domain_list) NULL)
#define rt_elem_list_nil ((rt_elem_list) NULL)
#define rt_alt_list_nil ((rt_alt_list) NULL)
#define rt_type_list_nil ((rt_type_list) NULL)
#define cset_part_list_nil ((cset_part_list) NULL)
#define cset_list_nil ((cset_list) NULL)
#define terminal_list_nil ((terminal_list) NULL)
#define nfa_state_list_nil ((nfa_state_list) NULL)
#define nfa_trans_list_nil ((nfa_trans_list) NULL)
#define nfa_list_nil ((nfa_list) NULL)
#define lex_nont_list_nil ((lex_nont_list) NULL)
#define rt_nont_list_nil ((rt_nont_list) NULL)
#define ext_nont_list_nil ((ext_nont_list) NULL)
#define trans_pair_list_nil ((trans_pair_list) NULL)
#define int_list_list_nil ((int_list_list) NULL)
#define u_int64_list_nil ((u_int64_list) NULL)

/* Introduce enumeration nils */
#define tree_kind_nil ((tree_kind) 0)
#define affix_expr_kind_nil ((affix_expr_kind) 0)
#define propagation_kind_nil ((propagation_kind) 0)
#define operator_nil ((operator) 0)

/* introduce constructors */
#define Null_value u.ue_Null_value
#define Text_value u.ue_Text_value
#define Int_value u.ue_Int_value
#define Real_value u.ue_Real_value
#define Small_lattice u.ue_Small_lattice
#define Large_lattice u.ue_Large_lattice
#define List_lattice u.ue_List_lattice
#define Composed_value u.ue_Composed_value
#define Marker u.ue_Marker
#define Ref u.ue_Ref
#define Synonym_type u.ue_Synonym_type
#define Any_type u.ue_Any_type
#define Int_type u.ue_Int_type
#define Real_type u.ue_Real_type
#define Text_type u.ue_Text_type
#define Lattice_type u.ue_Lattice_type
#define Tree_type u.ue_Tree_type
#define Part_match u.ue_Part_match
#define Part_range u.ue_Part_range
#define Trans_char u.ue_Trans_char
#define Trans_cset u.ue_Trans_cset
#define Trans_anychar u.ue_Trans_anychar
#define Trans_whitespace u.ue_Trans_whitespace
#define Trans_nonwhitespace u.ue_Trans_nonwhitespace
#define Trans_empty u.ue_Trans_empty

/* Introduce constructor tags */
typedef enum en_tags_affix_value
{ TAGNull_value,
  TAGText_value,
  TAGInt_value,
  TAGReal_value,
  TAGSmall_lattice,
  TAGLarge_lattice,
  TAGList_lattice,
  TAGComposed_value
} tags_affix_value;

typedef enum en_tags_rt_elem
{ TAGMarker,
  TAGRef
} tags_rt_elem;

typedef enum en_tags_rt_type
{ TAGSynonym_type,
  TAGAny_type,
  TAGInt_type,
  TAGReal_type,
  TAGText_type,
  TAGLattice_type,
  TAGTree_type
} tags_rt_type;

typedef enum en_tags_cset_part
{ TAGPart_match,
  TAGPart_range
} tags_cset_part;

typedef enum en_tags_nfa_trans
{ TAGTrans_char,
  TAGTrans_cset,
  TAGTrans_anychar,
  TAGTrans_whitespace,
  TAGTrans_nonwhitespace,
  TAGTrans_empty
} tags_nfa_trans;

/* Introduce structure for constructor Text_value */
typedef struct str_Text_value
{ string text;
} C_Text_value;

/* Introduce structure for constructor Int_value */
typedef struct str_Int_value
{ int ival;
} C_Int_value;

/* Introduce structure for constructor Real_value */
typedef struct str_Real_value
{ real rval;
} C_Real_value;

/* Introduce structure for constructor Small_lattice */
typedef struct str_Small_lattice
{ int dom;
  u_int64 slat;
} C_Small_lattice;

/* Introduce structure for constructor Large_lattice */
typedef struct str_Large_lattice
{ int dom;
  u_int64_list llat;
} C_Large_lattice;

/* Introduce structure for constructor List_lattice */
typedef struct str_List_lattice
{ int_list llat;
} C_List_lattice;

/* Introduce structure for constructor Composed_value */
typedef struct str_Composed_value
{ int marker;
  affix_value_list parts;
} C_Composed_value;

/* Introduce structure for constructor Marker */
typedef struct str_Marker
{ string txt;
} C_Marker;

/* Introduce structure for constructor Ref */
typedef struct str_Ref
{ int rnr;
} C_Ref;

/* Introduce structure for constructor Synonym_type */
typedef struct str_Synonym_type
{ int snr;
} C_Synonym_type;

/* Introduce structure for constructor Lattice_type */
typedef struct str_Lattice_type
{ int dom;
} C_Lattice_type;

/* Introduce structure for constructor Tree_type */
typedef struct str_Tree_type
{ rt_alt_list alts;
} C_Tree_type;

/* Introduce structure for constructor Part_match */
typedef struct str_Part_match
{ int ch;
} C_Part_match;

/* Introduce structure for constructor Part_range */
typedef struct str_Part_range
{ int first;
  int last;
} C_Part_range;

/* Introduce structure for constructor Trans_char */
typedef struct str_Trans_char
{ int ch;
} C_Trans_char;

/* Introduce structure for constructor Trans_cset */
typedef struct str_Trans_cset
{ int cs;
} C_Trans_cset;

/* Introduce structure of type affix_value */
struct str_affix_value
{ int rule_nr;
  tags_affix_value tag;
  union uni_affix_value
    { C_Text_value ue_Text_value;
      C_Int_value ue_Int_value;
      C_Real_value ue_Real_value;
      C_Small_lattice ue_Small_lattice;
      C_Large_lattice ue_Large_lattice;
      C_List_lattice ue_List_lattice;
      C_Composed_value ue_Composed_value;
    } u;
};

/* Introduce structure of type rt_element */
struct str_rt_element
{ string name;
  affix_value value;
};

/* Introduce structure of type rt_domain */
struct str_rt_domain
{ int width;
  rt_element_list elts;
};

/* Introduce structure of type rt_elem */
struct str_rt_elem
{ tags_rt_elem tag;
  union uni_rt_elem
    { C_Marker ue_Marker;
      C_Ref ue_Ref;
    } u;
};

/* Introduce structure of type rt_alt */
struct str_rt_alt
{ int marker;
  rt_elem_list elems;
};

/* Introduce structure of type rt_type */
struct str_rt_type
{ int rule_nr;
  string name;
  int lexgen;
  affix_value value;
  vptr print_code;
  vptr meta_code;
  vptr meta_rec_code;
  tags_rt_type tag;
  union uni_rt_type
    { C_Synonym_type ue_Synonym_type;
      C_Lattice_type ue_Lattice_type;
      C_Tree_type ue_Tree_type;
    } u;
};

/* Introduce structure of type cset_part */
struct str_cset_part
{ tags_cset_part tag;
  union uni_cset_part
    { C_Part_match ue_Part_match;
      C_Part_range ue_Part_range;
    } u;
};

/* Introduce structure of type cset */
struct str_cset
{ int invert;
  cset_part_list parts;
};

/* Introduce structure of type terminal */
struct str_terminal
{ int marker;
  int_list text;
  string origin;
};

/* Introduce structure of type nfa_state */
struct str_nfa_state
{ int self;
  int final;
  nfa_trans_list transitions;
  int indeg;
};

/* Introduce structure of type nfa_trans */
struct str_nfa_trans
{ int dest;
  tags_nfa_trans tag;
  union uni_nfa_trans
    { C_Trans_char ue_Trans_char;
      C_Trans_cset ue_Trans_cset;
    } u;
};

/* Introduce structure of type nfa */
struct str_nfa
{ int kind;
  int marker;
  string origin;
  nfa_state_list states;
};

/* Introduce structure of type lex_nont */
struct str_lex_nont
{ int rule_nr;
  int fact_nr;
  string_list name_parts;
  int_list name_chars;
  int ncrits;
  int_list formals;
  int_list crits;
};

/* Introduce structure of type rt_nont */
struct str_rt_nont
{ string_list name_parts;
  int_list name_chars;
  string canonic_name;
  int_list formals;
  int lex_nr;
};

/* Introduce structure of type ext_nont */
struct str_ext_nont
{ string canonic_name;
  int rule_nr;
};

/* Introduce structure of type director_set */
struct str_director_set
{ int min_phase;
  trans_pair_list set;
};

/* Introduce structure of type trans_pair */
struct str_trans_pair
{ int class;
  int number;
};

/* Introduce structure of type affix_value_list */
struct str_affix_value_list
{ int size;
  int room;
  affix_value *array;
};

/* Introduce structure of type rt_element_list */
struct str_rt_element_list
{ int size;
  int room;
  rt_element *array;
};

/* Introduce structure of type rt_domain_list */
struct str_rt_domain_list
{ int size;
  int room;
  rt_domain *array;
};

/* Introduce structure of type rt_elem_list */
struct str_rt_elem_list
{ int size;
  int room;
  rt_elem *array;
};

/* Introduce structure of type rt_alt_list */
struct str_rt_alt_list
{ int size;
  int room;
  rt_alt *array;
};

/* Introduce structure of type rt_type_list */
struct str_rt_type_list
{ int size;
  int room;
  rt_type *array;
};

/* Introduce structure of type cset_part_list */
struct str_cset_part_list
{ int size;
  int room;
  cset_part *array;
};

/* Introduce structure of type cset_list */
struct str_cset_list
{ int size;
  int room;
  cset *array;
};

/* Introduce structure of type terminal_list */
struct str_terminal_list
{ int size;
  int room;
  terminal *array;
};

/* Introduce structure of type nfa_state_list */
struct str_nfa_state_list
{ int size;
  int room;
  nfa_state *array;
};

/* Introduce structure of type nfa_trans_list */
struct str_nfa_trans_list
{ int size;
  int room;
  nfa_trans *array;
};

/* Introduce structure of type nfa_list */
struct str_nfa_list
{ int size;
  int room;
  nfa *array;
};

/* Introduce structure of type lex_nont_list */
struct str_lex_nont_list
{ int size;
  int room;
  lex_nont *array;
};

/* Introduce structure of type rt_nont_list */
struct str_rt_nont_list
{ int size;
  int room;
  rt_nont *array;
};

/* Introduce structure of type ext_nont_list */
struct str_ext_nont_list
{ int size;
  int room;
  ext_nont *array;
};

/* Introduce structure of type trans_pair_list */
struct str_trans_pair_list
{ int size;
  int room;
  trans_pair *array;
};

/* Introduce structure of type int_list_list */
struct str_int_list_list
{ int size;
  int room;
  int_list *array;
};

/* Introduce structure of type u_int64_list */
struct str_u_int64_list
{ int size;
  int room;
  u_int64 *array;
};

/* Introduce list allocation routines */
affix_value_list init_affix_value_list (int room);
rt_element_list init_rt_element_list (int room);
rt_domain_list init_rt_domain_list (int room);
rt_elem_list init_rt_elem_list (int room);
rt_alt_list init_rt_alt_list (int room);
rt_type_list init_rt_type_list (int room);
cset_part_list init_cset_part_list (int room);
cset_list init_cset_list (int room);
terminal_list init_terminal_list (int room);
nfa_state_list init_nfa_state_list (int room);
nfa_trans_list init_nfa_trans_list (int room);
nfa_list init_nfa_list (int room);
lex_nont_list init_lex_nont_list (int room);
rt_nont_list init_rt_nont_list (int room);
ext_nont_list init_ext_nont_list (int room);
trans_pair_list init_trans_pair_list (int room);
int_list_list init_int_list_list (int room);
u_int64_list init_u_int64_list (int room);

/* Introduce room allocation routines */
void room_affix_value_list (affix_value_list l, int room);
void room_rt_element_list (rt_element_list l, int room);
void room_rt_domain_list (rt_domain_list l, int room);
void room_rt_elem_list (rt_elem_list l, int room);
void room_rt_alt_list (rt_alt_list l, int room);
void room_rt_type_list (rt_type_list l, int room);
void room_cset_part_list (cset_part_list l, int room);
void room_cset_list (cset_list l, int room);
void room_terminal_list (terminal_list l, int room);
void room_nfa_state_list (nfa_state_list l, int room);
void room_nfa_trans_list (nfa_trans_list l, int room);
void room_nfa_list (nfa_list l, int room);
void room_lex_nont_list (lex_nont_list l, int room);
void room_rt_nont_list (rt_nont_list l, int room);
void room_ext_nont_list (ext_nont_list l, int room);
void room_trans_pair_list (trans_pair_list l, int room);
void room_int_list_list (int_list_list l, int room);
void room_u_int64_list (u_int64_list l, int room);

/* Introduce list allocation shorthands */
#define new_affix_value_list() init_affix_value_list(2)
#define new_rt_element_list() init_rt_element_list(2)
#define new_rt_domain_list() init_rt_domain_list(2)
#define new_rt_elem_list() init_rt_elem_list(2)
#define new_rt_alt_list() init_rt_alt_list(2)
#define new_rt_type_list() init_rt_type_list(2)
#define new_cset_part_list() init_cset_part_list(2)
#define new_cset_list() init_cset_list(2)
#define new_terminal_list() init_terminal_list(2)
#define new_nfa_state_list() init_nfa_state_list(2)
#define new_nfa_trans_list() init_nfa_trans_list(2)
#define new_nfa_list() init_nfa_list(2)
#define new_lex_nont_list() init_lex_nont_list(2)
#define new_rt_nont_list() init_rt_nont_list(2)
#define new_ext_nont_list() init_ext_nont_list(2)
#define new_trans_pair_list() init_trans_pair_list(2)
#define new_int_list_list() init_int_list_list(2)
#define new_u_int64_list() init_u_int64_list(2)

/* Introduce type allocation routines */
affix_value new_Null_value (int rule_nr);
affix_value new_Text_value (int rule_nr,
		string text);
affix_value new_Int_value (int rule_nr,
		int ival);
affix_value new_Real_value (int rule_nr,
		real rval);
affix_value new_Small_lattice (int rule_nr,
		int dom, u_int64 slat);
affix_value new_Large_lattice (int rule_nr,
		int dom, u_int64_list llat);
affix_value new_List_lattice (int rule_nr,
		int_list llat);
affix_value new_Composed_value (int rule_nr,
		int marker, affix_value_list parts);
rt_element new_rt_element (string name, affix_value value);
rt_domain new_rt_domain (int width, rt_element_list elts);
rt_elem new_Marker (string txt);
rt_elem new_Ref (int rnr);
rt_alt new_rt_alt (int marker, rt_elem_list elems);
rt_type new_Synonym_type (int rule_nr, string name, int lexgen, affix_value value,
		int snr);
rt_type new_Any_type (int rule_nr, string name, int lexgen, affix_value value);
rt_type new_Int_type (int rule_nr, string name, int lexgen, affix_value value);
rt_type new_Real_type (int rule_nr, string name, int lexgen, affix_value value);
rt_type new_Text_type (int rule_nr, string name, int lexgen, affix_value value);
rt_type new_Lattice_type (int rule_nr, string name, int lexgen, affix_value value,
		int dom);
rt_type new_Tree_type (int rule_nr, string name, int lexgen, affix_value value,
		rt_alt_list alts);
cset_part new_Part_match (int ch);
cset_part new_Part_range (int first, int last);
cset new_cset (int invert, cset_part_list parts);
terminal new_terminal (int marker, int_list text, string origin);
nfa_state new_nfa_state (int self, int final, nfa_trans_list transitions);
nfa_trans new_Trans_char (int dest,
		int ch);
nfa_trans new_Trans_cset (int dest,
		int cs);
nfa_trans new_Trans_anychar (int dest);
nfa_trans new_Trans_whitespace (int dest);
nfa_trans new_Trans_nonwhitespace (int dest);
nfa_trans new_Trans_empty (int dest);
nfa new_nfa (int kind, int marker, string origin, nfa_state_list states);
lex_nont new_lex_nont (int rule_nr, int fact_nr, string_list name_parts, int_list name_chars, int ncrits, int_list formals, int_list crits);
rt_nont new_rt_nont (string_list name_parts, int_list name_chars, string canonic_name, int_list formals, int lex_nr);
ext_nont new_ext_nont (string canonic_name, int rule_nr);
director_set new_director_set (int min_phase, trans_pair_list set);
trans_pair new_trans_pair (int class, int number);

/* Introduce attaching of types */
#define attach_affix_value(orig)(affix_value) dcg_attach ((char *) orig)
#define att_affix_value(orig)(void) dcg_attach ((char *) orig)
#define attach_rt_element(orig)(rt_element) dcg_attach ((char *) orig)
#define att_rt_element(orig)(void) dcg_attach ((char *) orig)
#define attach_rt_domain(orig)(rt_domain) dcg_attach ((char *) orig)
#define att_rt_domain(orig)(void) dcg_attach ((char *) orig)
#define attach_rt_elem(orig)(rt_elem) dcg_attach ((char *) orig)
#define att_rt_elem(orig)(void) dcg_attach ((char *) orig)
#define attach_rt_alt(orig)(rt_alt) dcg_attach ((char *) orig)
#define att_rt_alt(orig)(void) dcg_attach ((char *) orig)
#define attach_rt_type(orig)(rt_type) dcg_attach ((char *) orig)
#define att_rt_type(orig)(void) dcg_attach ((char *) orig)
#define attach_cset_part(orig)(cset_part) dcg_attach ((char *) orig)
#define att_cset_part(orig)(void) dcg_attach ((char *) orig)
#define attach_cset(orig)(cset) dcg_attach ((char *) orig)
#define att_cset(orig)(void) dcg_attach ((char *) orig)
#define attach_terminal(orig)(terminal) dcg_attach ((char *) orig)
#define att_terminal(orig)(void) dcg_attach ((char *) orig)
#define attach_nfa_state(orig)(nfa_state) dcg_attach ((char *) orig)
#define att_nfa_state(orig)(void) dcg_attach ((char *) orig)
#define attach_nfa_trans(orig)(nfa_trans) dcg_attach ((char *) orig)
#define att_nfa_trans(orig)(void) dcg_attach ((char *) orig)
#define attach_nfa(orig)(nfa) dcg_attach ((char *) orig)
#define att_nfa(orig)(void) dcg_attach ((char *) orig)
#define attach_lex_nont(orig)(lex_nont) dcg_attach ((char *) orig)
#define att_lex_nont(orig)(void) dcg_attach ((char *) orig)
#define attach_rt_nont(orig)(rt_nont) dcg_attach ((char *) orig)
#define att_rt_nont(orig)(void) dcg_attach ((char *) orig)
#define attach_ext_nont(orig)(ext_nont) dcg_attach ((char *) orig)
#define att_ext_nont(orig)(void) dcg_attach ((char *) orig)
#define attach_tree_kind(orig) (orig)
#define att_tree_kind(orig)
#define attach_affix_expr_kind(orig) (orig)
#define att_affix_expr_kind(orig)
#define attach_propagation_kind(orig) (orig)
#define att_propagation_kind(orig)
#define attach_operator(orig) (orig)
#define att_operator(orig)
#define attach_director_set(orig)(director_set) dcg_attach ((char *) orig)
#define att_director_set(orig)(void) dcg_attach ((char *) orig)
#define attach_trans_pair(orig)(trans_pair) dcg_attach ((char *) orig)
#define att_trans_pair(orig)(void) dcg_attach ((char *) orig)

/* Introduce attaching of lists */
#define attach_affix_value_list(orig) (affix_value_list) dcg_attach ((char *) orig)
#define att_affix_value_list(orig) (void) dcg_attach ((char *) orig)
#define attach_rt_element_list(orig) (rt_element_list) dcg_attach ((char *) orig)
#define att_rt_element_list(orig) (void) dcg_attach ((char *) orig)
#define attach_rt_domain_list(orig) (rt_domain_list) dcg_attach ((char *) orig)
#define att_rt_domain_list(orig) (void) dcg_attach ((char *) orig)
#define attach_rt_elem_list(orig) (rt_elem_list) dcg_attach ((char *) orig)
#define att_rt_elem_list(orig) (void) dcg_attach ((char *) orig)
#define attach_rt_alt_list(orig) (rt_alt_list) dcg_attach ((char *) orig)
#define att_rt_alt_list(orig) (void) dcg_attach ((char *) orig)
#define attach_rt_type_list(orig) (rt_type_list) dcg_attach ((char *) orig)
#define att_rt_type_list(orig) (void) dcg_attach ((char *) orig)
#define attach_cset_part_list(orig) (cset_part_list) dcg_attach ((char *) orig)
#define att_cset_part_list(orig) (void) dcg_attach ((char *) orig)
#define attach_cset_list(orig) (cset_list) dcg_attach ((char *) orig)
#define att_cset_list(orig) (void) dcg_attach ((char *) orig)
#define attach_terminal_list(orig) (terminal_list) dcg_attach ((char *) orig)
#define att_terminal_list(orig) (void) dcg_attach ((char *) orig)
#define attach_nfa_state_list(orig) (nfa_state_list) dcg_attach ((char *) orig)
#define att_nfa_state_list(orig) (void) dcg_attach ((char *) orig)
#define attach_nfa_trans_list(orig) (nfa_trans_list) dcg_attach ((char *) orig)
#define att_nfa_trans_list(orig) (void) dcg_attach ((char *) orig)
#define attach_nfa_list(orig) (nfa_list) dcg_attach ((char *) orig)
#define att_nfa_list(orig) (void) dcg_attach ((char *) orig)
#define attach_lex_nont_list(orig) (lex_nont_list) dcg_attach ((char *) orig)
#define att_lex_nont_list(orig) (void) dcg_attach ((char *) orig)
#define attach_rt_nont_list(orig) (rt_nont_list) dcg_attach ((char *) orig)
#define att_rt_nont_list(orig) (void) dcg_attach ((char *) orig)
#define attach_ext_nont_list(orig) (ext_nont_list) dcg_attach ((char *) orig)
#define att_ext_nont_list(orig) (void) dcg_attach ((char *) orig)
#define attach_trans_pair_list(orig) (trans_pair_list) dcg_attach ((char *) orig)
#define att_trans_pair_list(orig) (void) dcg_attach ((char *) orig)
#define attach_int_list_list(orig) (int_list_list) dcg_attach ((char *) orig)
#define att_int_list_list(orig) (void) dcg_attach ((char *) orig)
#define attach_u_int64_list(orig) (u_int64_list) dcg_attach ((char *) orig)
#define att_u_int64_list(orig) (void) dcg_attach ((char *) orig)

/* Introduce detaching of enumeration types */
#define detach_tree_kind(old)
#define det_tree_kind(old)
#define detach_affix_expr_kind(old)
#define det_affix_expr_kind(old)
#define detach_propagation_kind(old)
#define det_propagation_kind(old)
#define detach_operator(old)
#define det_operator(old)

/* Introduce detaching of record types */
void detach_affix_value (affix_value *optr);
#define det_affix_value(optr) detach_affix_value(optr)
void detach_rt_element (rt_element *optr);
#define det_rt_element(optr) detach_rt_element(optr)
void detach_rt_domain (rt_domain *optr);
#define det_rt_domain(optr) detach_rt_domain(optr)
void detach_rt_elem (rt_elem *optr);
#define det_rt_elem(optr) detach_rt_elem(optr)
void detach_rt_alt (rt_alt *optr);
#define det_rt_alt(optr) detach_rt_alt(optr)
void detach_rt_type (rt_type *optr);
#define det_rt_type(optr) detach_rt_type(optr)
void detach_cset_part (cset_part *optr);
#define det_cset_part(optr) detach_cset_part(optr)
void detach_cset (cset *optr);
#define det_cset(optr) detach_cset(optr)
void detach_terminal (terminal *optr);
#define det_terminal(optr) detach_terminal(optr)
void detach_nfa_state (nfa_state *optr);
#define det_nfa_state(optr) detach_nfa_state(optr)
void detach_nfa_trans (nfa_trans *optr);
#define det_nfa_trans(optr) detach_nfa_trans(optr)
void detach_nfa (nfa *optr);
#define det_nfa(optr) detach_nfa(optr)
void detach_lex_nont (lex_nont *optr);
#define det_lex_nont(optr) detach_lex_nont(optr)
void detach_rt_nont (rt_nont *optr);
#define det_rt_nont(optr) detach_rt_nont(optr)
void detach_ext_nont (ext_nont *optr);
#define det_ext_nont(optr) detach_ext_nont(optr)
void detach_director_set (director_set *optr);
#define det_director_set(optr) detach_director_set(optr)
void detach_trans_pair (trans_pair *optr);
#define det_trans_pair(optr) detach_trans_pair(optr)

/* Introduce detaching of lists */
void detach_affix_value_list (affix_value_list *lp);
void detach_rt_element_list (rt_element_list *lp);
void detach_rt_domain_list (rt_domain_list *lp);
void detach_rt_elem_list (rt_elem_list *lp);
void detach_rt_alt_list (rt_alt_list *lp);
void detach_rt_type_list (rt_type_list *lp);
void detach_cset_part_list (cset_part_list *lp);
void detach_cset_list (cset_list *lp);
void detach_terminal_list (terminal_list *lp);
void detach_nfa_state_list (nfa_state_list *lp);
void detach_nfa_trans_list (nfa_trans_list *lp);
void detach_nfa_list (nfa_list *lp);
void detach_lex_nont_list (lex_nont_list *lp);
void detach_rt_nont_list (rt_nont_list *lp);
void detach_ext_nont_list (ext_nont_list *lp);
void detach_trans_pair_list (trans_pair_list *lp);
void detach_int_list_list (int_list_list *lp);
void detach_u_int64_list (u_int64_list *lp);

/* Introduce nonrecursive detaching of lists */
void nonrec_detach_affix_value_list (affix_value_list *lp);
void nonrec_detach_rt_element_list (rt_element_list *lp);
void nonrec_detach_rt_domain_list (rt_domain_list *lp);
void nonrec_detach_rt_elem_list (rt_elem_list *lp);
void nonrec_detach_rt_alt_list (rt_alt_list *lp);
void nonrec_detach_rt_type_list (rt_type_list *lp);
void nonrec_detach_cset_part_list (cset_part_list *lp);
void nonrec_detach_cset_list (cset_list *lp);
void nonrec_detach_terminal_list (terminal_list *lp);
void nonrec_detach_nfa_state_list (nfa_state_list *lp);
void nonrec_detach_nfa_trans_list (nfa_trans_list *lp);
void nonrec_detach_nfa_list (nfa_list *lp);
void nonrec_detach_lex_nont_list (lex_nont_list *lp);
void nonrec_detach_rt_nont_list (rt_nont_list *lp);
void nonrec_detach_ext_nont_list (ext_nont_list *lp);
void nonrec_detach_trans_pair_list (trans_pair_list *lp);
void nonrec_detach_int_list_list (int_list_list *lp);
void nonrec_detach_u_int64_list (u_int64_list *lp);

/* Introduce list append routines */
affix_value_list append_affix_value_list (affix_value_list l, affix_value el);
rt_element_list append_rt_element_list (rt_element_list l, rt_element el);
rt_domain_list append_rt_domain_list (rt_domain_list l, rt_domain el);
rt_elem_list append_rt_elem_list (rt_elem_list l, rt_elem el);
rt_alt_list append_rt_alt_list (rt_alt_list l, rt_alt el);
rt_type_list append_rt_type_list (rt_type_list l, rt_type el);
cset_part_list append_cset_part_list (cset_part_list l, cset_part el);
cset_list append_cset_list (cset_list l, cset el);
terminal_list append_terminal_list (terminal_list l, terminal el);
nfa_state_list append_nfa_state_list (nfa_state_list l, nfa_state el);
nfa_trans_list append_nfa_trans_list (nfa_trans_list l, nfa_trans el);
nfa_list append_nfa_list (nfa_list l, nfa el);
lex_nont_list append_lex_nont_list (lex_nont_list l, lex_nont el);
rt_nont_list append_rt_nont_list (rt_nont_list l, rt_nont el);
ext_nont_list append_ext_nont_list (ext_nont_list l, ext_nont el);
trans_pair_list append_trans_pair_list (trans_pair_list l, trans_pair el);
int_list_list append_int_list_list (int_list_list l, int_list el);
u_int64_list append_u_int64_list (u_int64_list l, u_int64 el);

/* Introduce void shorthands for list append routines */
#define app_affix_value_list(l,el) (void) append_affix_value_list (l,el)
#define app_rt_element_list(l,el) (void) append_rt_element_list (l,el)
#define app_rt_domain_list(l,el) (void) append_rt_domain_list (l,el)
#define app_rt_elem_list(l,el) (void) append_rt_elem_list (l,el)
#define app_rt_alt_list(l,el) (void) append_rt_alt_list (l,el)
#define app_rt_type_list(l,el) (void) append_rt_type_list (l,el)
#define app_cset_part_list(l,el) (void) append_cset_part_list (l,el)
#define app_cset_list(l,el) (void) append_cset_list (l,el)
#define app_terminal_list(l,el) (void) append_terminal_list (l,el)
#define app_nfa_state_list(l,el) (void) append_nfa_state_list (l,el)
#define app_nfa_trans_list(l,el) (void) append_nfa_trans_list (l,el)
#define app_nfa_list(l,el) (void) append_nfa_list (l,el)
#define app_lex_nont_list(l,el) (void) append_lex_nont_list (l,el)
#define app_rt_nont_list(l,el) (void) append_rt_nont_list (l,el)
#define app_ext_nont_list(l,el) (void) append_ext_nont_list (l,el)
#define app_trans_pair_list(l,el) (void) append_trans_pair_list (l,el)
#define app_int_list_list(l,el) (void) append_int_list_list (l,el)
#define app_u_int64_list(l,el) (void) append_u_int64_list (l,el)

/* Introduce list concat routines */
affix_value_list concat_affix_value_list (affix_value_list l1, affix_value_list l2);
rt_element_list concat_rt_element_list (rt_element_list l1, rt_element_list l2);
rt_domain_list concat_rt_domain_list (rt_domain_list l1, rt_domain_list l2);
rt_elem_list concat_rt_elem_list (rt_elem_list l1, rt_elem_list l2);
rt_alt_list concat_rt_alt_list (rt_alt_list l1, rt_alt_list l2);
rt_type_list concat_rt_type_list (rt_type_list l1, rt_type_list l2);
cset_part_list concat_cset_part_list (cset_part_list l1, cset_part_list l2);
cset_list concat_cset_list (cset_list l1, cset_list l2);
terminal_list concat_terminal_list (terminal_list l1, terminal_list l2);
nfa_state_list concat_nfa_state_list (nfa_state_list l1, nfa_state_list l2);
nfa_trans_list concat_nfa_trans_list (nfa_trans_list l1, nfa_trans_list l2);
nfa_list concat_nfa_list (nfa_list l1, nfa_list l2);
lex_nont_list concat_lex_nont_list (lex_nont_list l1, lex_nont_list l2);
rt_nont_list concat_rt_nont_list (rt_nont_list l1, rt_nont_list l2);
ext_nont_list concat_ext_nont_list (ext_nont_list l1, ext_nont_list l2);
trans_pair_list concat_trans_pair_list (trans_pair_list l1, trans_pair_list l2);
int_list_list concat_int_list_list (int_list_list l1, int_list_list l2);
u_int64_list concat_u_int64_list (u_int64_list l1, u_int64_list l2);

/* Introduce void shorthands for list concat routines */
#define conc_affix_value_list(l1,l2) (void) concat_affix_value_list (l1,l2)
#define conc_rt_element_list(l1,l2) (void) concat_rt_element_list (l1,l2)
#define conc_rt_domain_list(l1,l2) (void) concat_rt_domain_list (l1,l2)
#define conc_rt_elem_list(l1,l2) (void) concat_rt_elem_list (l1,l2)
#define conc_rt_alt_list(l1,l2) (void) concat_rt_alt_list (l1,l2)
#define conc_rt_type_list(l1,l2) (void) concat_rt_type_list (l1,l2)
#define conc_cset_part_list(l1,l2) (void) concat_cset_part_list (l1,l2)
#define conc_cset_list(l1,l2) (void) concat_cset_list (l1,l2)
#define conc_terminal_list(l1,l2) (void) concat_terminal_list (l1,l2)
#define conc_nfa_state_list(l1,l2) (void) concat_nfa_state_list (l1,l2)
#define conc_nfa_trans_list(l1,l2) (void) concat_nfa_trans_list (l1,l2)
#define conc_nfa_list(l1,l2) (void) concat_nfa_list (l1,l2)
#define conc_lex_nont_list(l1,l2) (void) concat_lex_nont_list (l1,l2)
#define conc_rt_nont_list(l1,l2) (void) concat_rt_nont_list (l1,l2)
#define conc_ext_nont_list(l1,l2) (void) concat_ext_nont_list (l1,l2)
#define conc_trans_pair_list(l1,l2) (void) concat_trans_pair_list (l1,l2)
#define conc_int_list_list(l1,l2) (void) concat_int_list_list (l1,l2)
#define conc_u_int64_list(l1,l2) (void) concat_u_int64_list (l1,l2)

/* Introduce list insertion routines */
affix_value_list insert_affix_value_list (affix_value_list l, int pos, affix_value el);
rt_element_list insert_rt_element_list (rt_element_list l, int pos, rt_element el);
rt_domain_list insert_rt_domain_list (rt_domain_list l, int pos, rt_domain el);
rt_elem_list insert_rt_elem_list (rt_elem_list l, int pos, rt_elem el);
rt_alt_list insert_rt_alt_list (rt_alt_list l, int pos, rt_alt el);
rt_type_list insert_rt_type_list (rt_type_list l, int pos, rt_type el);
cset_part_list insert_cset_part_list (cset_part_list l, int pos, cset_part el);
cset_list insert_cset_list (cset_list l, int pos, cset el);
terminal_list insert_terminal_list (terminal_list l, int pos, terminal el);
nfa_state_list insert_nfa_state_list (nfa_state_list l, int pos, nfa_state el);
nfa_trans_list insert_nfa_trans_list (nfa_trans_list l, int pos, nfa_trans el);
nfa_list insert_nfa_list (nfa_list l, int pos, nfa el);
lex_nont_list insert_lex_nont_list (lex_nont_list l, int pos, lex_nont el);
rt_nont_list insert_rt_nont_list (rt_nont_list l, int pos, rt_nont el);
ext_nont_list insert_ext_nont_list (ext_nont_list l, int pos, ext_nont el);
trans_pair_list insert_trans_pair_list (trans_pair_list l, int pos, trans_pair el);
int_list_list insert_int_list_list (int_list_list l, int pos, int_list el);
u_int64_list insert_u_int64_list (u_int64_list l, int pos, u_int64 el);

/* Introduce void shorthands for list insertion routines */
#define ins_affix_value_list(l,pos,el) (void) insert_affix_value_list (l,pos,el)
#define ins_rt_element_list(l,pos,el) (void) insert_rt_element_list (l,pos,el)
#define ins_rt_domain_list(l,pos,el) (void) insert_rt_domain_list (l,pos,el)
#define ins_rt_elem_list(l,pos,el) (void) insert_rt_elem_list (l,pos,el)
#define ins_rt_alt_list(l,pos,el) (void) insert_rt_alt_list (l,pos,el)
#define ins_rt_type_list(l,pos,el) (void) insert_rt_type_list (l,pos,el)
#define ins_cset_part_list(l,pos,el) (void) insert_cset_part_list (l,pos,el)
#define ins_cset_list(l,pos,el) (void) insert_cset_list (l,pos,el)
#define ins_terminal_list(l,pos,el) (void) insert_terminal_list (l,pos,el)
#define ins_nfa_state_list(l,pos,el) (void) insert_nfa_state_list (l,pos,el)
#define ins_nfa_trans_list(l,pos,el) (void) insert_nfa_trans_list (l,pos,el)
#define ins_nfa_list(l,pos,el) (void) insert_nfa_list (l,pos,el)
#define ins_lex_nont_list(l,pos,el) (void) insert_lex_nont_list (l,pos,el)
#define ins_rt_nont_list(l,pos,el) (void) insert_rt_nont_list (l,pos,el)
#define ins_ext_nont_list(l,pos,el) (void) insert_ext_nont_list (l,pos,el)
#define ins_trans_pair_list(l,pos,el) (void) insert_trans_pair_list (l,pos,el)
#define ins_int_list_list(l,pos,el) (void) insert_int_list_list (l,pos,el)
#define ins_u_int64_list(l,pos,el) (void) insert_u_int64_list (l,pos,el)

/* Introduce list deletion routines */
affix_value_list delete_affix_value_list (affix_value_list l, int pos);
rt_element_list delete_rt_element_list (rt_element_list l, int pos);
rt_domain_list delete_rt_domain_list (rt_domain_list l, int pos);
rt_elem_list delete_rt_elem_list (rt_elem_list l, int pos);
rt_alt_list delete_rt_alt_list (rt_alt_list l, int pos);
rt_type_list delete_rt_type_list (rt_type_list l, int pos);
cset_part_list delete_cset_part_list (cset_part_list l, int pos);
cset_list delete_cset_list (cset_list l, int pos);
terminal_list delete_terminal_list (terminal_list l, int pos);
nfa_state_list delete_nfa_state_list (nfa_state_list l, int pos);
nfa_trans_list delete_nfa_trans_list (nfa_trans_list l, int pos);
nfa_list delete_nfa_list (nfa_list l, int pos);
lex_nont_list delete_lex_nont_list (lex_nont_list l, int pos);
rt_nont_list delete_rt_nont_list (rt_nont_list l, int pos);
ext_nont_list delete_ext_nont_list (ext_nont_list l, int pos);
trans_pair_list delete_trans_pair_list (trans_pair_list l, int pos);
int_list_list delete_int_list_list (int_list_list l, int pos);
u_int64_list delete_u_int64_list (u_int64_list l, int pos);

/* Introduce void shorthands for list deletion routines */
#define del_affix_value_list(l,pos) (void) delete_affix_value_list (l,pos)
#define del_rt_element_list(l,pos) (void) delete_rt_element_list (l,pos)
#define del_rt_domain_list(l,pos) (void) delete_rt_domain_list (l,pos)
#define del_rt_elem_list(l,pos) (void) delete_rt_elem_list (l,pos)
#define del_rt_alt_list(l,pos) (void) delete_rt_alt_list (l,pos)
#define del_rt_type_list(l,pos) (void) delete_rt_type_list (l,pos)
#define del_cset_part_list(l,pos) (void) delete_cset_part_list (l,pos)
#define del_cset_list(l,pos) (void) delete_cset_list (l,pos)
#define del_terminal_list(l,pos) (void) delete_terminal_list (l,pos)
#define del_nfa_state_list(l,pos) (void) delete_nfa_state_list (l,pos)
#define del_nfa_trans_list(l,pos) (void) delete_nfa_trans_list (l,pos)
#define del_nfa_list(l,pos) (void) delete_nfa_list (l,pos)
#define del_lex_nont_list(l,pos) (void) delete_lex_nont_list (l,pos)
#define del_rt_nont_list(l,pos) (void) delete_rt_nont_list (l,pos)
#define del_ext_nont_list(l,pos) (void) delete_ext_nont_list (l,pos)
#define del_trans_pair_list(l,pos) (void) delete_trans_pair_list (l,pos)
#define del_int_list_list(l,pos) (void) delete_int_list_list (l,pos)
#define del_u_int64_list(l,pos) (void) delete_u_int64_list (l,pos)

/* Equality test for types */
int cmp_affix_value (affix_value a, affix_value b);
int cmp_rt_element (rt_element a, rt_element b);
int cmp_rt_domain (rt_domain a, rt_domain b);
int cmp_rt_elem (rt_elem a, rt_elem b);
int cmp_rt_alt (rt_alt a, rt_alt b);
int cmp_rt_type (rt_type a, rt_type b);
int cmp_cset_part (cset_part a, cset_part b);
int cmp_cset (cset a, cset b);
int cmp_terminal (terminal a, terminal b);
int cmp_nfa_state (nfa_state a, nfa_state b);
int cmp_nfa_trans (nfa_trans a, nfa_trans b);
int cmp_nfa (nfa a, nfa b);
int cmp_lex_nont (lex_nont a, lex_nont b);
int cmp_rt_nont (rt_nont a, rt_nont b);
int cmp_ext_nont (ext_nont a, ext_nont b);
#define cmp_tree_kind(a,b) (cmp_int ((int)(a),(int)(b)))
#define cmp_affix_expr_kind(a,b) (cmp_int ((int)(a),(int)(b)))
#define cmp_propagation_kind(a,b) (cmp_int ((int)(a),(int)(b)))
#define cmp_operator(a,b) (cmp_int ((int)(a),(int)(b)))
int cmp_director_set (director_set a, director_set b);
int cmp_trans_pair (trans_pair a, trans_pair b);

/* Comparison tests for lists */
int cmp_affix_value_list (affix_value_list a, affix_value_list b);
int cmp_rt_element_list (rt_element_list a, rt_element_list b);
int cmp_rt_domain_list (rt_domain_list a, rt_domain_list b);
int cmp_rt_elem_list (rt_elem_list a, rt_elem_list b);
int cmp_rt_alt_list (rt_alt_list a, rt_alt_list b);
int cmp_rt_type_list (rt_type_list a, rt_type_list b);
int cmp_cset_part_list (cset_part_list a, cset_part_list b);
int cmp_cset_list (cset_list a, cset_list b);
int cmp_terminal_list (terminal_list a, terminal_list b);
int cmp_nfa_state_list (nfa_state_list a, nfa_state_list b);
int cmp_nfa_trans_list (nfa_trans_list a, nfa_trans_list b);
int cmp_nfa_list (nfa_list a, nfa_list b);
int cmp_lex_nont_list (lex_nont_list a, lex_nont_list b);
int cmp_rt_nont_list (rt_nont_list a, rt_nont_list b);
int cmp_ext_nont_list (ext_nont_list a, ext_nont_list b);
int cmp_trans_pair_list (trans_pair_list a, trans_pair_list b);
int cmp_int_list_list (int_list_list a, int_list_list b);
int cmp_u_int64_list (u_int64_list a, u_int64_list b);

/* Equality shorthands for types */
#define equal_affix_value(a,b) !cmp_affix_value ((a),(b))
#define equal_rt_element(a,b) !cmp_rt_element ((a),(b))
#define equal_rt_domain(a,b) !cmp_rt_domain ((a),(b))
#define equal_rt_elem(a,b) !cmp_rt_elem ((a),(b))
#define equal_rt_alt(a,b) !cmp_rt_alt ((a),(b))
#define equal_rt_type(a,b) !cmp_rt_type ((a),(b))
#define equal_cset_part(a,b) !cmp_cset_part ((a),(b))
#define equal_cset(a,b) !cmp_cset ((a),(b))
#define equal_terminal(a,b) !cmp_terminal ((a),(b))
#define equal_nfa_state(a,b) !cmp_nfa_state ((a),(b))
#define equal_nfa_trans(a,b) !cmp_nfa_trans ((a),(b))
#define equal_nfa(a,b) !cmp_nfa ((a),(b))
#define equal_lex_nont(a,b) !cmp_lex_nont ((a),(b))
#define equal_rt_nont(a,b) !cmp_rt_nont ((a),(b))
#define equal_ext_nont(a,b) !cmp_ext_nont ((a),(b))
#define equal_tree_kind(a,b) !cmp_tree_kind ((a),(b))
#define equal_affix_expr_kind(a,b) !cmp_affix_expr_kind ((a),(b))
#define equal_propagation_kind(a,b) !cmp_propagation_kind ((a),(b))
#define equal_operator(a,b) !cmp_operator ((a),(b))
#define equal_director_set(a,b) !cmp_director_set ((a),(b))
#define equal_trans_pair(a,b) !cmp_trans_pair ((a),(b))

/* Equality shorthands for lists */
#define equal_affix_value_list(a,b) !cmp_affix_value_list((a),(b))
#define equal_rt_element_list(a,b) !cmp_rt_element_list((a),(b))
#define equal_rt_domain_list(a,b) !cmp_rt_domain_list((a),(b))
#define equal_rt_elem_list(a,b) !cmp_rt_elem_list((a),(b))
#define equal_rt_alt_list(a,b) !cmp_rt_alt_list((a),(b))
#define equal_rt_type_list(a,b) !cmp_rt_type_list((a),(b))
#define equal_cset_part_list(a,b) !cmp_cset_part_list((a),(b))
#define equal_cset_list(a,b) !cmp_cset_list((a),(b))
#define equal_terminal_list(a,b) !cmp_terminal_list((a),(b))
#define equal_nfa_state_list(a,b) !cmp_nfa_state_list((a),(b))
#define equal_nfa_trans_list(a,b) !cmp_nfa_trans_list((a),(b))
#define equal_nfa_list(a,b) !cmp_nfa_list((a),(b))
#define equal_lex_nont_list(a,b) !cmp_lex_nont_list((a),(b))
#define equal_rt_nont_list(a,b) !cmp_rt_nont_list((a),(b))
#define equal_ext_nont_list(a,b) !cmp_ext_nont_list((a),(b))
#define equal_trans_pair_list(a,b) !cmp_trans_pair_list((a),(b))
#define equal_int_list_list(a,b) !cmp_int_list_list((a),(b))
#define equal_u_int64_list(a,b) !cmp_u_int64_list((a),(b))

/* Estimating printing of types */
int est_affix_value (affix_value old);
int est_rt_element (rt_element old);
int est_rt_domain (rt_domain old);
int est_rt_elem (rt_elem old);
int est_rt_alt (rt_alt old);
int est_rt_type (rt_type old);
int est_cset_part (cset_part old);
int est_cset (cset old);
int est_terminal (terminal old);
int est_nfa_state (nfa_state old);
int est_nfa_trans (nfa_trans old);
int est_nfa (nfa old);
int est_lex_nont (lex_nont old);
int est_rt_nont (rt_nont old);
int est_ext_nont (ext_nont old);
int est_tree_kind (tree_kind old);
int est_affix_expr_kind (affix_expr_kind old);
int est_propagation_kind (propagation_kind old);
int est_operator (operator old);
int est_director_set (director_set old);
int est_trans_pair (trans_pair old);

/* Estimate printing of lists */
int est_affix_value_list (affix_value_list old);
int est_rt_element_list (rt_element_list old);
int est_rt_domain_list (rt_domain_list old);
int est_rt_elem_list (rt_elem_list old);
int est_rt_alt_list (rt_alt_list old);
int est_rt_type_list (rt_type_list old);
int est_cset_part_list (cset_part_list old);
int est_cset_list (cset_list old);
int est_terminal_list (terminal_list old);
int est_nfa_state_list (nfa_state_list old);
int est_nfa_trans_list (nfa_trans_list old);
int est_nfa_list (nfa_list old);
int est_lex_nont_list (lex_nont_list old);
int est_rt_nont_list (rt_nont_list old);
int est_ext_nont_list (ext_nont_list old);
int est_trans_pair_list (trans_pair_list old);
int est_int_list_list (int_list_list old);
int est_u_int64_list (u_int64_list old);

void ppp_affix_value (FILE *f, int horiz, int ind, affix_value old);
void ppp_rt_element (FILE *f, int horiz, int ind, rt_element old);
void ppp_rt_domain (FILE *f, int horiz, int ind, rt_domain old);
void ppp_rt_elem (FILE *f, int horiz, int ind, rt_elem old);
void ppp_rt_alt (FILE *f, int horiz, int ind, rt_alt old);
void ppp_rt_type (FILE *f, int horiz, int ind, rt_type old);
void ppp_cset_part (FILE *f, int horiz, int ind, cset_part old);
void ppp_cset (FILE *f, int horiz, int ind, cset old);
void ppp_terminal (FILE *f, int horiz, int ind, terminal old);
void ppp_nfa_state (FILE *f, int horiz, int ind, nfa_state old);
void ppp_nfa_trans (FILE *f, int horiz, int ind, nfa_trans old);
void ppp_nfa (FILE *f, int horiz, int ind, nfa old);
void ppp_lex_nont (FILE *f, int horiz, int ind, lex_nont old);
void ppp_rt_nont (FILE *f, int horiz, int ind, rt_nont old);
void ppp_ext_nont (FILE *f, int horiz, int ind, ext_nont old);
void ppp_tree_kind (FILE *f, int horiz, int ind, tree_kind old);
void ppp_affix_expr_kind (FILE *f, int horiz, int ind, affix_expr_kind old);
void ppp_propagation_kind (FILE *f, int horiz, int ind, propagation_kind old);
void ppp_operator (FILE *f, int horiz, int ind, operator old);
void ppp_director_set (FILE *f, int horiz, int ind, director_set old);
void ppp_trans_pair (FILE *f, int horiz, int ind, trans_pair old);

/* Introduce pretty printing of lists */
void ppp_affix_value_list (FILE *f, int horiz, int ind, affix_value_list old);
void ppp_rt_element_list (FILE *f, int horiz, int ind, rt_element_list old);
void ppp_rt_domain_list (FILE *f, int horiz, int ind, rt_domain_list old);
void ppp_rt_elem_list (FILE *f, int horiz, int ind, rt_elem_list old);
void ppp_rt_alt_list (FILE *f, int horiz, int ind, rt_alt_list old);
void ppp_rt_type_list (FILE *f, int horiz, int ind, rt_type_list old);
void ppp_cset_part_list (FILE *f, int horiz, int ind, cset_part_list old);
void ppp_cset_list (FILE *f, int horiz, int ind, cset_list old);
void ppp_terminal_list (FILE *f, int horiz, int ind, terminal_list old);
void ppp_nfa_state_list (FILE *f, int horiz, int ind, nfa_state_list old);
void ppp_nfa_trans_list (FILE *f, int horiz, int ind, nfa_trans_list old);
void ppp_nfa_list (FILE *f, int horiz, int ind, nfa_list old);
void ppp_lex_nont_list (FILE *f, int horiz, int ind, lex_nont_list old);
void ppp_rt_nont_list (FILE *f, int horiz, int ind, rt_nont_list old);
void ppp_ext_nont_list (FILE *f, int horiz, int ind, ext_nont_list old);
void ppp_trans_pair_list (FILE *f, int horiz, int ind, trans_pair_list old);
void ppp_int_list_list (FILE *f, int horiz, int ind, int_list_list old);
void ppp_u_int64_list (FILE *f, int horiz, int ind, u_int64_list old);

/* Introduce pretty printing shorthands */
#define pp_affix_value(f,x) ppp_affix_value (f,0,0,x)
#define pp_rt_element(f,x) ppp_rt_element (f,0,0,x)
#define pp_rt_domain(f,x) ppp_rt_domain (f,0,0,x)
#define pp_rt_elem(f,x) ppp_rt_elem (f,0,0,x)
#define pp_rt_alt(f,x) ppp_rt_alt (f,0,0,x)
#define pp_rt_type(f,x) ppp_rt_type (f,0,0,x)
#define pp_cset_part(f,x) ppp_cset_part (f,0,0,x)
#define pp_cset(f,x) ppp_cset (f,0,0,x)
#define pp_terminal(f,x) ppp_terminal (f,0,0,x)
#define pp_nfa_state(f,x) ppp_nfa_state (f,0,0,x)
#define pp_nfa_trans(f,x) ppp_nfa_trans (f,0,0,x)
#define pp_nfa(f,x) ppp_nfa (f,0,0,x)
#define pp_lex_nont(f,x) ppp_lex_nont (f,0,0,x)
#define pp_rt_nont(f,x) ppp_rt_nont (f,0,0,x)
#define pp_ext_nont(f,x) ppp_ext_nont (f,0,0,x)
#define pp_tree_kind(f,x) ppp_tree_kind (f,0,0,x)
#define pp_affix_expr_kind(f,x) ppp_affix_expr_kind (f,0,0,x)
#define pp_propagation_kind(f,x) ppp_propagation_kind (f,0,0,x)
#define pp_operator(f,x) ppp_operator (f,0,0,x)
#define pp_director_set(f,x) ppp_director_set (f,0,0,x)
#define pp_trans_pair(f,x) ppp_trans_pair (f,0,0,x)

/* Introduce pretty printing shorthands for lists */
#define pp_affix_value_list(f,x) ppp_affix_value_list (f,0,0,x)
#define pp_rt_element_list(f,x) ppp_rt_element_list (f,0,0,x)
#define pp_rt_domain_list(f,x) ppp_rt_domain_list (f,0,0,x)
#define pp_rt_elem_list(f,x) ppp_rt_elem_list (f,0,0,x)
#define pp_rt_alt_list(f,x) ppp_rt_alt_list (f,0,0,x)
#define pp_rt_type_list(f,x) ppp_rt_type_list (f,0,0,x)
#define pp_cset_part_list(f,x) ppp_cset_part_list (f,0,0,x)
#define pp_cset_list(f,x) ppp_cset_list (f,0,0,x)
#define pp_terminal_list(f,x) ppp_terminal_list (f,0,0,x)
#define pp_nfa_state_list(f,x) ppp_nfa_state_list (f,0,0,x)
#define pp_nfa_trans_list(f,x) ppp_nfa_trans_list (f,0,0,x)
#define pp_nfa_list(f,x) ppp_nfa_list (f,0,0,x)
#define pp_lex_nont_list(f,x) ppp_lex_nont_list (f,0,0,x)
#define pp_rt_nont_list(f,x) ppp_rt_nont_list (f,0,0,x)
#define pp_ext_nont_list(f,x) ppp_ext_nont_list (f,0,0,x)
#define pp_trans_pair_list(f,x) ppp_trans_pair_list (f,0,0,x)
#define pp_int_list_list(f,x) ppp_int_list_list (f,0,0,x)
#define pp_u_int64_list(f,x) ppp_u_int64_list (f,0,0,x)

/* Introduce saving of types */
#define save_tree_kind(bf,x) save_char(bf, (char) x)
#define save_affix_expr_kind(bf,x) save_char(bf, (char) x)
#define save_propagation_kind(bf,x) save_char(bf, (char) x)
#define save_operator(bf,x) save_char(bf, (char) x)
void save_affix_value (BinFile bf, affix_value old);
void save_rt_element (BinFile bf, rt_element old);
void save_rt_domain (BinFile bf, rt_domain old);
void save_rt_elem (BinFile bf, rt_elem old);
void save_rt_alt (BinFile bf, rt_alt old);
void save_rt_type (BinFile bf, rt_type old);
void save_cset_part (BinFile bf, cset_part old);
void save_cset (BinFile bf, cset old);
void save_terminal (BinFile bf, terminal old);
void save_nfa_state (BinFile bf, nfa_state old);
void save_nfa_trans (BinFile bf, nfa_trans old);
void save_nfa (BinFile bf, nfa old);
void save_lex_nont (BinFile bf, lex_nont old);
void save_rt_nont (BinFile bf, rt_nont old);
void save_ext_nont (BinFile bf, ext_nont old);
void save_director_set (BinFile bf, director_set old);
void save_trans_pair (BinFile bf, trans_pair old);

/* Introduce saving of lists */
void save_affix_value_list (BinFile bf, affix_value_list l);
void save_rt_element_list (BinFile bf, rt_element_list l);
void save_rt_domain_list (BinFile bf, rt_domain_list l);
void save_rt_elem_list (BinFile bf, rt_elem_list l);
void save_rt_alt_list (BinFile bf, rt_alt_list l);
void save_rt_type_list (BinFile bf, rt_type_list l);
void save_cset_part_list (BinFile bf, cset_part_list l);
void save_cset_list (BinFile bf, cset_list l);
void save_terminal_list (BinFile bf, terminal_list l);
void save_nfa_state_list (BinFile bf, nfa_state_list l);
void save_nfa_trans_list (BinFile bf, nfa_trans_list l);
void save_nfa_list (BinFile bf, nfa_list l);
void save_lex_nont_list (BinFile bf, lex_nont_list l);
void save_rt_nont_list (BinFile bf, rt_nont_list l);
void save_ext_nont_list (BinFile bf, ext_nont_list l);
void save_trans_pair_list (BinFile bf, trans_pair_list l);
void save_int_list_list (BinFile bf, int_list_list l);
void save_u_int64_list (BinFile bf, u_int64_list l);

/* Introduce loading of types */
void load_affix_value (BinFile bf, affix_value *x);
void load_rt_element (BinFile bf, rt_element *x);
void load_rt_domain (BinFile bf, rt_domain *x);
void load_rt_elem (BinFile bf, rt_elem *x);
void load_rt_alt (BinFile bf, rt_alt *x);
void load_rt_type (BinFile bf, rt_type *x);
void load_cset_part (BinFile bf, cset_part *x);
void load_cset (BinFile bf, cset *x);
void load_terminal (BinFile bf, terminal *x);
void load_nfa_state (BinFile bf, nfa_state *x);
void load_nfa_trans (BinFile bf, nfa_trans *x);
void load_nfa (BinFile bf, nfa *x);
void load_lex_nont (BinFile bf, lex_nont *x);
void load_rt_nont (BinFile bf, rt_nont *x);
void load_ext_nont (BinFile bf, ext_nont *x);
void load_tree_kind (BinFile bf, tree_kind *x);
void load_affix_expr_kind (BinFile bf, affix_expr_kind *x);
void load_propagation_kind (BinFile bf, propagation_kind *x);
void load_operator (BinFile bf, operator *x);
void load_director_set (BinFile bf, director_set *x);
void load_trans_pair (BinFile bf, trans_pair *x);

/* Introduce loading of lists */
void load_affix_value_list (BinFile bf, affix_value_list *l);
void load_rt_element_list (BinFile bf, rt_element_list *l);
void load_rt_domain_list (BinFile bf, rt_domain_list *l);
void load_rt_elem_list (BinFile bf, rt_elem_list *l);
void load_rt_alt_list (BinFile bf, rt_alt_list *l);
void load_rt_type_list (BinFile bf, rt_type_list *l);
void load_cset_part_list (BinFile bf, cset_part_list *l);
void load_cset_list (BinFile bf, cset_list *l);
void load_terminal_list (BinFile bf, terminal_list *l);
void load_nfa_state_list (BinFile bf, nfa_state_list *l);
void load_nfa_trans_list (BinFile bf, nfa_trans_list *l);
void load_nfa_list (BinFile bf, nfa_list *l);
void load_lex_nont_list (BinFile bf, lex_nont_list *l);
void load_rt_nont_list (BinFile bf, rt_nont_list *l);
void load_ext_nont_list (BinFile bf, ext_nont_list *l);
void load_trans_pair_list (BinFile bf, trans_pair_list *l);
void load_int_list_list (BinFile bf, int_list_list *l);
void load_u_int64_list (BinFile bf, u_int64_list *l);

/* Introduce recursive duplication of types */
affix_value rdup_affix_value (affix_value old);
rt_element rdup_rt_element (rt_element old);
rt_domain rdup_rt_domain (rt_domain old);
rt_elem rdup_rt_elem (rt_elem old);
rt_alt rdup_rt_alt (rt_alt old);
rt_type rdup_rt_type (rt_type old);
cset_part rdup_cset_part (cset_part old);
cset rdup_cset (cset old);
terminal rdup_terminal (terminal old);
nfa_state rdup_nfa_state (nfa_state old);
nfa_trans rdup_nfa_trans (nfa_trans old);
nfa rdup_nfa (nfa old);
lex_nont rdup_lex_nont (lex_nont old);
rt_nont rdup_rt_nont (rt_nont old);
ext_nont rdup_ext_nont (ext_nont old);
#define rdup_tree_kind(orig) (orig)
#define rdup_affix_expr_kind(orig) (orig)
#define rdup_propagation_kind(orig) (orig)
#define rdup_operator(orig) (orig)
director_set rdup_director_set (director_set old);
trans_pair rdup_trans_pair (trans_pair old);

/* Introduce recursive copying of lists */
affix_value_list rdup_affix_value_list (affix_value_list old);
rt_element_list rdup_rt_element_list (rt_element_list old);
rt_domain_list rdup_rt_domain_list (rt_domain_list old);
rt_elem_list rdup_rt_elem_list (rt_elem_list old);
rt_alt_list rdup_rt_alt_list (rt_alt_list old);
rt_type_list rdup_rt_type_list (rt_type_list old);
cset_part_list rdup_cset_part_list (cset_part_list old);
cset_list rdup_cset_list (cset_list old);
terminal_list rdup_terminal_list (terminal_list old);
nfa_state_list rdup_nfa_state_list (nfa_state_list old);
nfa_trans_list rdup_nfa_trans_list (nfa_trans_list old);
nfa_list rdup_nfa_list (nfa_list old);
lex_nont_list rdup_lex_nont_list (lex_nont_list old);
rt_nont_list rdup_rt_nont_list (rt_nont_list old);
ext_nont_list rdup_ext_nont_list (ext_nont_list old);
trans_pair_list rdup_trans_pair_list (trans_pair_list old);
int_list_list rdup_int_list_list (int_list_list old);
u_int64_list rdup_u_int64_list (u_int64_list old);

/* Introduce recursive refcount checking of types */
void check_not_freed_affix_value (affix_value curr);
void check_not_freed_rt_element (rt_element curr);
void check_not_freed_rt_domain (rt_domain curr);
void check_not_freed_rt_elem (rt_elem curr);
void check_not_freed_rt_alt (rt_alt curr);
void check_not_freed_rt_type (rt_type curr);
void check_not_freed_cset_part (cset_part curr);
void check_not_freed_cset (cset curr);
void check_not_freed_terminal (terminal curr);
void check_not_freed_nfa_state (nfa_state curr);
void check_not_freed_nfa_trans (nfa_trans curr);
void check_not_freed_nfa (nfa curr);
void check_not_freed_lex_nont (lex_nont curr);
void check_not_freed_rt_nont (rt_nont curr);
void check_not_freed_ext_nont (ext_nont curr);
#define check_not_freed_tree_kind(curr)
#define check_not_freed_affix_expr_kind(curr)
#define check_not_freed_propagation_kind(curr)
#define check_not_freed_operator(curr)
void check_not_freed_director_set (director_set curr);
void check_not_freed_trans_pair (trans_pair curr);

/* Introduce recursive refcount checking of lists */
void check_not_freed_affix_value_list (affix_value_list curr);
void check_not_freed_rt_element_list (rt_element_list curr);
void check_not_freed_rt_domain_list (rt_domain_list curr);
void check_not_freed_rt_elem_list (rt_elem_list curr);
void check_not_freed_rt_alt_list (rt_alt_list curr);
void check_not_freed_rt_type_list (rt_type_list curr);
void check_not_freed_cset_part_list (cset_part_list curr);
void check_not_freed_cset_list (cset_list curr);
void check_not_freed_terminal_list (terminal_list curr);
void check_not_freed_nfa_state_list (nfa_state_list curr);
void check_not_freed_nfa_trans_list (nfa_trans_list curr);
void check_not_freed_nfa_list (nfa_list curr);
void check_not_freed_lex_nont_list (lex_nont_list curr);
void check_not_freed_rt_nont_list (rt_nont_list curr);
void check_not_freed_ext_nont_list (ext_nont_list curr);
void check_not_freed_trans_pair_list (trans_pair_list curr);
void check_not_freed_int_list_list (int_list_list curr);
void check_not_freed_u_int64_list (u_int64_list curr);

#endif /* IncEbase_ds */
