/*
   File: ebase_ds.c
   Generated on Sat Apr 13 13:13:03 2013
*/

/* standard includes */
#include <stdio.h>

/* support lib includes */
#include <dcg.h>
#include <dcg_error.h>
#include <dcg_alloc.h>
#include <dcg_string.h>
#include <dcg_dump.h>
#include <dcg_binfile.h>

/* local includes */
#include "ebase_ds.h"

/* Allocate new affix_value_list */
affix_value_list init_affix_value_list (int room)
{ affix_value_list new = (affix_value_list) dcg_malloc (sizeof (struct str_affix_value_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (affix_value *) dcg_calloc (safe_room, sizeof (affix_value));
  return (new);
}

/* Allocate new rt_element_list */
rt_element_list init_rt_element_list (int room)
{ rt_element_list new = (rt_element_list) dcg_malloc (sizeof (struct str_rt_element_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (rt_element *) dcg_calloc (safe_room, sizeof (rt_element));
  return (new);
}

/* Allocate new rt_domain_list */
rt_domain_list init_rt_domain_list (int room)
{ rt_domain_list new = (rt_domain_list) dcg_malloc (sizeof (struct str_rt_domain_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (rt_domain *) dcg_calloc (safe_room, sizeof (rt_domain));
  return (new);
}

/* Allocate new rt_elem_list */
rt_elem_list init_rt_elem_list (int room)
{ rt_elem_list new = (rt_elem_list) dcg_malloc (sizeof (struct str_rt_elem_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (rt_elem *) dcg_calloc (safe_room, sizeof (rt_elem));
  return (new);
}

/* Allocate new rt_alt_list */
rt_alt_list init_rt_alt_list (int room)
{ rt_alt_list new = (rt_alt_list) dcg_malloc (sizeof (struct str_rt_alt_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (rt_alt *) dcg_calloc (safe_room, sizeof (rt_alt));
  return (new);
}

/* Allocate new rt_type_list */
rt_type_list init_rt_type_list (int room)
{ rt_type_list new = (rt_type_list) dcg_malloc (sizeof (struct str_rt_type_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (rt_type *) dcg_calloc (safe_room, sizeof (rt_type));
  return (new);
}

/* Allocate new cset_part_list */
cset_part_list init_cset_part_list (int room)
{ cset_part_list new = (cset_part_list) dcg_malloc (sizeof (struct str_cset_part_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (cset_part *) dcg_calloc (safe_room, sizeof (cset_part));
  return (new);
}

/* Allocate new cset_list */
cset_list init_cset_list (int room)
{ cset_list new = (cset_list) dcg_malloc (sizeof (struct str_cset_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (cset *) dcg_calloc (safe_room, sizeof (cset));
  return (new);
}

/* Allocate new terminal_list */
terminal_list init_terminal_list (int room)
{ terminal_list new = (terminal_list) dcg_malloc (sizeof (struct str_terminal_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (terminal *) dcg_calloc (safe_room, sizeof (terminal));
  return (new);
}

/* Allocate new nfa_state_list */
nfa_state_list init_nfa_state_list (int room)
{ nfa_state_list new = (nfa_state_list) dcg_malloc (sizeof (struct str_nfa_state_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (nfa_state *) dcg_calloc (safe_room, sizeof (nfa_state));
  return (new);
}

/* Allocate new nfa_trans_list */
nfa_trans_list init_nfa_trans_list (int room)
{ nfa_trans_list new = (nfa_trans_list) dcg_malloc (sizeof (struct str_nfa_trans_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (nfa_trans *) dcg_calloc (safe_room, sizeof (nfa_trans));
  return (new);
}

/* Allocate new nfa_list */
nfa_list init_nfa_list (int room)
{ nfa_list new = (nfa_list) dcg_malloc (sizeof (struct str_nfa_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (nfa *) dcg_calloc (safe_room, sizeof (nfa));
  return (new);
}

/* Allocate new lex_nont_list */
lex_nont_list init_lex_nont_list (int room)
{ lex_nont_list new = (lex_nont_list) dcg_malloc (sizeof (struct str_lex_nont_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (lex_nont *) dcg_calloc (safe_room, sizeof (lex_nont));
  return (new);
}

/* Allocate new rt_nont_list */
rt_nont_list init_rt_nont_list (int room)
{ rt_nont_list new = (rt_nont_list) dcg_malloc (sizeof (struct str_rt_nont_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (rt_nont *) dcg_calloc (safe_room, sizeof (rt_nont));
  return (new);
}

/* Allocate new ext_nont_list */
ext_nont_list init_ext_nont_list (int room)
{ ext_nont_list new = (ext_nont_list) dcg_malloc (sizeof (struct str_ext_nont_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (ext_nont *) dcg_calloc (safe_room, sizeof (ext_nont));
  return (new);
}

/* Allocate new trans_pair_list */
trans_pair_list init_trans_pair_list (int room)
{ trans_pair_list new = (trans_pair_list) dcg_malloc (sizeof (struct str_trans_pair_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (trans_pair *) dcg_calloc (safe_room, sizeof (trans_pair));
  return (new);
}

/* Allocate new int_list_list */
int_list_list init_int_list_list (int room)
{ int_list_list new = (int_list_list) dcg_malloc (sizeof (struct str_int_list_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (int_list *) dcg_calloc (safe_room, sizeof (int_list));
  return (new);
}

/* Allocate new u_int64_list */
u_int64_list init_u_int64_list (int room)
{ u_int64_list new = (u_int64_list) dcg_malloc (sizeof (struct str_u_int64_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (u_int64 *) dcg_calloc (safe_room, sizeof (u_int64));
  return (new);
}

/* Announce to use 'room' chunks for affix_value_list */
void room_affix_value_list (affix_value_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (affix_value));
  l -> room = room;
}

/* Announce to use 'room' chunks for rt_element_list */
void room_rt_element_list (rt_element_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (rt_element));
  l -> room = room;
}

/* Announce to use 'room' chunks for rt_domain_list */
void room_rt_domain_list (rt_domain_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (rt_domain));
  l -> room = room;
}

/* Announce to use 'room' chunks for rt_elem_list */
void room_rt_elem_list (rt_elem_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (rt_elem));
  l -> room = room;
}

/* Announce to use 'room' chunks for rt_alt_list */
void room_rt_alt_list (rt_alt_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (rt_alt));
  l -> room = room;
}

/* Announce to use 'room' chunks for rt_type_list */
void room_rt_type_list (rt_type_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (rt_type));
  l -> room = room;
}

/* Announce to use 'room' chunks for cset_part_list */
void room_cset_part_list (cset_part_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (cset_part));
  l -> room = room;
}

/* Announce to use 'room' chunks for cset_list */
void room_cset_list (cset_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (cset));
  l -> room = room;
}

/* Announce to use 'room' chunks for terminal_list */
void room_terminal_list (terminal_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (terminal));
  l -> room = room;
}

/* Announce to use 'room' chunks for nfa_state_list */
void room_nfa_state_list (nfa_state_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (nfa_state));
  l -> room = room;
}

/* Announce to use 'room' chunks for nfa_trans_list */
void room_nfa_trans_list (nfa_trans_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (nfa_trans));
  l -> room = room;
}

/* Announce to use 'room' chunks for nfa_list */
void room_nfa_list (nfa_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (nfa));
  l -> room = room;
}

/* Announce to use 'room' chunks for lex_nont_list */
void room_lex_nont_list (lex_nont_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (lex_nont));
  l -> room = room;
}

/* Announce to use 'room' chunks for rt_nont_list */
void room_rt_nont_list (rt_nont_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (rt_nont));
  l -> room = room;
}

/* Announce to use 'room' chunks for ext_nont_list */
void room_ext_nont_list (ext_nont_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (ext_nont));
  l -> room = room;
}

/* Announce to use 'room' chunks for trans_pair_list */
void room_trans_pair_list (trans_pair_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (trans_pair));
  l -> room = room;
}

/* Announce to use 'room' chunks for int_list_list */
void room_int_list_list (int_list_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (int_list));
  l -> room = room;
}

/* Announce to use 'room' chunks for u_int64_list */
void room_u_int64_list (u_int64_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (u_int64));
  l -> room = room;
}

/* Allocate new affix_value record for constructor Null_value */
affix_value new_Null_value (int rule_nr)
{ affix_value new = (affix_value) dcg_malloc (sizeof (struct str_affix_value));
  new -> rule_nr = rule_nr;
  new -> tag = TAGNull_value;
  return (new);
}

/* Allocate new affix_value record for constructor Text_value */
affix_value new_Text_value (int rule_nr,
		string text)
{ affix_value new = (affix_value) dcg_malloc (sizeof (struct str_affix_value));
  new -> rule_nr = rule_nr;
  new -> tag = TAGText_value;
  new -> Text_value.text = text;
  return (new);
}

/* Allocate new affix_value record for constructor Int_value */
affix_value new_Int_value (int rule_nr,
		int ival)
{ affix_value new = (affix_value) dcg_malloc (sizeof (struct str_affix_value));
  new -> rule_nr = rule_nr;
  new -> tag = TAGInt_value;
  new -> Int_value.ival = ival;
  return (new);
}

/* Allocate new affix_value record for constructor Real_value */
affix_value new_Real_value (int rule_nr,
		real rval)
{ affix_value new = (affix_value) dcg_malloc (sizeof (struct str_affix_value));
  new -> rule_nr = rule_nr;
  new -> tag = TAGReal_value;
  new -> Real_value.rval = rval;
  return (new);
}

/* Allocate new affix_value record for constructor Small_lattice */
affix_value new_Small_lattice (int rule_nr,
		int dom, u_int64 slat)
{ affix_value new = (affix_value) dcg_malloc (sizeof (struct str_affix_value));
  new -> rule_nr = rule_nr;
  new -> tag = TAGSmall_lattice;
  new -> Small_lattice.dom = dom;
  new -> Small_lattice.slat = slat;
  return (new);
}

/* Allocate new affix_value record for constructor Large_lattice */
affix_value new_Large_lattice (int rule_nr,
		int dom, u_int64_list llat)
{ affix_value new = (affix_value) dcg_malloc (sizeof (struct str_affix_value));
  new -> rule_nr = rule_nr;
  new -> tag = TAGLarge_lattice;
  new -> Large_lattice.dom = dom;
  new -> Large_lattice.llat = llat;
  return (new);
}

/* Allocate new affix_value record for constructor List_lattice */
affix_value new_List_lattice (int rule_nr,
		int_list llat)
{ affix_value new = (affix_value) dcg_malloc (sizeof (struct str_affix_value));
  new -> rule_nr = rule_nr;
  new -> tag = TAGList_lattice;
  new -> List_lattice.llat = llat;
  return (new);
}

/* Allocate new affix_value record for constructor Composed_value */
affix_value new_Composed_value (int rule_nr,
		int marker, affix_value_list parts)
{ affix_value new = (affix_value) dcg_malloc (sizeof (struct str_affix_value));
  new -> rule_nr = rule_nr;
  new -> tag = TAGComposed_value;
  new -> Composed_value.marker = marker;
  new -> Composed_value.parts = parts;
  return (new);
}

/* Allocate new rt_element record */
rt_element new_rt_element (string name, affix_value value)
{ rt_element new = (rt_element) dcg_malloc (sizeof (struct str_rt_element));
  new -> name = name;
  new -> value = value;
  return (new);
};

/* Allocate new rt_domain record */
rt_domain new_rt_domain (int width, rt_element_list elts)
{ rt_domain new = (rt_domain) dcg_malloc (sizeof (struct str_rt_domain));
  new -> width = width;
  new -> elts = elts;
  return (new);
};

/* Allocate new rt_elem record for constructor Marker */
rt_elem new_Marker (string txt)
{ rt_elem new = (rt_elem) dcg_malloc (sizeof (struct str_rt_elem));
  new -> tag = TAGMarker;
  new -> Marker.txt = txt;
  return (new);
}

/* Allocate new rt_elem record for constructor Ref */
rt_elem new_Ref (int rnr)
{ rt_elem new = (rt_elem) dcg_malloc (sizeof (struct str_rt_elem));
  new -> tag = TAGRef;
  new -> Ref.rnr = rnr;
  return (new);
}

/* Allocate new rt_alt record */
rt_alt new_rt_alt (int marker, rt_elem_list elems)
{ rt_alt new = (rt_alt) dcg_malloc (sizeof (struct str_rt_alt));
  new -> marker = marker;
  new -> elems = elems;
  return (new);
};

/* Allocate new rt_type record for constructor Synonym_type */
rt_type new_Synonym_type (int rule_nr, string name, int lexgen, affix_value value,
		int snr)
{ rt_type new = (rt_type) dcg_malloc (sizeof (struct str_rt_type));
  new -> rule_nr = rule_nr;
  new -> name = name;
  new -> lexgen = lexgen;
  new -> value = value;
  new -> print_code = vptr_nil;
  new -> meta_code = vptr_nil;
  new -> meta_rec_code = vptr_nil;
  new -> tag = TAGSynonym_type;
  new -> Synonym_type.snr = snr;
  return (new);
}

/* Allocate new rt_type record for constructor Any_type */
rt_type new_Any_type (int rule_nr, string name, int lexgen, affix_value value)
{ rt_type new = (rt_type) dcg_malloc (sizeof (struct str_rt_type));
  new -> rule_nr = rule_nr;
  new -> name = name;
  new -> lexgen = lexgen;
  new -> value = value;
  new -> print_code = vptr_nil;
  new -> meta_code = vptr_nil;
  new -> meta_rec_code = vptr_nil;
  new -> tag = TAGAny_type;
  return (new);
}

/* Allocate new rt_type record for constructor Int_type */
rt_type new_Int_type (int rule_nr, string name, int lexgen, affix_value value)
{ rt_type new = (rt_type) dcg_malloc (sizeof (struct str_rt_type));
  new -> rule_nr = rule_nr;
  new -> name = name;
  new -> lexgen = lexgen;
  new -> value = value;
  new -> print_code = vptr_nil;
  new -> meta_code = vptr_nil;
  new -> meta_rec_code = vptr_nil;
  new -> tag = TAGInt_type;
  return (new);
}

/* Allocate new rt_type record for constructor Real_type */
rt_type new_Real_type (int rule_nr, string name, int lexgen, affix_value value)
{ rt_type new = (rt_type) dcg_malloc (sizeof (struct str_rt_type));
  new -> rule_nr = rule_nr;
  new -> name = name;
  new -> lexgen = lexgen;
  new -> value = value;
  new -> print_code = vptr_nil;
  new -> meta_code = vptr_nil;
  new -> meta_rec_code = vptr_nil;
  new -> tag = TAGReal_type;
  return (new);
}

/* Allocate new rt_type record for constructor Text_type */
rt_type new_Text_type (int rule_nr, string name, int lexgen, affix_value value)
{ rt_type new = (rt_type) dcg_malloc (sizeof (struct str_rt_type));
  new -> rule_nr = rule_nr;
  new -> name = name;
  new -> lexgen = lexgen;
  new -> value = value;
  new -> print_code = vptr_nil;
  new -> meta_code = vptr_nil;
  new -> meta_rec_code = vptr_nil;
  new -> tag = TAGText_type;
  return (new);
}

/* Allocate new rt_type record for constructor Lattice_type */
rt_type new_Lattice_type (int rule_nr, string name, int lexgen, affix_value value,
		int dom)
{ rt_type new = (rt_type) dcg_malloc (sizeof (struct str_rt_type));
  new -> rule_nr = rule_nr;
  new -> name = name;
  new -> lexgen = lexgen;
  new -> value = value;
  new -> print_code = vptr_nil;
  new -> meta_code = vptr_nil;
  new -> meta_rec_code = vptr_nil;
  new -> tag = TAGLattice_type;
  new -> Lattice_type.dom = dom;
  return (new);
}

/* Allocate new rt_type record for constructor Tree_type */
rt_type new_Tree_type (int rule_nr, string name, int lexgen, affix_value value,
		rt_alt_list alts)
{ rt_type new = (rt_type) dcg_malloc (sizeof (struct str_rt_type));
  new -> rule_nr = rule_nr;
  new -> name = name;
  new -> lexgen = lexgen;
  new -> value = value;
  new -> print_code = vptr_nil;
  new -> meta_code = vptr_nil;
  new -> meta_rec_code = vptr_nil;
  new -> tag = TAGTree_type;
  new -> Tree_type.alts = alts;
  return (new);
}

/* Allocate new cset_part record for constructor Part_match */
cset_part new_Part_match (int ch)
{ cset_part new = (cset_part) dcg_malloc (sizeof (struct str_cset_part));
  new -> tag = TAGPart_match;
  new -> Part_match.ch = ch;
  return (new);
}

/* Allocate new cset_part record for constructor Part_range */
cset_part new_Part_range (int first, int last)
{ cset_part new = (cset_part) dcg_malloc (sizeof (struct str_cset_part));
  new -> tag = TAGPart_range;
  new -> Part_range.first = first;
  new -> Part_range.last = last;
  return (new);
}

/* Allocate new cset record */
cset new_cset (int invert, cset_part_list parts)
{ cset new = (cset) dcg_malloc (sizeof (struct str_cset));
  new -> invert = invert;
  new -> parts = parts;
  return (new);
};

/* Allocate new terminal record */
terminal new_terminal (int marker, int_list text, string origin)
{ terminal new = (terminal) dcg_malloc (sizeof (struct str_terminal));
  new -> marker = marker;
  new -> text = text;
  new -> origin = origin;
  return (new);
};

/* Allocate new nfa_state record */
nfa_state new_nfa_state (int self, int final, nfa_trans_list transitions)
{ nfa_state new = (nfa_state) dcg_malloc (sizeof (struct str_nfa_state));
  new -> self = self;
  new -> final = final;
  new -> transitions = transitions;
  new -> indeg = int_nil;
  return (new);
};

/* Allocate new nfa_trans record for constructor Trans_char */
nfa_trans new_Trans_char (int dest,
		int ch)
{ nfa_trans new = (nfa_trans) dcg_malloc (sizeof (struct str_nfa_trans));
  new -> dest = dest;
  new -> tag = TAGTrans_char;
  new -> Trans_char.ch = ch;
  return (new);
}

/* Allocate new nfa_trans record for constructor Trans_cset */
nfa_trans new_Trans_cset (int dest,
		int cs)
{ nfa_trans new = (nfa_trans) dcg_malloc (sizeof (struct str_nfa_trans));
  new -> dest = dest;
  new -> tag = TAGTrans_cset;
  new -> Trans_cset.cs = cs;
  return (new);
}

/* Allocate new nfa_trans record for constructor Trans_anychar */
nfa_trans new_Trans_anychar (int dest)
{ nfa_trans new = (nfa_trans) dcg_malloc (sizeof (struct str_nfa_trans));
  new -> dest = dest;
  new -> tag = TAGTrans_anychar;
  return (new);
}

/* Allocate new nfa_trans record for constructor Trans_whitespace */
nfa_trans new_Trans_whitespace (int dest)
{ nfa_trans new = (nfa_trans) dcg_malloc (sizeof (struct str_nfa_trans));
  new -> dest = dest;
  new -> tag = TAGTrans_whitespace;
  return (new);
}

/* Allocate new nfa_trans record for constructor Trans_nonwhitespace */
nfa_trans new_Trans_nonwhitespace (int dest)
{ nfa_trans new = (nfa_trans) dcg_malloc (sizeof (struct str_nfa_trans));
  new -> dest = dest;
  new -> tag = TAGTrans_nonwhitespace;
  return (new);
}

/* Allocate new nfa_trans record for constructor Trans_empty */
nfa_trans new_Trans_empty (int dest)
{ nfa_trans new = (nfa_trans) dcg_malloc (sizeof (struct str_nfa_trans));
  new -> dest = dest;
  new -> tag = TAGTrans_empty;
  return (new);
}

/* Allocate new nfa record */
nfa new_nfa (int kind, int marker, string origin, nfa_state_list states)
{ nfa new = (nfa) dcg_malloc (sizeof (struct str_nfa));
  new -> kind = kind;
  new -> marker = marker;
  new -> origin = origin;
  new -> states = states;
  return (new);
};

/* Allocate new lex_nont record */
lex_nont new_lex_nont (int rule_nr, int fact_nr, string_list name_parts, int_list name_chars, int ncrits, int_list formals, int_list crits)
{ lex_nont new = (lex_nont) dcg_malloc (sizeof (struct str_lex_nont));
  new -> rule_nr = rule_nr;
  new -> fact_nr = fact_nr;
  new -> name_parts = name_parts;
  new -> name_chars = name_chars;
  new -> ncrits = ncrits;
  new -> formals = formals;
  new -> crits = crits;
  return (new);
};

/* Allocate new rt_nont record */
rt_nont new_rt_nont (string_list name_parts, int_list name_chars, string canonic_name, int_list formals, int lex_nr)
{ rt_nont new = (rt_nont) dcg_malloc (sizeof (struct str_rt_nont));
  new -> name_parts = name_parts;
  new -> name_chars = name_chars;
  new -> canonic_name = canonic_name;
  new -> formals = formals;
  new -> lex_nr = lex_nr;
  return (new);
};

/* Allocate new ext_nont record */
ext_nont new_ext_nont (string canonic_name, int rule_nr)
{ ext_nont new = (ext_nont) dcg_malloc (sizeof (struct str_ext_nont));
  new -> canonic_name = canonic_name;
  new -> rule_nr = rule_nr;
  return (new);
};

/* Allocate new director_set record */
director_set new_director_set (int min_phase, trans_pair_list set)
{ director_set new = (director_set) dcg_malloc (sizeof (struct str_director_set));
  new -> min_phase = min_phase;
  new -> set = set;
  return (new);
};

/* Allocate new trans_pair record */
trans_pair new_trans_pair (int class, int number)
{ trans_pair new = (trans_pair) dcg_malloc (sizeof (struct str_trans_pair));
  new -> class = class;
  new -> number = number;
  return (new);
};

/* Recursively detach a affix_value */
void detach_affix_value (affix_value *optr)
{ affix_value old = (affix_value) dcg_predetach ((void **) optr);
  if (old == affix_value_nil) return;
  detach_int (&(old -> rule_nr));
  switch (old -> tag)
    { case TAGNull_value:
	break;
      case TAGText_value:
	detach_string (&(old -> Text_value.text));
	break;
      case TAGInt_value:
	detach_int (&(old -> Int_value.ival));
	break;
      case TAGReal_value:
	detach_real (&(old -> Real_value.rval));
	break;
      case TAGSmall_lattice:
	detach_int (&(old -> Small_lattice.dom));
	detach_u_int64 (&(old -> Small_lattice.slat));
	break;
      case TAGLarge_lattice:
	detach_int (&(old -> Large_lattice.dom));
	detach_u_int64_list (&(old -> Large_lattice.llat));
	break;
      case TAGList_lattice:
	detach_int_list (&(old -> List_lattice.llat));
	break;
      case TAGComposed_value:
	detach_int (&(old -> Composed_value.marker));
	detach_affix_value_list (&(old -> Composed_value.parts));
	break;
      default:
	dcg_bad_tag ((int) old -> tag, "detach_affix_value");
    };
  dcg_detach ((void **) &old);
}

/* Recursively detach a rt_element */
void detach_rt_element (rt_element *optr)
{ rt_element old = (rt_element) dcg_predetach ((void **) optr);
  if (old == rt_element_nil) return;
  detach_string (&(old -> name));
  detach_affix_value (&(old -> value));
  dcg_detach ((void **) &old);
}

/* Recursively detach a rt_domain */
void detach_rt_domain (rt_domain *optr)
{ rt_domain old = (rt_domain) dcg_predetach ((void **) optr);
  if (old == rt_domain_nil) return;
  detach_int (&(old -> width));
  detach_rt_element_list (&(old -> elts));
  dcg_detach ((void **) &old);
}

/* Recursively detach a rt_elem */
void detach_rt_elem (rt_elem *optr)
{ rt_elem old = (rt_elem) dcg_predetach ((void **) optr);
  if (old == rt_elem_nil) return;
  switch (old -> tag)
    { case TAGMarker:
	detach_string (&(old -> Marker.txt));
	break;
      case TAGRef:
	detach_int (&(old -> Ref.rnr));
	break;
      default:
	dcg_bad_tag ((int) old -> tag, "detach_rt_elem");
    };
  dcg_detach ((void **) &old);
}

/* Recursively detach a rt_alt */
void detach_rt_alt (rt_alt *optr)
{ rt_alt old = (rt_alt) dcg_predetach ((void **) optr);
  if (old == rt_alt_nil) return;
  detach_int (&(old -> marker));
  detach_rt_elem_list (&(old -> elems));
  dcg_detach ((void **) &old);
}

/* Recursively detach a rt_type */
void detach_rt_type (rt_type *optr)
{ rt_type old = (rt_type) dcg_predetach ((void **) optr);
  if (old == rt_type_nil) return;
  detach_int (&(old -> rule_nr));
  detach_string (&(old -> name));
  detach_int (&(old -> lexgen));
  detach_affix_value (&(old -> value));
  switch (old -> tag)
    { case TAGSynonym_type:
	detach_int (&(old -> Synonym_type.snr));
	break;
      case TAGAny_type:
	break;
      case TAGInt_type:
	break;
      case TAGReal_type:
	break;
      case TAGText_type:
	break;
      case TAGLattice_type:
	detach_int (&(old -> Lattice_type.dom));
	break;
      case TAGTree_type:
	detach_rt_alt_list (&(old -> Tree_type.alts));
	break;
      default:
	dcg_bad_tag ((int) old -> tag, "detach_rt_type");
    };
  dcg_detach ((void **) &old);
}

/* Recursively detach a cset_part */
void detach_cset_part (cset_part *optr)
{ cset_part old = (cset_part) dcg_predetach ((void **) optr);
  if (old == cset_part_nil) return;
  switch (old -> tag)
    { case TAGPart_match:
	detach_int (&(old -> Part_match.ch));
	break;
      case TAGPart_range:
	detach_int (&(old -> Part_range.first));
	detach_int (&(old -> Part_range.last));
	break;
      default:
	dcg_bad_tag ((int) old -> tag, "detach_cset_part");
    };
  dcg_detach ((void **) &old);
}

/* Recursively detach a cset */
void detach_cset (cset *optr)
{ cset old = (cset) dcg_predetach ((void **) optr);
  if (old == cset_nil) return;
  detach_int (&(old -> invert));
  detach_cset_part_list (&(old -> parts));
  dcg_detach ((void **) &old);
}

/* Recursively detach a terminal */
void detach_terminal (terminal *optr)
{ terminal old = (terminal) dcg_predetach ((void **) optr);
  if (old == terminal_nil) return;
  detach_int (&(old -> marker));
  detach_int_list (&(old -> text));
  detach_string (&(old -> origin));
  dcg_detach ((void **) &old);
}

/* Recursively detach a nfa_state */
void detach_nfa_state (nfa_state *optr)
{ nfa_state old = (nfa_state) dcg_predetach ((void **) optr);
  if (old == nfa_state_nil) return;
  detach_int (&(old -> self));
  detach_int (&(old -> final));
  detach_nfa_trans_list (&(old -> transitions));
  dcg_detach ((void **) &old);
}

/* Recursively detach a nfa_trans */
void detach_nfa_trans (nfa_trans *optr)
{ nfa_trans old = (nfa_trans) dcg_predetach ((void **) optr);
  if (old == nfa_trans_nil) return;
  detach_int (&(old -> dest));
  switch (old -> tag)
    { case TAGTrans_char:
	detach_int (&(old -> Trans_char.ch));
	break;
      case TAGTrans_cset:
	detach_int (&(old -> Trans_cset.cs));
	break;
      case TAGTrans_anychar:
	break;
      case TAGTrans_whitespace:
	break;
      case TAGTrans_nonwhitespace:
	break;
      case TAGTrans_empty:
	break;
      default:
	dcg_bad_tag ((int) old -> tag, "detach_nfa_trans");
    };
  dcg_detach ((void **) &old);
}

/* Recursively detach a nfa */
void detach_nfa (nfa *optr)
{ nfa old = (nfa) dcg_predetach ((void **) optr);
  if (old == nfa_nil) return;
  detach_int (&(old -> kind));
  detach_int (&(old -> marker));
  detach_string (&(old -> origin));
  detach_nfa_state_list (&(old -> states));
  dcg_detach ((void **) &old);
}

/* Recursively detach a lex_nont */
void detach_lex_nont (lex_nont *optr)
{ lex_nont old = (lex_nont) dcg_predetach ((void **) optr);
  if (old == lex_nont_nil) return;
  detach_int (&(old -> rule_nr));
  detach_int (&(old -> fact_nr));
  detach_string_list (&(old -> name_parts));
  detach_int_list (&(old -> name_chars));
  detach_int (&(old -> ncrits));
  detach_int_list (&(old -> formals));
  detach_int_list (&(old -> crits));
  dcg_detach ((void **) &old);
}

/* Recursively detach a rt_nont */
void detach_rt_nont (rt_nont *optr)
{ rt_nont old = (rt_nont) dcg_predetach ((void **) optr);
  if (old == rt_nont_nil) return;
  detach_string_list (&(old -> name_parts));
  detach_int_list (&(old -> name_chars));
  detach_string (&(old -> canonic_name));
  detach_int_list (&(old -> formals));
  detach_int (&(old -> lex_nr));
  dcg_detach ((void **) &old);
}

/* Recursively detach a ext_nont */
void detach_ext_nont (ext_nont *optr)
{ ext_nont old = (ext_nont) dcg_predetach ((void **) optr);
  if (old == ext_nont_nil) return;
  detach_string (&(old -> canonic_name));
  detach_int (&(old -> rule_nr));
  dcg_detach ((void **) &old);
}

/* Recursively detach a director_set */
void detach_director_set (director_set *optr)
{ director_set old = (director_set) dcg_predetach ((void **) optr);
  if (old == director_set_nil) return;
  detach_int (&(old -> min_phase));
  detach_trans_pair_list (&(old -> set));
  dcg_detach ((void **) &old);
}

/* Recursively detach a trans_pair */
void detach_trans_pair (trans_pair *optr)
{ trans_pair old = (trans_pair) dcg_predetach ((void **) optr);
  if (old == trans_pair_nil) return;
  detach_int (&(old -> class));
  detach_int (&(old -> number));
  dcg_detach ((void **) &old);
}

/* Recursively detach a affix_value_list */
void detach_affix_value_list (affix_value_list *lp)
{ int ix;
  affix_value_list old = (affix_value_list) dcg_predetach ((void **) lp);
  if (old == affix_value_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_affix_value (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a rt_element_list */
void detach_rt_element_list (rt_element_list *lp)
{ int ix;
  rt_element_list old = (rt_element_list) dcg_predetach ((void **) lp);
  if (old == rt_element_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_rt_element (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a rt_domain_list */
void detach_rt_domain_list (rt_domain_list *lp)
{ int ix;
  rt_domain_list old = (rt_domain_list) dcg_predetach ((void **) lp);
  if (old == rt_domain_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_rt_domain (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a rt_elem_list */
void detach_rt_elem_list (rt_elem_list *lp)
{ int ix;
  rt_elem_list old = (rt_elem_list) dcg_predetach ((void **) lp);
  if (old == rt_elem_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_rt_elem (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a rt_alt_list */
void detach_rt_alt_list (rt_alt_list *lp)
{ int ix;
  rt_alt_list old = (rt_alt_list) dcg_predetach ((void **) lp);
  if (old == rt_alt_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_rt_alt (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a rt_type_list */
void detach_rt_type_list (rt_type_list *lp)
{ int ix;
  rt_type_list old = (rt_type_list) dcg_predetach ((void **) lp);
  if (old == rt_type_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_rt_type (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a cset_part_list */
void detach_cset_part_list (cset_part_list *lp)
{ int ix;
  cset_part_list old = (cset_part_list) dcg_predetach ((void **) lp);
  if (old == cset_part_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_cset_part (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a cset_list */
void detach_cset_list (cset_list *lp)
{ int ix;
  cset_list old = (cset_list) dcg_predetach ((void **) lp);
  if (old == cset_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_cset (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a terminal_list */
void detach_terminal_list (terminal_list *lp)
{ int ix;
  terminal_list old = (terminal_list) dcg_predetach ((void **) lp);
  if (old == terminal_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_terminal (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a nfa_state_list */
void detach_nfa_state_list (nfa_state_list *lp)
{ int ix;
  nfa_state_list old = (nfa_state_list) dcg_predetach ((void **) lp);
  if (old == nfa_state_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_nfa_state (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a nfa_trans_list */
void detach_nfa_trans_list (nfa_trans_list *lp)
{ int ix;
  nfa_trans_list old = (nfa_trans_list) dcg_predetach ((void **) lp);
  if (old == nfa_trans_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_nfa_trans (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a nfa_list */
void detach_nfa_list (nfa_list *lp)
{ int ix;
  nfa_list old = (nfa_list) dcg_predetach ((void **) lp);
  if (old == nfa_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_nfa (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a lex_nont_list */
void detach_lex_nont_list (lex_nont_list *lp)
{ int ix;
  lex_nont_list old = (lex_nont_list) dcg_predetach ((void **) lp);
  if (old == lex_nont_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_lex_nont (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a rt_nont_list */
void detach_rt_nont_list (rt_nont_list *lp)
{ int ix;
  rt_nont_list old = (rt_nont_list) dcg_predetach ((void **) lp);
  if (old == rt_nont_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_rt_nont (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a ext_nont_list */
void detach_ext_nont_list (ext_nont_list *lp)
{ int ix;
  ext_nont_list old = (ext_nont_list) dcg_predetach ((void **) lp);
  if (old == ext_nont_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_ext_nont (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a trans_pair_list */
void detach_trans_pair_list (trans_pair_list *lp)
{ int ix;
  trans_pair_list old = (trans_pair_list) dcg_predetach ((void **) lp);
  if (old == trans_pair_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_trans_pair (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a int_list_list */
void detach_int_list_list (int_list_list *lp)
{ int ix;
  int_list_list old = (int_list_list) dcg_predetach ((void **) lp);
  if (old == int_list_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_int_list (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a u_int64_list */
void detach_u_int64_list (u_int64_list *lp)
{ int ix;
  u_int64_list old = (u_int64_list) dcg_predetach ((void **) lp);
  if (old == u_int64_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_u_int64 (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a affix_value_list without detaching elements */
void nonrec_detach_affix_value_list (affix_value_list *lp)
{ affix_value_list old = (affix_value_list) dcg_predetach ((void **) lp);
  if (old == affix_value_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a rt_element_list without detaching elements */
void nonrec_detach_rt_element_list (rt_element_list *lp)
{ rt_element_list old = (rt_element_list) dcg_predetach ((void **) lp);
  if (old == rt_element_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a rt_domain_list without detaching elements */
void nonrec_detach_rt_domain_list (rt_domain_list *lp)
{ rt_domain_list old = (rt_domain_list) dcg_predetach ((void **) lp);
  if (old == rt_domain_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a rt_elem_list without detaching elements */
void nonrec_detach_rt_elem_list (rt_elem_list *lp)
{ rt_elem_list old = (rt_elem_list) dcg_predetach ((void **) lp);
  if (old == rt_elem_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a rt_alt_list without detaching elements */
void nonrec_detach_rt_alt_list (rt_alt_list *lp)
{ rt_alt_list old = (rt_alt_list) dcg_predetach ((void **) lp);
  if (old == rt_alt_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a rt_type_list without detaching elements */
void nonrec_detach_rt_type_list (rt_type_list *lp)
{ rt_type_list old = (rt_type_list) dcg_predetach ((void **) lp);
  if (old == rt_type_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a cset_part_list without detaching elements */
void nonrec_detach_cset_part_list (cset_part_list *lp)
{ cset_part_list old = (cset_part_list) dcg_predetach ((void **) lp);
  if (old == cset_part_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a cset_list without detaching elements */
void nonrec_detach_cset_list (cset_list *lp)
{ cset_list old = (cset_list) dcg_predetach ((void **) lp);
  if (old == cset_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a terminal_list without detaching elements */
void nonrec_detach_terminal_list (terminal_list *lp)
{ terminal_list old = (terminal_list) dcg_predetach ((void **) lp);
  if (old == terminal_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a nfa_state_list without detaching elements */
void nonrec_detach_nfa_state_list (nfa_state_list *lp)
{ nfa_state_list old = (nfa_state_list) dcg_predetach ((void **) lp);
  if (old == nfa_state_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a nfa_trans_list without detaching elements */
void nonrec_detach_nfa_trans_list (nfa_trans_list *lp)
{ nfa_trans_list old = (nfa_trans_list) dcg_predetach ((void **) lp);
  if (old == nfa_trans_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a nfa_list without detaching elements */
void nonrec_detach_nfa_list (nfa_list *lp)
{ nfa_list old = (nfa_list) dcg_predetach ((void **) lp);
  if (old == nfa_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a lex_nont_list without detaching elements */
void nonrec_detach_lex_nont_list (lex_nont_list *lp)
{ lex_nont_list old = (lex_nont_list) dcg_predetach ((void **) lp);
  if (old == lex_nont_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a rt_nont_list without detaching elements */
void nonrec_detach_rt_nont_list (rt_nont_list *lp)
{ rt_nont_list old = (rt_nont_list) dcg_predetach ((void **) lp);
  if (old == rt_nont_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a ext_nont_list without detaching elements */
void nonrec_detach_ext_nont_list (ext_nont_list *lp)
{ ext_nont_list old = (ext_nont_list) dcg_predetach ((void **) lp);
  if (old == ext_nont_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a trans_pair_list without detaching elements */
void nonrec_detach_trans_pair_list (trans_pair_list *lp)
{ trans_pair_list old = (trans_pair_list) dcg_predetach ((void **) lp);
  if (old == trans_pair_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a int_list_list without detaching elements */
void nonrec_detach_int_list_list (int_list_list *lp)
{ int_list_list old = (int_list_list) dcg_predetach ((void **) lp);
  if (old == int_list_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a u_int64_list without detaching elements */
void nonrec_detach_u_int64_list (u_int64_list *lp)
{ u_int64_list old = (u_int64_list) dcg_predetach ((void **) lp);
  if (old == u_int64_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Append element to affix_value_list */
affix_value_list append_affix_value_list (affix_value_list l, affix_value el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_affix_value_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to rt_element_list */
rt_element_list append_rt_element_list (rt_element_list l, rt_element el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_rt_element_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to rt_domain_list */
rt_domain_list append_rt_domain_list (rt_domain_list l, rt_domain el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_rt_domain_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to rt_elem_list */
rt_elem_list append_rt_elem_list (rt_elem_list l, rt_elem el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_rt_elem_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to rt_alt_list */
rt_alt_list append_rt_alt_list (rt_alt_list l, rt_alt el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_rt_alt_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to rt_type_list */
rt_type_list append_rt_type_list (rt_type_list l, rt_type el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_rt_type_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to cset_part_list */
cset_part_list append_cset_part_list (cset_part_list l, cset_part el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_cset_part_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to cset_list */
cset_list append_cset_list (cset_list l, cset el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_cset_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to terminal_list */
terminal_list append_terminal_list (terminal_list l, terminal el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_terminal_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to nfa_state_list */
nfa_state_list append_nfa_state_list (nfa_state_list l, nfa_state el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_nfa_state_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to nfa_trans_list */
nfa_trans_list append_nfa_trans_list (nfa_trans_list l, nfa_trans el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_nfa_trans_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to nfa_list */
nfa_list append_nfa_list (nfa_list l, nfa el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_nfa_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to lex_nont_list */
lex_nont_list append_lex_nont_list (lex_nont_list l, lex_nont el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_lex_nont_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to rt_nont_list */
rt_nont_list append_rt_nont_list (rt_nont_list l, rt_nont el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_rt_nont_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to ext_nont_list */
ext_nont_list append_ext_nont_list (ext_nont_list l, ext_nont el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_ext_nont_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to trans_pair_list */
trans_pair_list append_trans_pair_list (trans_pair_list l, trans_pair el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_trans_pair_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to int_list_list */
int_list_list append_int_list_list (int_list_list l, int_list el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_int_list_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to u_int64_list */
u_int64_list append_u_int64_list (u_int64_list l, u_int64 el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_u_int64_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Concatenate two affix_value_lists */
affix_value_list concat_affix_value_list (affix_value_list l1, affix_value_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_affix_value_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two rt_element_lists */
rt_element_list concat_rt_element_list (rt_element_list l1, rt_element_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_rt_element_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two rt_domain_lists */
rt_domain_list concat_rt_domain_list (rt_domain_list l1, rt_domain_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_rt_domain_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two rt_elem_lists */
rt_elem_list concat_rt_elem_list (rt_elem_list l1, rt_elem_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_rt_elem_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two rt_alt_lists */
rt_alt_list concat_rt_alt_list (rt_alt_list l1, rt_alt_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_rt_alt_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two rt_type_lists */
rt_type_list concat_rt_type_list (rt_type_list l1, rt_type_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_rt_type_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two cset_part_lists */
cset_part_list concat_cset_part_list (cset_part_list l1, cset_part_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_cset_part_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two cset_lists */
cset_list concat_cset_list (cset_list l1, cset_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_cset_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two terminal_lists */
terminal_list concat_terminal_list (terminal_list l1, terminal_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_terminal_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two nfa_state_lists */
nfa_state_list concat_nfa_state_list (nfa_state_list l1, nfa_state_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_nfa_state_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two nfa_trans_lists */
nfa_trans_list concat_nfa_trans_list (nfa_trans_list l1, nfa_trans_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_nfa_trans_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two nfa_lists */
nfa_list concat_nfa_list (nfa_list l1, nfa_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_nfa_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two lex_nont_lists */
lex_nont_list concat_lex_nont_list (lex_nont_list l1, lex_nont_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_lex_nont_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two rt_nont_lists */
rt_nont_list concat_rt_nont_list (rt_nont_list l1, rt_nont_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_rt_nont_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two ext_nont_lists */
ext_nont_list concat_ext_nont_list (ext_nont_list l1, ext_nont_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_ext_nont_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two trans_pair_lists */
trans_pair_list concat_trans_pair_list (trans_pair_list l1, trans_pair_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_trans_pair_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two int_list_lists */
int_list_list concat_int_list_list (int_list_list l1, int_list_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_int_list_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two u_int64_lists */
u_int64_list concat_u_int64_list (u_int64_list l1, u_int64_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_u_int64_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Insert element into affix_value_list at pos 'pos' */
affix_value_list insert_affix_value_list (affix_value_list l, int pos, affix_value el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_affix_value_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_affix_value_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into rt_element_list at pos 'pos' */
rt_element_list insert_rt_element_list (rt_element_list l, int pos, rt_element el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_rt_element_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_rt_element_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into rt_domain_list at pos 'pos' */
rt_domain_list insert_rt_domain_list (rt_domain_list l, int pos, rt_domain el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_rt_domain_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_rt_domain_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into rt_elem_list at pos 'pos' */
rt_elem_list insert_rt_elem_list (rt_elem_list l, int pos, rt_elem el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_rt_elem_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_rt_elem_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into rt_alt_list at pos 'pos' */
rt_alt_list insert_rt_alt_list (rt_alt_list l, int pos, rt_alt el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_rt_alt_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_rt_alt_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into rt_type_list at pos 'pos' */
rt_type_list insert_rt_type_list (rt_type_list l, int pos, rt_type el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_rt_type_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_rt_type_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into cset_part_list at pos 'pos' */
cset_part_list insert_cset_part_list (cset_part_list l, int pos, cset_part el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_cset_part_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_cset_part_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into cset_list at pos 'pos' */
cset_list insert_cset_list (cset_list l, int pos, cset el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_cset_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_cset_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into terminal_list at pos 'pos' */
terminal_list insert_terminal_list (terminal_list l, int pos, terminal el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_terminal_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_terminal_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into nfa_state_list at pos 'pos' */
nfa_state_list insert_nfa_state_list (nfa_state_list l, int pos, nfa_state el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_nfa_state_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_nfa_state_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into nfa_trans_list at pos 'pos' */
nfa_trans_list insert_nfa_trans_list (nfa_trans_list l, int pos, nfa_trans el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_nfa_trans_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_nfa_trans_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into nfa_list at pos 'pos' */
nfa_list insert_nfa_list (nfa_list l, int pos, nfa el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_nfa_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_nfa_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into lex_nont_list at pos 'pos' */
lex_nont_list insert_lex_nont_list (lex_nont_list l, int pos, lex_nont el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_lex_nont_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_lex_nont_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into rt_nont_list at pos 'pos' */
rt_nont_list insert_rt_nont_list (rt_nont_list l, int pos, rt_nont el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_rt_nont_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_rt_nont_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into ext_nont_list at pos 'pos' */
ext_nont_list insert_ext_nont_list (ext_nont_list l, int pos, ext_nont el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_ext_nont_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_ext_nont_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into trans_pair_list at pos 'pos' */
trans_pair_list insert_trans_pair_list (trans_pair_list l, int pos, trans_pair el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_trans_pair_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_trans_pair_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into int_list_list at pos 'pos' */
int_list_list insert_int_list_list (int_list_list l, int pos, int_list el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_int_list_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_int_list_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into u_int64_list at pos 'pos' */
u_int64_list insert_u_int64_list (u_int64_list l, int pos, u_int64 el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_u_int64_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_u_int64_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Delete element from affix_value_list at pos 'pos' */
affix_value_list delete_affix_value_list (affix_value_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_affix_value_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from rt_element_list at pos 'pos' */
rt_element_list delete_rt_element_list (rt_element_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_rt_element_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from rt_domain_list at pos 'pos' */
rt_domain_list delete_rt_domain_list (rt_domain_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_rt_domain_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from rt_elem_list at pos 'pos' */
rt_elem_list delete_rt_elem_list (rt_elem_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_rt_elem_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from rt_alt_list at pos 'pos' */
rt_alt_list delete_rt_alt_list (rt_alt_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_rt_alt_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from rt_type_list at pos 'pos' */
rt_type_list delete_rt_type_list (rt_type_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_rt_type_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from cset_part_list at pos 'pos' */
cset_part_list delete_cset_part_list (cset_part_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_cset_part_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from cset_list at pos 'pos' */
cset_list delete_cset_list (cset_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_cset_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from terminal_list at pos 'pos' */
terminal_list delete_terminal_list (terminal_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_terminal_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from nfa_state_list at pos 'pos' */
nfa_state_list delete_nfa_state_list (nfa_state_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_nfa_state_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from nfa_trans_list at pos 'pos' */
nfa_trans_list delete_nfa_trans_list (nfa_trans_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_nfa_trans_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from nfa_list at pos 'pos' */
nfa_list delete_nfa_list (nfa_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_nfa_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from lex_nont_list at pos 'pos' */
lex_nont_list delete_lex_nont_list (lex_nont_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_lex_nont_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from rt_nont_list at pos 'pos' */
rt_nont_list delete_rt_nont_list (rt_nont_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_rt_nont_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from ext_nont_list at pos 'pos' */
ext_nont_list delete_ext_nont_list (ext_nont_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_ext_nont_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from trans_pair_list at pos 'pos' */
trans_pair_list delete_trans_pair_list (trans_pair_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_trans_pair_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from int_list_list at pos 'pos' */
int_list_list delete_int_list_list (int_list_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_int_list_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from u_int64_list at pos 'pos' */
u_int64_list delete_u_int64_list (u_int64_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_u_int64_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Comparison test for a affix_value */
int cmp_affix_value (affix_value a, affix_value b)
{ int s;
  if (a == b) return (0);
  if (a == affix_value_nil) return (-1);
  if (b == affix_value_nil) return (1);
  if ((s = cmp_int (a -> rule_nr, b -> rule_nr))) return (s);
  if ((s = cmp_int ((int)(a -> tag), (int)(b -> tag)))) return (s);
  switch (a -> tag)
    { case TAGNull_value:
	break;
      case TAGText_value:
	if ((s = cmp_string (a -> Text_value.text, b -> Text_value.text))) return (s);
	break;
      case TAGInt_value:
	if ((s = cmp_int (a -> Int_value.ival, b -> Int_value.ival))) return (s);
	break;
      case TAGReal_value:
	if ((s = cmp_real (a -> Real_value.rval, b -> Real_value.rval))) return (s);
	break;
      case TAGSmall_lattice:
	if ((s = cmp_int (a -> Small_lattice.dom, b -> Small_lattice.dom))) return (s);
	if ((s = cmp_u_int64 (a -> Small_lattice.slat, b -> Small_lattice.slat))) return (s);
	break;
      case TAGLarge_lattice:
	if ((s = cmp_int (a -> Large_lattice.dom, b -> Large_lattice.dom))) return (s);
	if ((s = cmp_u_int64_list (a -> Large_lattice.llat, b -> Large_lattice.llat))) return (s);
	break;
      case TAGList_lattice:
	if ((s = cmp_int_list (a -> List_lattice.llat, b -> List_lattice.llat))) return (s);
	break;
      case TAGComposed_value:
	if ((s = cmp_int (a -> Composed_value.marker, b -> Composed_value.marker))) return (s);
	if ((s = cmp_affix_value_list (a -> Composed_value.parts, b -> Composed_value.parts))) return (s);
	break;
      default:
	dcg_bad_tag (a -> tag, "cmp_affix_value");
    };
  return (0);
}

/* Comparison test for a rt_element */
int cmp_rt_element (rt_element a, rt_element b)
{ int s;
  if (a == b) return (0);
  if (a == rt_element_nil) return (-1);
  if (b == rt_element_nil) return (1);
  if ((s = cmp_string (a -> name, b -> name))) return (s);
  if ((s = cmp_affix_value (a -> value, b -> value))) return (s);
  return (0);
}

/* Comparison test for a rt_domain */
int cmp_rt_domain (rt_domain a, rt_domain b)
{ int s;
  if (a == b) return (0);
  if (a == rt_domain_nil) return (-1);
  if (b == rt_domain_nil) return (1);
  if ((s = cmp_int (a -> width, b -> width))) return (s);
  if ((s = cmp_rt_element_list (a -> elts, b -> elts))) return (s);
  return (0);
}

/* Comparison test for a rt_elem */
int cmp_rt_elem (rt_elem a, rt_elem b)
{ int s;
  if (a == b) return (0);
  if (a == rt_elem_nil) return (-1);
  if (b == rt_elem_nil) return (1);
  if ((s = cmp_int ((int)(a -> tag), (int)(b -> tag)))) return (s);
  switch (a -> tag)
    { case TAGMarker:
	if ((s = cmp_string (a -> Marker.txt, b -> Marker.txt))) return (s);
	break;
      case TAGRef:
	if ((s = cmp_int (a -> Ref.rnr, b -> Ref.rnr))) return (s);
	break;
      default:
	dcg_bad_tag (a -> tag, "cmp_rt_elem");
    };
  return (0);
}

/* Comparison test for a rt_alt */
int cmp_rt_alt (rt_alt a, rt_alt b)
{ int s;
  if (a == b) return (0);
  if (a == rt_alt_nil) return (-1);
  if (b == rt_alt_nil) return (1);
  if ((s = cmp_int (a -> marker, b -> marker))) return (s);
  if ((s = cmp_rt_elem_list (a -> elems, b -> elems))) return (s);
  return (0);
}

/* Comparison test for a rt_type */
int cmp_rt_type (rt_type a, rt_type b)
{ int s;
  if (a == b) return (0);
  if (a == rt_type_nil) return (-1);
  if (b == rt_type_nil) return (1);
  if ((s = cmp_int (a -> rule_nr, b -> rule_nr))) return (s);
  if ((s = cmp_string (a -> name, b -> name))) return (s);
  if ((s = cmp_int (a -> lexgen, b -> lexgen))) return (s);
  if ((s = cmp_affix_value (a -> value, b -> value))) return (s);
  if ((s = cmp_int ((int)(a -> tag), (int)(b -> tag)))) return (s);
  switch (a -> tag)
    { case TAGSynonym_type:
	if ((s = cmp_int (a -> Synonym_type.snr, b -> Synonym_type.snr))) return (s);
	break;
      case TAGAny_type:
	break;
      case TAGInt_type:
	break;
      case TAGReal_type:
	break;
      case TAGText_type:
	break;
      case TAGLattice_type:
	if ((s = cmp_int (a -> Lattice_type.dom, b -> Lattice_type.dom))) return (s);
	break;
      case TAGTree_type:
	if ((s = cmp_rt_alt_list (a -> Tree_type.alts, b -> Tree_type.alts))) return (s);
	break;
      default:
	dcg_bad_tag (a -> tag, "cmp_rt_type");
    };
  return (0);
}

/* Comparison test for a cset_part */
int cmp_cset_part (cset_part a, cset_part b)
{ int s;
  if (a == b) return (0);
  if (a == cset_part_nil) return (-1);
  if (b == cset_part_nil) return (1);
  if ((s = cmp_int ((int)(a -> tag), (int)(b -> tag)))) return (s);
  switch (a -> tag)
    { case TAGPart_match:
	if ((s = cmp_int (a -> Part_match.ch, b -> Part_match.ch))) return (s);
	break;
      case TAGPart_range:
	if ((s = cmp_int (a -> Part_range.first, b -> Part_range.first))) return (s);
	if ((s = cmp_int (a -> Part_range.last, b -> Part_range.last))) return (s);
	break;
      default:
	dcg_bad_tag (a -> tag, "cmp_cset_part");
    };
  return (0);
}

/* Comparison test for a cset */
int cmp_cset (cset a, cset b)
{ int s;
  if (a == b) return (0);
  if (a == cset_nil) return (-1);
  if (b == cset_nil) return (1);
  if ((s = cmp_int (a -> invert, b -> invert))) return (s);
  if ((s = cmp_cset_part_list (a -> parts, b -> parts))) return (s);
  return (0);
}

/* Comparison test for a terminal */
int cmp_terminal (terminal a, terminal b)
{ int s;
  if (a == b) return (0);
  if (a == terminal_nil) return (-1);
  if (b == terminal_nil) return (1);
  if ((s = cmp_int (a -> marker, b -> marker))) return (s);
  if ((s = cmp_int_list (a -> text, b -> text))) return (s);
  if ((s = cmp_string (a -> origin, b -> origin))) return (s);
  return (0);
}

/* Comparison test for a nfa_state */
int cmp_nfa_state (nfa_state a, nfa_state b)
{ int s;
  if (a == b) return (0);
  if (a == nfa_state_nil) return (-1);
  if (b == nfa_state_nil) return (1);
  if ((s = cmp_int (a -> self, b -> self))) return (s);
  if ((s = cmp_int (a -> final, b -> final))) return (s);
  if ((s = cmp_nfa_trans_list (a -> transitions, b -> transitions))) return (s);
  return (0);
}

/* Comparison test for a nfa_trans */
int cmp_nfa_trans (nfa_trans a, nfa_trans b)
{ int s;
  if (a == b) return (0);
  if (a == nfa_trans_nil) return (-1);
  if (b == nfa_trans_nil) return (1);
  if ((s = cmp_int (a -> dest, b -> dest))) return (s);
  if ((s = cmp_int ((int)(a -> tag), (int)(b -> tag)))) return (s);
  switch (a -> tag)
    { case TAGTrans_char:
	if ((s = cmp_int (a -> Trans_char.ch, b -> Trans_char.ch))) return (s);
	break;
      case TAGTrans_cset:
	if ((s = cmp_int (a -> Trans_cset.cs, b -> Trans_cset.cs))) return (s);
	break;
      case TAGTrans_anychar:
	break;
      case TAGTrans_whitespace:
	break;
      case TAGTrans_nonwhitespace:
	break;
      case TAGTrans_empty:
	break;
      default:
	dcg_bad_tag (a -> tag, "cmp_nfa_trans");
    };
  return (0);
}

/* Comparison test for a nfa */
int cmp_nfa (nfa a, nfa b)
{ int s;
  if (a == b) return (0);
  if (a == nfa_nil) return (-1);
  if (b == nfa_nil) return (1);
  if ((s = cmp_int (a -> kind, b -> kind))) return (s);
  if ((s = cmp_int (a -> marker, b -> marker))) return (s);
  if ((s = cmp_string (a -> origin, b -> origin))) return (s);
  if ((s = cmp_nfa_state_list (a -> states, b -> states))) return (s);
  return (0);
}

/* Comparison test for a lex_nont */
int cmp_lex_nont (lex_nont a, lex_nont b)
{ int s;
  if (a == b) return (0);
  if (a == lex_nont_nil) return (-1);
  if (b == lex_nont_nil) return (1);
  if ((s = cmp_int (a -> rule_nr, b -> rule_nr))) return (s);
  if ((s = cmp_int (a -> fact_nr, b -> fact_nr))) return (s);
  if ((s = cmp_string_list (a -> name_parts, b -> name_parts))) return (s);
  if ((s = cmp_int_list (a -> name_chars, b -> name_chars))) return (s);
  if ((s = cmp_int (a -> ncrits, b -> ncrits))) return (s);
  if ((s = cmp_int_list (a -> formals, b -> formals))) return (s);
  if ((s = cmp_int_list (a -> crits, b -> crits))) return (s);
  return (0);
}

/* Comparison test for a rt_nont */
int cmp_rt_nont (rt_nont a, rt_nont b)
{ int s;
  if (a == b) return (0);
  if (a == rt_nont_nil) return (-1);
  if (b == rt_nont_nil) return (1);
  if ((s = cmp_string_list (a -> name_parts, b -> name_parts))) return (s);
  if ((s = cmp_int_list (a -> name_chars, b -> name_chars))) return (s);
  if ((s = cmp_string (a -> canonic_name, b -> canonic_name))) return (s);
  if ((s = cmp_int_list (a -> formals, b -> formals))) return (s);
  if ((s = cmp_int (a -> lex_nr, b -> lex_nr))) return (s);
  return (0);
}

/* Comparison test for a ext_nont */
int cmp_ext_nont (ext_nont a, ext_nont b)
{ int s;
  if (a == b) return (0);
  if (a == ext_nont_nil) return (-1);
  if (b == ext_nont_nil) return (1);
  if ((s = cmp_string (a -> canonic_name, b -> canonic_name))) return (s);
  if ((s = cmp_int (a -> rule_nr, b -> rule_nr))) return (s);
  return (0);
}

/* Comparison test for a director_set */
int cmp_director_set (director_set a, director_set b)
{ int s;
  if (a == b) return (0);
  if (a == director_set_nil) return (-1);
  if (b == director_set_nil) return (1);
  if ((s = cmp_int (a -> min_phase, b -> min_phase))) return (s);
  if ((s = cmp_trans_pair_list (a -> set, b -> set))) return (s);
  return (0);
}

/* Comparison test for a trans_pair */
int cmp_trans_pair (trans_pair a, trans_pair b)
{ int s;
  if (a == b) return (0);
  if (a == trans_pair_nil) return (-1);
  if (b == trans_pair_nil) return (1);
  if ((s = cmp_int (a -> class, b -> class))) return (s);
  if ((s = cmp_int (a -> number, b -> number))) return (s);
  return (0);
}

/* Comparison test for a affix_value_list */
int cmp_affix_value_list (affix_value_list a, affix_value_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == affix_value_list_nil) return (-1);
  if (b == affix_value_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_affix_value (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a rt_element_list */
int cmp_rt_element_list (rt_element_list a, rt_element_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == rt_element_list_nil) return (-1);
  if (b == rt_element_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_rt_element (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a rt_domain_list */
int cmp_rt_domain_list (rt_domain_list a, rt_domain_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == rt_domain_list_nil) return (-1);
  if (b == rt_domain_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_rt_domain (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a rt_elem_list */
int cmp_rt_elem_list (rt_elem_list a, rt_elem_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == rt_elem_list_nil) return (-1);
  if (b == rt_elem_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_rt_elem (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a rt_alt_list */
int cmp_rt_alt_list (rt_alt_list a, rt_alt_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == rt_alt_list_nil) return (-1);
  if (b == rt_alt_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_rt_alt (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a rt_type_list */
int cmp_rt_type_list (rt_type_list a, rt_type_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == rt_type_list_nil) return (-1);
  if (b == rt_type_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_rt_type (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a cset_part_list */
int cmp_cset_part_list (cset_part_list a, cset_part_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == cset_part_list_nil) return (-1);
  if (b == cset_part_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_cset_part (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a cset_list */
int cmp_cset_list (cset_list a, cset_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == cset_list_nil) return (-1);
  if (b == cset_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_cset (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a terminal_list */
int cmp_terminal_list (terminal_list a, terminal_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == terminal_list_nil) return (-1);
  if (b == terminal_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_terminal (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a nfa_state_list */
int cmp_nfa_state_list (nfa_state_list a, nfa_state_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == nfa_state_list_nil) return (-1);
  if (b == nfa_state_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_nfa_state (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a nfa_trans_list */
int cmp_nfa_trans_list (nfa_trans_list a, nfa_trans_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == nfa_trans_list_nil) return (-1);
  if (b == nfa_trans_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_nfa_trans (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a nfa_list */
int cmp_nfa_list (nfa_list a, nfa_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == nfa_list_nil) return (-1);
  if (b == nfa_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_nfa (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a lex_nont_list */
int cmp_lex_nont_list (lex_nont_list a, lex_nont_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == lex_nont_list_nil) return (-1);
  if (b == lex_nont_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_lex_nont (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a rt_nont_list */
int cmp_rt_nont_list (rt_nont_list a, rt_nont_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == rt_nont_list_nil) return (-1);
  if (b == rt_nont_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_rt_nont (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a ext_nont_list */
int cmp_ext_nont_list (ext_nont_list a, ext_nont_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == ext_nont_list_nil) return (-1);
  if (b == ext_nont_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_ext_nont (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a trans_pair_list */
int cmp_trans_pair_list (trans_pair_list a, trans_pair_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == trans_pair_list_nil) return (-1);
  if (b == trans_pair_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_trans_pair (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a int_list_list */
int cmp_int_list_list (int_list_list a, int_list_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == int_list_list_nil) return (-1);
  if (b == int_list_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_int_list (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a u_int64_list */
int cmp_u_int64_list (u_int64_list a, u_int64_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == u_int64_list_nil) return (-1);
  if (b == u_int64_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_u_int64 (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Estimate printing a affix_value */
int est_affix_value (affix_value old)
{ int size = 0;
  if (old == affix_value_nil) return (2);
  size += est_int (old -> rule_nr) + 2;
  switch (old -> tag)
    { case TAGNull_value:
	size += 12;
	break;
      case TAGText_value:
	size += 12;
	size += est_string (old -> Text_value.text) + 2;
	break;
      case TAGInt_value:
	size += 11;
	size += est_int (old -> Int_value.ival) + 2;
	break;
      case TAGReal_value:
	size += 12;
	size += est_real (old -> Real_value.rval) + 2;
	break;
      case TAGSmall_lattice:
	size += 15;
	size += est_int (old -> Small_lattice.dom) + 2;
	size += est_u_int64 (old -> Small_lattice.slat) + 2;
	break;
      case TAGLarge_lattice:
	size += 15;
	size += est_int (old -> Large_lattice.dom) + 2;
	size += est_u_int64_list (old -> Large_lattice.llat) + 2;
	break;
      case TAGList_lattice:
	size += 14;
	size += est_int_list (old -> List_lattice.llat) + 2;
	break;
      case TAGComposed_value:
	size += 16;
	size += est_int (old -> Composed_value.marker) + 2;
	size += est_affix_value_list (old -> Composed_value.parts) + 2;
	break;
      default:
	dcg_bad_tag (old -> tag, "est_affix_value");
    };
  return (size + 2);
}

/* Estimate printing a rt_element */
int est_rt_element (rt_element old)
{ int size = 0;
  if (old == rt_element_nil) return (2);
  size += est_string (old -> name) + 2;
  size += est_affix_value (old -> value) + 2;
  return (size + 2);
}

/* Estimate printing a rt_domain */
int est_rt_domain (rt_domain old)
{ int size = 0;
  if (old == rt_domain_nil) return (2);
  size += est_int (old -> width) + 2;
  size += est_rt_element_list (old -> elts) + 2;
  return (size + 2);
}

/* Estimate printing a rt_elem */
int est_rt_elem (rt_elem old)
{ int size = 0;
  if (old == rt_elem_nil) return (2);
  switch (old -> tag)
    { case TAGMarker:
	size += 8;
	size += est_string (old -> Marker.txt) + 2;
	break;
      case TAGRef:
	size += 5;
	size += est_int (old -> Ref.rnr) + 2;
	break;
      default:
	dcg_bad_tag (old -> tag, "est_rt_elem");
    };
  return (size + 2);
}

/* Estimate printing a rt_alt */
int est_rt_alt (rt_alt old)
{ int size = 0;
  if (old == rt_alt_nil) return (2);
  size += est_int (old -> marker) + 2;
  size += est_rt_elem_list (old -> elems) + 2;
  return (size + 2);
}

/* Estimate printing a rt_type */
int est_rt_type (rt_type old)
{ int size = 0;
  if (old == rt_type_nil) return (2);
  size += est_int (old -> rule_nr) + 2;
  size += est_string (old -> name) + 2;
  size += est_int (old -> lexgen) + 2;
  size += est_affix_value (old -> value) + 2;
  size += PTRWIDTH;
  size += PTRWIDTH;
  size += PTRWIDTH;
  switch (old -> tag)
    { case TAGSynonym_type:
	size += 14;
	size += est_int (old -> Synonym_type.snr) + 2;
	break;
      case TAGAny_type:
	size += 10;
	break;
      case TAGInt_type:
	size += 10;
	break;
      case TAGReal_type:
	size += 11;
	break;
      case TAGText_type:
	size += 11;
	break;
      case TAGLattice_type:
	size += 14;
	size += est_int (old -> Lattice_type.dom) + 2;
	break;
      case TAGTree_type:
	size += 11;
	size += est_rt_alt_list (old -> Tree_type.alts) + 2;
	break;
      default:
	dcg_bad_tag (old -> tag, "est_rt_type");
    };
  return (size + 2);
}

/* Estimate printing a cset_part */
int est_cset_part (cset_part old)
{ int size = 0;
  if (old == cset_part_nil) return (2);
  switch (old -> tag)
    { case TAGPart_match:
	size += 12;
	size += est_int (old -> Part_match.ch) + 2;
	break;
      case TAGPart_range:
	size += 12;
	size += est_int (old -> Part_range.first) + 2;
	size += est_int (old -> Part_range.last) + 2;
	break;
      default:
	dcg_bad_tag (old -> tag, "est_cset_part");
    };
  return (size + 2);
}

/* Estimate printing a cset */
int est_cset (cset old)
{ int size = 0;
  if (old == cset_nil) return (2);
  size += est_int (old -> invert) + 2;
  size += est_cset_part_list (old -> parts) + 2;
  return (size + 2);
}

/* Estimate printing a terminal */
int est_terminal (terminal old)
{ int size = 0;
  if (old == terminal_nil) return (2);
  size += est_int (old -> marker) + 2;
  size += est_int_list (old -> text) + 2;
  size += est_string (old -> origin) + 2;
  return (size + 2);
}

/* Estimate printing a nfa_state */
int est_nfa_state (nfa_state old)
{ int size = 0;
  if (old == nfa_state_nil) return (2);
  size += est_int (old -> self) + 2;
  size += est_int (old -> final) + 2;
  size += est_nfa_trans_list (old -> transitions) + 2;
  size += PTRWIDTH;
  return (size + 2);
}

/* Estimate printing a nfa_trans */
int est_nfa_trans (nfa_trans old)
{ int size = 0;
  if (old == nfa_trans_nil) return (2);
  size += est_int (old -> dest) + 2;
  switch (old -> tag)
    { case TAGTrans_char:
	size += 12;
	size += est_int (old -> Trans_char.ch) + 2;
	break;
      case TAGTrans_cset:
	size += 12;
	size += est_int (old -> Trans_cset.cs) + 2;
	break;
      case TAGTrans_anychar:
	size += 15;
	break;
      case TAGTrans_whitespace:
	size += 18;
	break;
      case TAGTrans_nonwhitespace:
	size += 21;
	break;
      case TAGTrans_empty:
	size += 13;
	break;
      default:
	dcg_bad_tag (old -> tag, "est_nfa_trans");
    };
  return (size + 2);
}

/* Estimate printing a nfa */
int est_nfa (nfa old)
{ int size = 0;
  if (old == nfa_nil) return (2);
  size += est_int (old -> kind) + 2;
  size += est_int (old -> marker) + 2;
  size += est_string (old -> origin) + 2;
  size += est_nfa_state_list (old -> states) + 2;
  return (size + 2);
}

/* Estimate printing a lex_nont */
int est_lex_nont (lex_nont old)
{ int size = 0;
  if (old == lex_nont_nil) return (2);
  size += est_int (old -> rule_nr) + 2;
  size += est_int (old -> fact_nr) + 2;
  size += est_string_list (old -> name_parts) + 2;
  size += est_int_list (old -> name_chars) + 2;
  size += est_int (old -> ncrits) + 2;
  size += est_int_list (old -> formals) + 2;
  size += est_int_list (old -> crits) + 2;
  return (size + 2);
}

/* Estimate printing a rt_nont */
int est_rt_nont (rt_nont old)
{ int size = 0;
  if (old == rt_nont_nil) return (2);
  size += est_string_list (old -> name_parts) + 2;
  size += est_int_list (old -> name_chars) + 2;
  size += est_string (old -> canonic_name) + 2;
  size += est_int_list (old -> formals) + 2;
  size += est_int (old -> lex_nr) + 2;
  return (size + 2);
}

/* Estimate printing a ext_nont */
int est_ext_nont (ext_nont old)
{ int size = 0;
  if (old == ext_nont_nil) return (2);
  size += est_string (old -> canonic_name) + 2;
  size += est_int (old -> rule_nr) + 2;
  return (size + 2);
}

/* Estimate a tree_kind */
int est_tree_kind (tree_kind old)
{ switch (old)
    { case normal_node: return (11);
      case simple_node: return (11);
      case anonymous_node: return (14);
      case leaf_node: return (9);
      case lex_nont_node: return (13);
      case predicate_node: return (14);
      case confrontation_node: return (18);
      case penalty_node: return (12);
      case quasi_node: return (10);
      default:
	dcg_bad_tag (old, "est_tree_kind");
    };
  return (0);
}

/* Estimate a affix_expr_kind */
int est_affix_expr_kind (affix_expr_kind old)
{ switch (old)
    { case single_affix_node: return (17);
      case ast_node: return (8);
      case concat_node: return (11);
      case dyop_arith_node: return (15);
      case monop_arith_node: return (16);
      default:
	dcg_bad_tag (old, "est_affix_expr_kind");
    };
  return (0);
}

/* Estimate a propagation_kind */
int est_propagation_kind (propagation_kind old)
{ switch (old)
    { case p_bidirectional: return (15);
      case p_left_to_right: return (15);
      case p_lower_to_upper: return (16);
      case p_equal: return (7);
      case p_unequal: return (9);
      case p_restrict: return (10);
      default:
	dcg_bad_tag (old, "est_propagation_kind");
    };
  return (0);
}

/* Estimate a operator */
int est_operator (operator old)
{ switch (old)
    { case times: return (5);
      case modulo: return (6);
      case divides: return (7);
      case plus: return (4);
      case minus: return (5);
      case a_union: return (7);
      case a_part: return (6);
      case shift_left: return (10);
      case shift_right: return (11);
      case bitwise_xor: return (11);
      case bitwise_not: return (11);
      case bitwise_or: return (10);
      case bitwise_and: return (11);
      case int_times_int: return (13);
      case real_times_real: return (15);
      case int_times_text: return (14);
      case int_plus_int: return (12);
      case real_plus_real: return (14);
      case text_plus_text: return (14);
      case int_minus_int: return (13);
      case real_minus_real: return (15);
      default:
	dcg_bad_tag (old, "est_operator");
    };
  return (0);
}

/* Estimate printing a director_set */
int est_director_set (director_set old)
{ int size = 0;
  if (old == director_set_nil) return (2);
  size += est_int (old -> min_phase) + 2;
  size += est_trans_pair_list (old -> set) + 2;
  return (size + 2);
}

/* Estimate printing a trans_pair */
int est_trans_pair (trans_pair old)
{ int size = 0;
  if (old == trans_pair_nil) return (2);
  size += est_int (old -> class) + 2;
  size += est_int (old -> number) + 2;
  return (size + 2);
}

/* Estimate printing a affix_value_list */
int est_affix_value_list (affix_value_list old)
{ int ix;
  int size = 0;
  if (old == affix_value_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_affix_value (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a rt_element_list */
int est_rt_element_list (rt_element_list old)
{ int ix;
  int size = 0;
  if (old == rt_element_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_rt_element (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a rt_domain_list */
int est_rt_domain_list (rt_domain_list old)
{ int ix;
  int size = 0;
  if (old == rt_domain_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_rt_domain (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a rt_elem_list */
int est_rt_elem_list (rt_elem_list old)
{ int ix;
  int size = 0;
  if (old == rt_elem_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_rt_elem (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a rt_alt_list */
int est_rt_alt_list (rt_alt_list old)
{ int ix;
  int size = 0;
  if (old == rt_alt_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_rt_alt (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a rt_type_list */
int est_rt_type_list (rt_type_list old)
{ int ix;
  int size = 0;
  if (old == rt_type_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_rt_type (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a cset_part_list */
int est_cset_part_list (cset_part_list old)
{ int ix;
  int size = 0;
  if (old == cset_part_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_cset_part (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a cset_list */
int est_cset_list (cset_list old)
{ int ix;
  int size = 0;
  if (old == cset_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_cset (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a terminal_list */
int est_terminal_list (terminal_list old)
{ int ix;
  int size = 0;
  if (old == terminal_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_terminal (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a nfa_state_list */
int est_nfa_state_list (nfa_state_list old)
{ int ix;
  int size = 0;
  if (old == nfa_state_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_nfa_state (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a nfa_trans_list */
int est_nfa_trans_list (nfa_trans_list old)
{ int ix;
  int size = 0;
  if (old == nfa_trans_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_nfa_trans (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a nfa_list */
int est_nfa_list (nfa_list old)
{ int ix;
  int size = 0;
  if (old == nfa_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_nfa (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a lex_nont_list */
int est_lex_nont_list (lex_nont_list old)
{ int ix;
  int size = 0;
  if (old == lex_nont_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_lex_nont (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a rt_nont_list */
int est_rt_nont_list (rt_nont_list old)
{ int ix;
  int size = 0;
  if (old == rt_nont_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_rt_nont (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a ext_nont_list */
int est_ext_nont_list (ext_nont_list old)
{ int ix;
  int size = 0;
  if (old == ext_nont_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_ext_nont (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a trans_pair_list */
int est_trans_pair_list (trans_pair_list old)
{ int ix;
  int size = 0;
  if (old == trans_pair_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_trans_pair (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a int_list_list */
int est_int_list_list (int_list_list old)
{ int ix;
  int size = 0;
  if (old == int_list_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_int_list (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a u_int64_list */
int est_u_int64_list (u_int64_list old)
{ int ix;
  int size = 0;
  if (old == u_int64_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_u_int64 (old -> array[ix]) + 2;
  return (size + 2);
}

/* Pretty print a affix_value */
void ppp_affix_value (FILE *f, int horiz, int ind, affix_value old)
{ int mhoriz;
  if (old == affix_value_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_affix_value (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_int (f, mhoriz, ind + 2, old -> rule_nr);
  pppdelim (f, mhoriz, ind, ',');
  switch (old -> tag)
    { case TAGNull_value:
	pppstring (f, "Null_value");
	break;
      case TAGText_value:
	pppstring (f, "Text_value");
	pppdelim (f, mhoriz, ind, ',');
	ppp_string (f, mhoriz, ind + 2, old -> Text_value.text);
	break;
      case TAGInt_value:
	pppstring (f, "Int_value");
	pppdelim (f, mhoriz, ind, ',');
	ppp_int (f, mhoriz, ind + 2, old -> Int_value.ival);
	break;
      case TAGReal_value:
	pppstring (f, "Real_value");
	pppdelim (f, mhoriz, ind, ',');
	ppp_real (f, mhoriz, ind + 2, old -> Real_value.rval);
	break;
      case TAGSmall_lattice:
	pppstring (f, "Small_lattice");
	pppdelim (f, mhoriz, ind, ',');
	ppp_int (f, mhoriz, ind + 2, old -> Small_lattice.dom);
	pppdelim (f, mhoriz, ind, ',');
	ppp_u_int64 (f, mhoriz, ind + 2, old -> Small_lattice.slat);
	break;
      case TAGLarge_lattice:
	pppstring (f, "Large_lattice");
	pppdelim (f, mhoriz, ind, ',');
	ppp_int (f, mhoriz, ind + 2, old -> Large_lattice.dom);
	pppdelim (f, mhoriz, ind, ',');
	ppp_u_int64_list (f, mhoriz, ind + 2, old -> Large_lattice.llat);
	break;
      case TAGList_lattice:
	pppstring (f, "List_lattice");
	pppdelim (f, mhoriz, ind, ',');
	ppp_int_list (f, mhoriz, ind + 2, old -> List_lattice.llat);
	break;
      case TAGComposed_value:
	pppstring (f, "Composed_value");
	pppdelim (f, mhoriz, ind, ',');
	ppp_int (f, mhoriz, ind + 2, old -> Composed_value.marker);
	pppdelim (f, mhoriz, ind, ',');
	ppp_affix_value_list (f, mhoriz, ind + 2, old -> Composed_value.parts);
	break;
      default:
	dcg_bad_tag (old -> tag, "ppp_affix_value");
    };
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a rt_element */
void ppp_rt_element (FILE *f, int horiz, int ind, rt_element old)
{ int mhoriz;
  if (old == rt_element_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_rt_element (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_string (f, mhoriz, ind + 2, old -> name);
  pppdelim (f, mhoriz, ind, ',');
  ppp_affix_value (f, mhoriz, ind + 2, old -> value);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a rt_domain */
void ppp_rt_domain (FILE *f, int horiz, int ind, rt_domain old)
{ int mhoriz;
  if (old == rt_domain_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_rt_domain (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_int (f, mhoriz, ind + 2, old -> width);
  pppdelim (f, mhoriz, ind, ',');
  ppp_rt_element_list (f, mhoriz, ind + 2, old -> elts);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a rt_elem */
void ppp_rt_elem (FILE *f, int horiz, int ind, rt_elem old)
{ int mhoriz;
  if (old == rt_elem_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_rt_elem (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  switch (old -> tag)
    { case TAGMarker:
	pppstring (f, "Marker");
	pppdelim (f, mhoriz, ind, ',');
	ppp_string (f, mhoriz, ind + 2, old -> Marker.txt);
	break;
      case TAGRef:
	pppstring (f, "Ref");
	pppdelim (f, mhoriz, ind, ',');
	ppp_int (f, mhoriz, ind + 2, old -> Ref.rnr);
	break;
      default:
	dcg_bad_tag (old -> tag, "ppp_rt_elem");
    };
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a rt_alt */
void ppp_rt_alt (FILE *f, int horiz, int ind, rt_alt old)
{ int mhoriz;
  if (old == rt_alt_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_rt_alt (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_int (f, mhoriz, ind + 2, old -> marker);
  pppdelim (f, mhoriz, ind, ',');
  ppp_rt_elem_list (f, mhoriz, ind + 2, old -> elems);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a rt_type */
void ppp_rt_type (FILE *f, int horiz, int ind, rt_type old)
{ int mhoriz;
  if (old == rt_type_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_rt_type (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_int (f, mhoriz, ind + 2, old -> rule_nr);
  pppdelim (f, mhoriz, ind, ',');
  ppp_string (f, mhoriz, ind + 2, old -> name);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int (f, mhoriz, ind + 2, old -> lexgen);
  pppdelim (f, mhoriz, ind, ',');
  ppp_affix_value (f, mhoriz, ind + 2, old -> value);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> print_code);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> meta_code);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> meta_rec_code);
  pppdelim (f, mhoriz, ind, ',');
  switch (old -> tag)
    { case TAGSynonym_type:
	pppstring (f, "Synonym_type");
	pppdelim (f, mhoriz, ind, ',');
	ppp_int (f, mhoriz, ind + 2, old -> Synonym_type.snr);
	break;
      case TAGAny_type:
	pppstring (f, "Any_type");
	break;
      case TAGInt_type:
	pppstring (f, "Int_type");
	break;
      case TAGReal_type:
	pppstring (f, "Real_type");
	break;
      case TAGText_type:
	pppstring (f, "Text_type");
	break;
      case TAGLattice_type:
	pppstring (f, "Lattice_type");
	pppdelim (f, mhoriz, ind, ',');
	ppp_int (f, mhoriz, ind + 2, old -> Lattice_type.dom);
	break;
      case TAGTree_type:
	pppstring (f, "Tree_type");
	pppdelim (f, mhoriz, ind, ',');
	ppp_rt_alt_list (f, mhoriz, ind + 2, old -> Tree_type.alts);
	break;
      default:
	dcg_bad_tag (old -> tag, "ppp_rt_type");
    };
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a cset_part */
void ppp_cset_part (FILE *f, int horiz, int ind, cset_part old)
{ int mhoriz;
  if (old == cset_part_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_cset_part (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  switch (old -> tag)
    { case TAGPart_match:
	pppstring (f, "Part_match");
	pppdelim (f, mhoriz, ind, ',');
	ppp_int (f, mhoriz, ind + 2, old -> Part_match.ch);
	break;
      case TAGPart_range:
	pppstring (f, "Part_range");
	pppdelim (f, mhoriz, ind, ',');
	ppp_int (f, mhoriz, ind + 2, old -> Part_range.first);
	pppdelim (f, mhoriz, ind, ',');
	ppp_int (f, mhoriz, ind + 2, old -> Part_range.last);
	break;
      default:
	dcg_bad_tag (old -> tag, "ppp_cset_part");
    };
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a cset */
void ppp_cset (FILE *f, int horiz, int ind, cset old)
{ int mhoriz;
  if (old == cset_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_cset (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_int (f, mhoriz, ind + 2, old -> invert);
  pppdelim (f, mhoriz, ind, ',');
  ppp_cset_part_list (f, mhoriz, ind + 2, old -> parts);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a terminal */
void ppp_terminal (FILE *f, int horiz, int ind, terminal old)
{ int mhoriz;
  if (old == terminal_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_terminal (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_int (f, mhoriz, ind + 2, old -> marker);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int_list (f, mhoriz, ind + 2, old -> text);
  pppdelim (f, mhoriz, ind, ',');
  ppp_string (f, mhoriz, ind + 2, old -> origin);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a nfa_state */
void ppp_nfa_state (FILE *f, int horiz, int ind, nfa_state old)
{ int mhoriz;
  if (old == nfa_state_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_nfa_state (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_int (f, mhoriz, ind + 2, old -> self);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int (f, mhoriz, ind + 2, old -> final);
  pppdelim (f, mhoriz, ind, ',');
  ppp_nfa_trans_list (f, mhoriz, ind + 2, old -> transitions);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> indeg);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a nfa_trans */
void ppp_nfa_trans (FILE *f, int horiz, int ind, nfa_trans old)
{ int mhoriz;
  if (old == nfa_trans_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_nfa_trans (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_int (f, mhoriz, ind + 2, old -> dest);
  pppdelim (f, mhoriz, ind, ',');
  switch (old -> tag)
    { case TAGTrans_char:
	pppstring (f, "Trans_char");
	pppdelim (f, mhoriz, ind, ',');
	ppp_int (f, mhoriz, ind + 2, old -> Trans_char.ch);
	break;
      case TAGTrans_cset:
	pppstring (f, "Trans_cset");
	pppdelim (f, mhoriz, ind, ',');
	ppp_int (f, mhoriz, ind + 2, old -> Trans_cset.cs);
	break;
      case TAGTrans_anychar:
	pppstring (f, "Trans_anychar");
	break;
      case TAGTrans_whitespace:
	pppstring (f, "Trans_whitespace");
	break;
      case TAGTrans_nonwhitespace:
	pppstring (f, "Trans_nonwhitespace");
	break;
      case TAGTrans_empty:
	pppstring (f, "Trans_empty");
	break;
      default:
	dcg_bad_tag (old -> tag, "ppp_nfa_trans");
    };
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a nfa */
void ppp_nfa (FILE *f, int horiz, int ind, nfa old)
{ int mhoriz;
  if (old == nfa_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_nfa (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_int (f, mhoriz, ind + 2, old -> kind);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int (f, mhoriz, ind + 2, old -> marker);
  pppdelim (f, mhoriz, ind, ',');
  ppp_string (f, mhoriz, ind + 2, old -> origin);
  pppdelim (f, mhoriz, ind, ',');
  ppp_nfa_state_list (f, mhoriz, ind + 2, old -> states);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a lex_nont */
void ppp_lex_nont (FILE *f, int horiz, int ind, lex_nont old)
{ int mhoriz;
  if (old == lex_nont_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_lex_nont (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_int (f, mhoriz, ind + 2, old -> rule_nr);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int (f, mhoriz, ind + 2, old -> fact_nr);
  pppdelim (f, mhoriz, ind, ',');
  ppp_string_list (f, mhoriz, ind + 2, old -> name_parts);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int_list (f, mhoriz, ind + 2, old -> name_chars);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int (f, mhoriz, ind + 2, old -> ncrits);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int_list (f, mhoriz, ind + 2, old -> formals);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int_list (f, mhoriz, ind + 2, old -> crits);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a rt_nont */
void ppp_rt_nont (FILE *f, int horiz, int ind, rt_nont old)
{ int mhoriz;
  if (old == rt_nont_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_rt_nont (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_string_list (f, mhoriz, ind + 2, old -> name_parts);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int_list (f, mhoriz, ind + 2, old -> name_chars);
  pppdelim (f, mhoriz, ind, ',');
  ppp_string (f, mhoriz, ind + 2, old -> canonic_name);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int_list (f, mhoriz, ind + 2, old -> formals);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int (f, mhoriz, ind + 2, old -> lex_nr);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a ext_nont */
void ppp_ext_nont (FILE *f, int horiz, int ind, ext_nont old)
{ int mhoriz;
  if (old == ext_nont_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_ext_nont (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_string (f, mhoriz, ind + 2, old -> canonic_name);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int (f, mhoriz, ind + 2, old -> rule_nr);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a tree_kind */
void ppp_tree_kind (FILE *f, int horiz, int ind, tree_kind old)
{ switch (old)
     { case normal_node:
	pppstring (f, "normal_node");
	break;
       case simple_node:
	pppstring (f, "simple_node");
	break;
       case anonymous_node:
	pppstring (f, "anonymous_node");
	break;
       case leaf_node:
	pppstring (f, "leaf_node");
	break;
       case lex_nont_node:
	pppstring (f, "lex_nont_node");
	break;
       case predicate_node:
	pppstring (f, "predicate_node");
	break;
       case confrontation_node:
	pppstring (f, "confrontation_node");
	break;
       case penalty_node:
	pppstring (f, "penalty_node");
	break;
       case quasi_node:
	pppstring (f, "quasi_node");
	break;
      default:
	dcg_bad_tag (old, "ppp_tree_kind");
    };
}

/* Pretty print a affix_expr_kind */
void ppp_affix_expr_kind (FILE *f, int horiz, int ind, affix_expr_kind old)
{ switch (old)
     { case single_affix_node:
	pppstring (f, "single_affix_node");
	break;
       case ast_node:
	pppstring (f, "ast_node");
	break;
       case concat_node:
	pppstring (f, "concat_node");
	break;
       case dyop_arith_node:
	pppstring (f, "dyop_arith_node");
	break;
       case monop_arith_node:
	pppstring (f, "monop_arith_node");
	break;
      default:
	dcg_bad_tag (old, "ppp_affix_expr_kind");
    };
}

/* Pretty print a propagation_kind */
void ppp_propagation_kind (FILE *f, int horiz, int ind, propagation_kind old)
{ switch (old)
     { case p_bidirectional:
	pppstring (f, "p_bidirectional");
	break;
       case p_left_to_right:
	pppstring (f, "p_left_to_right");
	break;
       case p_lower_to_upper:
	pppstring (f, "p_lower_to_upper");
	break;
       case p_equal:
	pppstring (f, "p_equal");
	break;
       case p_unequal:
	pppstring (f, "p_unequal");
	break;
       case p_restrict:
	pppstring (f, "p_restrict");
	break;
      default:
	dcg_bad_tag (old, "ppp_propagation_kind");
    };
}

/* Pretty print a operator */
void ppp_operator (FILE *f, int horiz, int ind, operator old)
{ switch (old)
     { case times:
	pppstring (f, "times");
	break;
       case modulo:
	pppstring (f, "modulo");
	break;
       case divides:
	pppstring (f, "divides");
	break;
       case plus:
	pppstring (f, "plus");
	break;
       case minus:
	pppstring (f, "minus");
	break;
       case a_union:
	pppstring (f, "a_union");
	break;
       case a_part:
	pppstring (f, "a_part");
	break;
       case shift_left:
	pppstring (f, "shift_left");
	break;
       case shift_right:
	pppstring (f, "shift_right");
	break;
       case bitwise_xor:
	pppstring (f, "bitwise_xor");
	break;
       case bitwise_not:
	pppstring (f, "bitwise_not");
	break;
       case bitwise_or:
	pppstring (f, "bitwise_or");
	break;
       case bitwise_and:
	pppstring (f, "bitwise_and");
	break;
       case int_times_int:
	pppstring (f, "int_times_int");
	break;
       case real_times_real:
	pppstring (f, "real_times_real");
	break;
       case int_times_text:
	pppstring (f, "int_times_text");
	break;
       case int_plus_int:
	pppstring (f, "int_plus_int");
	break;
       case real_plus_real:
	pppstring (f, "real_plus_real");
	break;
       case text_plus_text:
	pppstring (f, "text_plus_text");
	break;
       case int_minus_int:
	pppstring (f, "int_minus_int");
	break;
       case real_minus_real:
	pppstring (f, "real_minus_real");
	break;
      default:
	dcg_bad_tag (old, "ppp_operator");
    };
}

/* Pretty print a director_set */
void ppp_director_set (FILE *f, int horiz, int ind, director_set old)
{ int mhoriz;
  if (old == director_set_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_director_set (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_int (f, mhoriz, ind + 2, old -> min_phase);
  pppdelim (f, mhoriz, ind, ',');
  ppp_trans_pair_list (f, mhoriz, ind + 2, old -> set);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a trans_pair */
void ppp_trans_pair (FILE *f, int horiz, int ind, trans_pair old)
{ int mhoriz;
  if (old == trans_pair_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_trans_pair (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_int (f, mhoriz, ind + 2, old -> class);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int (f, mhoriz, ind + 2, old -> number);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a affix_value_list */
void ppp_affix_value_list (FILE *f, int horiz, int ind, affix_value_list old)
{ int ix, mhoriz;
  if (old == affix_value_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_affix_value_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_affix_value (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a rt_element_list */
void ppp_rt_element_list (FILE *f, int horiz, int ind, rt_element_list old)
{ int ix, mhoriz;
  if (old == rt_element_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_rt_element_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_rt_element (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a rt_domain_list */
void ppp_rt_domain_list (FILE *f, int horiz, int ind, rt_domain_list old)
{ int ix, mhoriz;
  if (old == rt_domain_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_rt_domain_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_rt_domain (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a rt_elem_list */
void ppp_rt_elem_list (FILE *f, int horiz, int ind, rt_elem_list old)
{ int ix, mhoriz;
  if (old == rt_elem_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_rt_elem_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_rt_elem (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a rt_alt_list */
void ppp_rt_alt_list (FILE *f, int horiz, int ind, rt_alt_list old)
{ int ix, mhoriz;
  if (old == rt_alt_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_rt_alt_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_rt_alt (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a rt_type_list */
void ppp_rt_type_list (FILE *f, int horiz, int ind, rt_type_list old)
{ int ix, mhoriz;
  if (old == rt_type_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_rt_type_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_rt_type (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a cset_part_list */
void ppp_cset_part_list (FILE *f, int horiz, int ind, cset_part_list old)
{ int ix, mhoriz;
  if (old == cset_part_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_cset_part_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_cset_part (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a cset_list */
void ppp_cset_list (FILE *f, int horiz, int ind, cset_list old)
{ int ix, mhoriz;
  if (old == cset_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_cset_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_cset (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a terminal_list */
void ppp_terminal_list (FILE *f, int horiz, int ind, terminal_list old)
{ int ix, mhoriz;
  if (old == terminal_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_terminal_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_terminal (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a nfa_state_list */
void ppp_nfa_state_list (FILE *f, int horiz, int ind, nfa_state_list old)
{ int ix, mhoriz;
  if (old == nfa_state_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_nfa_state_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_nfa_state (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a nfa_trans_list */
void ppp_nfa_trans_list (FILE *f, int horiz, int ind, nfa_trans_list old)
{ int ix, mhoriz;
  if (old == nfa_trans_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_nfa_trans_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_nfa_trans (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a nfa_list */
void ppp_nfa_list (FILE *f, int horiz, int ind, nfa_list old)
{ int ix, mhoriz;
  if (old == nfa_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_nfa_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_nfa (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a lex_nont_list */
void ppp_lex_nont_list (FILE *f, int horiz, int ind, lex_nont_list old)
{ int ix, mhoriz;
  if (old == lex_nont_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_lex_nont_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_lex_nont (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a rt_nont_list */
void ppp_rt_nont_list (FILE *f, int horiz, int ind, rt_nont_list old)
{ int ix, mhoriz;
  if (old == rt_nont_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_rt_nont_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_rt_nont (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a ext_nont_list */
void ppp_ext_nont_list (FILE *f, int horiz, int ind, ext_nont_list old)
{ int ix, mhoriz;
  if (old == ext_nont_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_ext_nont_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_ext_nont (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a trans_pair_list */
void ppp_trans_pair_list (FILE *f, int horiz, int ind, trans_pair_list old)
{ int ix, mhoriz;
  if (old == trans_pair_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_trans_pair_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_trans_pair (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a int_list_list */
void ppp_int_list_list (FILE *f, int horiz, int ind, int_list_list old)
{ int ix, mhoriz;
  if (old == int_list_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_int_list_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_int_list (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a u_int64_list */
void ppp_u_int64_list (FILE *f, int horiz, int ind, u_int64_list old)
{ int ix, mhoriz;
  if (old == u_int64_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_u_int64_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_u_int64 (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Recursively save a affix_value */
void save_affix_value (BinFile bf, affix_value old)
{ /* save fixed fields before variant ones */
  save_int (bf, old -> rule_nr);
  save_char (bf, (char) old -> tag);
  switch (old -> tag)
    { case TAGNull_value:
	break;
      case TAGText_value:
	save_string (bf, old -> Text_value.text);
	break;
      case TAGInt_value:
	save_int (bf, old -> Int_value.ival);
	break;
      case TAGReal_value:
	save_real (bf, old -> Real_value.rval);
	break;
      case TAGSmall_lattice:
	save_int (bf, old -> Small_lattice.dom);
	save_u_int64 (bf, old -> Small_lattice.slat);
	break;
      case TAGLarge_lattice:
	save_int (bf, old -> Large_lattice.dom);
	save_u_int64_list (bf, old -> Large_lattice.llat);
	break;
      case TAGList_lattice:
	save_int_list (bf, old -> List_lattice.llat);
	break;
      case TAGComposed_value:
	save_int (bf, old -> Composed_value.marker);
	save_affix_value_list (bf, old -> Composed_value.parts);
	break;
      default:
	dcg_bad_tag (old -> tag, "save_affix_value");
    };
}

/* Recursively save a rt_element */
void save_rt_element (BinFile bf, rt_element old)
{ /* save fixed fields before variant ones */
  save_string (bf, old -> name);
  save_affix_value (bf, old -> value);
}

/* Recursively save a rt_domain */
void save_rt_domain (BinFile bf, rt_domain old)
{ /* save fixed fields before variant ones */
  save_int (bf, old -> width);
  save_rt_element_list (bf, old -> elts);
}

/* Recursively save a rt_elem */
void save_rt_elem (BinFile bf, rt_elem old)
{ /* save fixed fields before variant ones */
  save_char (bf, (char) old -> tag);
  switch (old -> tag)
    { case TAGMarker:
	save_string (bf, old -> Marker.txt);
	break;
      case TAGRef:
	save_int (bf, old -> Ref.rnr);
	break;
      default:
	dcg_bad_tag (old -> tag, "save_rt_elem");
    };
}

/* Recursively save a rt_alt */
void save_rt_alt (BinFile bf, rt_alt old)
{ /* save fixed fields before variant ones */
  save_int (bf, old -> marker);
  save_rt_elem_list (bf, old -> elems);
}

/* Recursively save a rt_type */
void save_rt_type (BinFile bf, rt_type old)
{ /* save fixed fields before variant ones */
  save_int (bf, old -> rule_nr);
  save_string (bf, old -> name);
  save_int (bf, old -> lexgen);
  save_affix_value (bf, old -> value);
  save_char (bf, (char) old -> tag);
  switch (old -> tag)
    { case TAGSynonym_type:
	save_int (bf, old -> Synonym_type.snr);
	break;
      case TAGAny_type:
	break;
      case TAGInt_type:
	break;
      case TAGReal_type:
	break;
      case TAGText_type:
	break;
      case TAGLattice_type:
	save_int (bf, old -> Lattice_type.dom);
	break;
      case TAGTree_type:
	save_rt_alt_list (bf, old -> Tree_type.alts);
	break;
      default:
	dcg_bad_tag (old -> tag, "save_rt_type");
    };
}

/* Recursively save a cset_part */
void save_cset_part (BinFile bf, cset_part old)
{ /* save fixed fields before variant ones */
  save_char (bf, (char) old -> tag);
  switch (old -> tag)
    { case TAGPart_match:
	save_int (bf, old -> Part_match.ch);
	break;
      case TAGPart_range:
	save_int (bf, old -> Part_range.first);
	save_int (bf, old -> Part_range.last);
	break;
      default:
	dcg_bad_tag (old -> tag, "save_cset_part");
    };
}

/* Recursively save a cset */
void save_cset (BinFile bf, cset old)
{ /* save fixed fields before variant ones */
  save_int (bf, old -> invert);
  save_cset_part_list (bf, old -> parts);
}

/* Recursively save a terminal */
void save_terminal (BinFile bf, terminal old)
{ /* save fixed fields before variant ones */
  save_int (bf, old -> marker);
  save_int_list (bf, old -> text);
  save_string (bf, old -> origin);
}

/* Recursively save a nfa_state */
void save_nfa_state (BinFile bf, nfa_state old)
{ /* save fixed fields before variant ones */
  save_int (bf, old -> self);
  save_int (bf, old -> final);
  save_nfa_trans_list (bf, old -> transitions);
}

/* Recursively save a nfa_trans */
void save_nfa_trans (BinFile bf, nfa_trans old)
{ /* save fixed fields before variant ones */
  save_int (bf, old -> dest);
  save_char (bf, (char) old -> tag);
  switch (old -> tag)
    { case TAGTrans_char:
	save_int (bf, old -> Trans_char.ch);
	break;
      case TAGTrans_cset:
	save_int (bf, old -> Trans_cset.cs);
	break;
      case TAGTrans_anychar:
	break;
      case TAGTrans_whitespace:
	break;
      case TAGTrans_nonwhitespace:
	break;
      case TAGTrans_empty:
	break;
      default:
	dcg_bad_tag (old -> tag, "save_nfa_trans");
    };
}

/* Recursively save a nfa */
void save_nfa (BinFile bf, nfa old)
{ /* save fixed fields before variant ones */
  save_int (bf, old -> kind);
  save_int (bf, old -> marker);
  save_string (bf, old -> origin);
  save_nfa_state_list (bf, old -> states);
}

/* Recursively save a lex_nont */
void save_lex_nont (BinFile bf, lex_nont old)
{ /* save fixed fields before variant ones */
  save_int (bf, old -> rule_nr);
  save_int (bf, old -> fact_nr);
  save_string_list (bf, old -> name_parts);
  save_int_list (bf, old -> name_chars);
  save_int (bf, old -> ncrits);
  save_int_list (bf, old -> formals);
  save_int_list (bf, old -> crits);
}

/* Recursively save a rt_nont */
void save_rt_nont (BinFile bf, rt_nont old)
{ /* save fixed fields before variant ones */
  save_string_list (bf, old -> name_parts);
  save_int_list (bf, old -> name_chars);
  save_string (bf, old -> canonic_name);
  save_int_list (bf, old -> formals);
  save_int (bf, old -> lex_nr);
}

/* Recursively save a ext_nont */
void save_ext_nont (BinFile bf, ext_nont old)
{ /* save fixed fields before variant ones */
  save_string (bf, old -> canonic_name);
  save_int (bf, old -> rule_nr);
}

/* Recursively save a director_set */
void save_director_set (BinFile bf, director_set old)
{ /* save fixed fields before variant ones */
  save_int (bf, old -> min_phase);
  save_trans_pair_list (bf, old -> set);
}

/* Recursively save a trans_pair */
void save_trans_pair (BinFile bf, trans_pair old)
{ /* save fixed fields before variant ones */
  save_int (bf, old -> class);
  save_int (bf, old -> number);
}

/* Recursively save a affix_value_list */
void save_affix_value_list (BinFile bf, affix_value_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_affix_value (bf, l -> array[ix]);
}

/* Recursively save a rt_element_list */
void save_rt_element_list (BinFile bf, rt_element_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_rt_element (bf, l -> array[ix]);
}

/* Recursively save a rt_domain_list */
void save_rt_domain_list (BinFile bf, rt_domain_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_rt_domain (bf, l -> array[ix]);
}

/* Recursively save a rt_elem_list */
void save_rt_elem_list (BinFile bf, rt_elem_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_rt_elem (bf, l -> array[ix]);
}

/* Recursively save a rt_alt_list */
void save_rt_alt_list (BinFile bf, rt_alt_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_rt_alt (bf, l -> array[ix]);
}

/* Recursively save a rt_type_list */
void save_rt_type_list (BinFile bf, rt_type_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_rt_type (bf, l -> array[ix]);
}

/* Recursively save a cset_part_list */
void save_cset_part_list (BinFile bf, cset_part_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_cset_part (bf, l -> array[ix]);
}

/* Recursively save a cset_list */
void save_cset_list (BinFile bf, cset_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_cset (bf, l -> array[ix]);
}

/* Recursively save a terminal_list */
void save_terminal_list (BinFile bf, terminal_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_terminal (bf, l -> array[ix]);
}

/* Recursively save a nfa_state_list */
void save_nfa_state_list (BinFile bf, nfa_state_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_nfa_state (bf, l -> array[ix]);
}

/* Recursively save a nfa_trans_list */
void save_nfa_trans_list (BinFile bf, nfa_trans_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_nfa_trans (bf, l -> array[ix]);
}

/* Recursively save a nfa_list */
void save_nfa_list (BinFile bf, nfa_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_nfa (bf, l -> array[ix]);
}

/* Recursively save a lex_nont_list */
void save_lex_nont_list (BinFile bf, lex_nont_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_lex_nont (bf, l -> array[ix]);
}

/* Recursively save a rt_nont_list */
void save_rt_nont_list (BinFile bf, rt_nont_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_rt_nont (bf, l -> array[ix]);
}

/* Recursively save a ext_nont_list */
void save_ext_nont_list (BinFile bf, ext_nont_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_ext_nont (bf, l -> array[ix]);
}

/* Recursively save a trans_pair_list */
void save_trans_pair_list (BinFile bf, trans_pair_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_trans_pair (bf, l -> array[ix]);
}

/* Recursively save a int_list_list */
void save_int_list_list (BinFile bf, int_list_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_int_list (bf, l -> array[ix]);
}

/* Recursively save a u_int64_list */
void save_u_int64_list (BinFile bf, u_int64_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_u_int64 (bf, l -> array[ix]);
}

/* Recursively load a affix_value */
void load_affix_value (BinFile bf, affix_value *x)
{ /* load fixed fields before variant ones */
  affix_value new = (affix_value) dcg_malloc (sizeof (struct str_affix_value));
  char ch;
  load_int (bf, &new -> rule_nr);
  load_char (bf, &ch);
  new -> tag = (tags_affix_value) ch;
  switch (new -> tag)
    { case TAGNull_value:
	break;
      case TAGText_value:
	load_string (bf, &new -> Text_value.text);
	break;
      case TAGInt_value:
	load_int (bf, &new -> Int_value.ival);
	break;
      case TAGReal_value:
	load_real (bf, &new -> Real_value.rval);
	break;
      case TAGSmall_lattice:
	load_int (bf, &new -> Small_lattice.dom);
	load_u_int64 (bf, &new -> Small_lattice.slat);
	break;
      case TAGLarge_lattice:
	load_int (bf, &new -> Large_lattice.dom);
	load_u_int64_list (bf, &new -> Large_lattice.llat);
	break;
      case TAGList_lattice:
	load_int_list (bf, &new -> List_lattice.llat);
	break;
      case TAGComposed_value:
	load_int (bf, &new -> Composed_value.marker);
	load_affix_value_list (bf, &new -> Composed_value.parts);
	break;
      default:
	dcg_bad_tag (new -> tag, "load_affix_value");
    };
  *x = new;
}

/* Recursively load a rt_element */
void load_rt_element (BinFile bf, rt_element *x)
{ /* load fixed fields before variant ones */
  rt_element new = (rt_element) dcg_malloc (sizeof (struct str_rt_element));
  load_string (bf, &new -> name);
  load_affix_value (bf, &new -> value);
  *x = new;
}

/* Recursively load a rt_domain */
void load_rt_domain (BinFile bf, rt_domain *x)
{ /* load fixed fields before variant ones */
  rt_domain new = (rt_domain) dcg_malloc (sizeof (struct str_rt_domain));
  load_int (bf, &new -> width);
  load_rt_element_list (bf, &new -> elts);
  *x = new;
}

/* Recursively load a rt_elem */
void load_rt_elem (BinFile bf, rt_elem *x)
{ /* load fixed fields before variant ones */
  rt_elem new = (rt_elem) dcg_malloc (sizeof (struct str_rt_elem));
  char ch;
  load_char (bf, &ch);
  new -> tag = (tags_rt_elem) ch;
  switch (new -> tag)
    { case TAGMarker:
	load_string (bf, &new -> Marker.txt);
	break;
      case TAGRef:
	load_int (bf, &new -> Ref.rnr);
	break;
      default:
	dcg_bad_tag (new -> tag, "load_rt_elem");
    };
  *x = new;
}

/* Recursively load a rt_alt */
void load_rt_alt (BinFile bf, rt_alt *x)
{ /* load fixed fields before variant ones */
  rt_alt new = (rt_alt) dcg_malloc (sizeof (struct str_rt_alt));
  load_int (bf, &new -> marker);
  load_rt_elem_list (bf, &new -> elems);
  *x = new;
}

/* Recursively load a rt_type */
void load_rt_type (BinFile bf, rt_type *x)
{ /* load fixed fields before variant ones */
  rt_type new = (rt_type) dcg_malloc (sizeof (struct str_rt_type));
  char ch;
  load_int (bf, &new -> rule_nr);
  load_string (bf, &new -> name);
  load_int (bf, &new -> lexgen);
  load_affix_value (bf, &new -> value);
  new -> print_code = vptr_nil;
  new -> meta_code = vptr_nil;
  new -> meta_rec_code = vptr_nil;
  load_char (bf, &ch);
  new -> tag = (tags_rt_type) ch;
  switch (new -> tag)
    { case TAGSynonym_type:
	load_int (bf, &new -> Synonym_type.snr);
	break;
      case TAGAny_type:
	break;
      case TAGInt_type:
	break;
      case TAGReal_type:
	break;
      case TAGText_type:
	break;
      case TAGLattice_type:
	load_int (bf, &new -> Lattice_type.dom);
	break;
      case TAGTree_type:
	load_rt_alt_list (bf, &new -> Tree_type.alts);
	break;
      default:
	dcg_bad_tag (new -> tag, "load_rt_type");
    };
  *x = new;
}

/* Recursively load a cset_part */
void load_cset_part (BinFile bf, cset_part *x)
{ /* load fixed fields before variant ones */
  cset_part new = (cset_part) dcg_malloc (sizeof (struct str_cset_part));
  char ch;
  load_char (bf, &ch);
  new -> tag = (tags_cset_part) ch;
  switch (new -> tag)
    { case TAGPart_match:
	load_int (bf, &new -> Part_match.ch);
	break;
      case TAGPart_range:
	load_int (bf, &new -> Part_range.first);
	load_int (bf, &new -> Part_range.last);
	break;
      default:
	dcg_bad_tag (new -> tag, "load_cset_part");
    };
  *x = new;
}

/* Recursively load a cset */
void load_cset (BinFile bf, cset *x)
{ /* load fixed fields before variant ones */
  cset new = (cset) dcg_malloc (sizeof (struct str_cset));
  load_int (bf, &new -> invert);
  load_cset_part_list (bf, &new -> parts);
  *x = new;
}

/* Recursively load a terminal */
void load_terminal (BinFile bf, terminal *x)
{ /* load fixed fields before variant ones */
  terminal new = (terminal) dcg_malloc (sizeof (struct str_terminal));
  load_int (bf, &new -> marker);
  load_int_list (bf, &new -> text);
  load_string (bf, &new -> origin);
  *x = new;
}

/* Recursively load a nfa_state */
void load_nfa_state (BinFile bf, nfa_state *x)
{ /* load fixed fields before variant ones */
  nfa_state new = (nfa_state) dcg_malloc (sizeof (struct str_nfa_state));
  load_int (bf, &new -> self);
  load_int (bf, &new -> final);
  load_nfa_trans_list (bf, &new -> transitions);
  new -> indeg = int_nil;
  *x = new;
}

/* Recursively load a nfa_trans */
void load_nfa_trans (BinFile bf, nfa_trans *x)
{ /* load fixed fields before variant ones */
  nfa_trans new = (nfa_trans) dcg_malloc (sizeof (struct str_nfa_trans));
  char ch;
  load_int (bf, &new -> dest);
  load_char (bf, &ch);
  new -> tag = (tags_nfa_trans) ch;
  switch (new -> tag)
    { case TAGTrans_char:
	load_int (bf, &new -> Trans_char.ch);
	break;
      case TAGTrans_cset:
	load_int (bf, &new -> Trans_cset.cs);
	break;
      case TAGTrans_anychar:
	break;
      case TAGTrans_whitespace:
	break;
      case TAGTrans_nonwhitespace:
	break;
      case TAGTrans_empty:
	break;
      default:
	dcg_bad_tag (new -> tag, "load_nfa_trans");
    };
  *x = new;
}

/* Recursively load a nfa */
void load_nfa (BinFile bf, nfa *x)
{ /* load fixed fields before variant ones */
  nfa new = (nfa) dcg_malloc (sizeof (struct str_nfa));
  load_int (bf, &new -> kind);
  load_int (bf, &new -> marker);
  load_string (bf, &new -> origin);
  load_nfa_state_list (bf, &new -> states);
  *x = new;
}

/* Recursively load a lex_nont */
void load_lex_nont (BinFile bf, lex_nont *x)
{ /* load fixed fields before variant ones */
  lex_nont new = (lex_nont) dcg_malloc (sizeof (struct str_lex_nont));
  load_int (bf, &new -> rule_nr);
  load_int (bf, &new -> fact_nr);
  load_string_list (bf, &new -> name_parts);
  load_int_list (bf, &new -> name_chars);
  load_int (bf, &new -> ncrits);
  load_int_list (bf, &new -> formals);
  load_int_list (bf, &new -> crits);
  *x = new;
}

/* Recursively load a rt_nont */
void load_rt_nont (BinFile bf, rt_nont *x)
{ /* load fixed fields before variant ones */
  rt_nont new = (rt_nont) dcg_malloc (sizeof (struct str_rt_nont));
  load_string_list (bf, &new -> name_parts);
  load_int_list (bf, &new -> name_chars);
  load_string (bf, &new -> canonic_name);
  load_int_list (bf, &new -> formals);
  load_int (bf, &new -> lex_nr);
  *x = new;
}

/* Recursively load a ext_nont */
void load_ext_nont (BinFile bf, ext_nont *x)
{ /* load fixed fields before variant ones */
  ext_nont new = (ext_nont) dcg_malloc (sizeof (struct str_ext_nont));
  load_string (bf, &new -> canonic_name);
  load_int (bf, &new -> rule_nr);
  *x = new;
}

/* Load a tree_kind */
void load_tree_kind (BinFile bf, tree_kind *x)
{ char ch;
  load_char (bf, &ch);
  *x = (tree_kind) ch;
}

/* Load a affix_expr_kind */
void load_affix_expr_kind (BinFile bf, affix_expr_kind *x)
{ char ch;
  load_char (bf, &ch);
  *x = (affix_expr_kind) ch;
}

/* Load a propagation_kind */
void load_propagation_kind (BinFile bf, propagation_kind *x)
{ char ch;
  load_char (bf, &ch);
  *x = (propagation_kind) ch;
}

/* Load a operator */
void load_operator (BinFile bf, operator *x)
{ char ch;
  load_char (bf, &ch);
  *x = (operator) ch;
}

/* Recursively load a director_set */
void load_director_set (BinFile bf, director_set *x)
{ /* load fixed fields before variant ones */
  director_set new = (director_set) dcg_malloc (sizeof (struct str_director_set));
  load_int (bf, &new -> min_phase);
  load_trans_pair_list (bf, &new -> set);
  *x = new;
}

/* Recursively load a trans_pair */
void load_trans_pair (BinFile bf, trans_pair *x)
{ /* load fixed fields before variant ones */
  trans_pair new = (trans_pair) dcg_malloc (sizeof (struct str_trans_pair));
  load_int (bf, &new -> class);
  load_int (bf, &new -> number);
  *x = new;
}

/* Recursively load a affix_value_list */
void load_affix_value_list (BinFile bf, affix_value_list *l)
{ int ix, size;
  affix_value_list new;
  loadsize (bf, &size);
  new = init_affix_value_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_affix_value (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a rt_element_list */
void load_rt_element_list (BinFile bf, rt_element_list *l)
{ int ix, size;
  rt_element_list new;
  loadsize (bf, &size);
  new = init_rt_element_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_rt_element (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a rt_domain_list */
void load_rt_domain_list (BinFile bf, rt_domain_list *l)
{ int ix, size;
  rt_domain_list new;
  loadsize (bf, &size);
  new = init_rt_domain_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_rt_domain (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a rt_elem_list */
void load_rt_elem_list (BinFile bf, rt_elem_list *l)
{ int ix, size;
  rt_elem_list new;
  loadsize (bf, &size);
  new = init_rt_elem_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_rt_elem (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a rt_alt_list */
void load_rt_alt_list (BinFile bf, rt_alt_list *l)
{ int ix, size;
  rt_alt_list new;
  loadsize (bf, &size);
  new = init_rt_alt_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_rt_alt (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a rt_type_list */
void load_rt_type_list (BinFile bf, rt_type_list *l)
{ int ix, size;
  rt_type_list new;
  loadsize (bf, &size);
  new = init_rt_type_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_rt_type (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a cset_part_list */
void load_cset_part_list (BinFile bf, cset_part_list *l)
{ int ix, size;
  cset_part_list new;
  loadsize (bf, &size);
  new = init_cset_part_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_cset_part (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a cset_list */
void load_cset_list (BinFile bf, cset_list *l)
{ int ix, size;
  cset_list new;
  loadsize (bf, &size);
  new = init_cset_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_cset (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a terminal_list */
void load_terminal_list (BinFile bf, terminal_list *l)
{ int ix, size;
  terminal_list new;
  loadsize (bf, &size);
  new = init_terminal_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_terminal (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a nfa_state_list */
void load_nfa_state_list (BinFile bf, nfa_state_list *l)
{ int ix, size;
  nfa_state_list new;
  loadsize (bf, &size);
  new = init_nfa_state_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_nfa_state (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a nfa_trans_list */
void load_nfa_trans_list (BinFile bf, nfa_trans_list *l)
{ int ix, size;
  nfa_trans_list new;
  loadsize (bf, &size);
  new = init_nfa_trans_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_nfa_trans (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a nfa_list */
void load_nfa_list (BinFile bf, nfa_list *l)
{ int ix, size;
  nfa_list new;
  loadsize (bf, &size);
  new = init_nfa_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_nfa (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a lex_nont_list */
void load_lex_nont_list (BinFile bf, lex_nont_list *l)
{ int ix, size;
  lex_nont_list new;
  loadsize (bf, &size);
  new = init_lex_nont_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_lex_nont (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a rt_nont_list */
void load_rt_nont_list (BinFile bf, rt_nont_list *l)
{ int ix, size;
  rt_nont_list new;
  loadsize (bf, &size);
  new = init_rt_nont_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_rt_nont (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a ext_nont_list */
void load_ext_nont_list (BinFile bf, ext_nont_list *l)
{ int ix, size;
  ext_nont_list new;
  loadsize (bf, &size);
  new = init_ext_nont_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_ext_nont (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a trans_pair_list */
void load_trans_pair_list (BinFile bf, trans_pair_list *l)
{ int ix, size;
  trans_pair_list new;
  loadsize (bf, &size);
  new = init_trans_pair_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_trans_pair (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a int_list_list */
void load_int_list_list (BinFile bf, int_list_list *l)
{ int ix, size;
  int_list_list new;
  loadsize (bf, &size);
  new = init_int_list_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_int_list (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a u_int64_list */
void load_u_int64_list (BinFile bf, u_int64_list *l)
{ int ix, size;
  u_int64_list new;
  loadsize (bf, &size);
  new = init_u_int64_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_u_int64 (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively duplicate a affix_value */
affix_value rdup_affix_value (affix_value old)
{ /* allocate new record */
  affix_value new;
  if (old == affix_value_nil) return (old);
  new = (affix_value) dcg_malloc (sizeof (struct str_affix_value));

  /* duplicate fixed fields before variant ones */
  new -> rule_nr = rdup_int (old -> rule_nr);
  new -> tag = old -> tag;
  switch (old -> tag)
    { case TAGNull_value:
	break;
      case TAGText_value:
	new -> Text_value.text = rdup_string (old -> Text_value.text);
	break;
      case TAGInt_value:
	new -> Int_value.ival = rdup_int (old -> Int_value.ival);
	break;
      case TAGReal_value:
	new -> Real_value.rval = rdup_real (old -> Real_value.rval);
	break;
      case TAGSmall_lattice:
	new -> Small_lattice.dom = rdup_int (old -> Small_lattice.dom);
	new -> Small_lattice.slat = rdup_u_int64 (old -> Small_lattice.slat);
	break;
      case TAGLarge_lattice:
	new -> Large_lattice.dom = rdup_int (old -> Large_lattice.dom);
	new -> Large_lattice.llat = rdup_u_int64_list (old -> Large_lattice.llat);
	break;
      case TAGList_lattice:
	new -> List_lattice.llat = rdup_int_list (old -> List_lattice.llat);
	break;
      case TAGComposed_value:
	new -> Composed_value.marker = rdup_int (old -> Composed_value.marker);
	new -> Composed_value.parts = rdup_affix_value_list (old -> Composed_value.parts);
	break;
      default:
	dcg_bad_tag (old -> tag, "rdup_affix_value");
    };
  return (new);
}

/* Recursively duplicate a rt_element */
rt_element rdup_rt_element (rt_element old)
{ /* allocate new record */
  rt_element new;
  if (old == rt_element_nil) return (old);
  new = (rt_element) dcg_malloc (sizeof (struct str_rt_element));

  /* duplicate fixed fields before variant ones */
  new -> name = rdup_string (old -> name);
  new -> value = rdup_affix_value (old -> value);
  return (new);
}

/* Recursively duplicate a rt_domain */
rt_domain rdup_rt_domain (rt_domain old)
{ /* allocate new record */
  rt_domain new;
  if (old == rt_domain_nil) return (old);
  new = (rt_domain) dcg_malloc (sizeof (struct str_rt_domain));

  /* duplicate fixed fields before variant ones */
  new -> width = rdup_int (old -> width);
  new -> elts = rdup_rt_element_list (old -> elts);
  return (new);
}

/* Recursively duplicate a rt_elem */
rt_elem rdup_rt_elem (rt_elem old)
{ /* allocate new record */
  rt_elem new;
  if (old == rt_elem_nil) return (old);
  new = (rt_elem) dcg_malloc (sizeof (struct str_rt_elem));

  /* duplicate fixed fields before variant ones */
  new -> tag = old -> tag;
  switch (old -> tag)
    { case TAGMarker:
	new -> Marker.txt = rdup_string (old -> Marker.txt);
	break;
      case TAGRef:
	new -> Ref.rnr = rdup_int (old -> Ref.rnr);
	break;
      default:
	dcg_bad_tag (old -> tag, "rdup_rt_elem");
    };
  return (new);
}

/* Recursively duplicate a rt_alt */
rt_alt rdup_rt_alt (rt_alt old)
{ /* allocate new record */
  rt_alt new;
  if (old == rt_alt_nil) return (old);
  new = (rt_alt) dcg_malloc (sizeof (struct str_rt_alt));

  /* duplicate fixed fields before variant ones */
  new -> marker = rdup_int (old -> marker);
  new -> elems = rdup_rt_elem_list (old -> elems);
  return (new);
}

/* Recursively duplicate a rt_type */
rt_type rdup_rt_type (rt_type old)
{ /* allocate new record */
  rt_type new;
  if (old == rt_type_nil) return (old);
  new = (rt_type) dcg_malloc (sizeof (struct str_rt_type));

  /* duplicate fixed fields before variant ones */
  new -> rule_nr = rdup_int (old -> rule_nr);
  new -> name = rdup_string (old -> name);
  new -> lexgen = rdup_int (old -> lexgen);
  new -> value = rdup_affix_value (old -> value);
  new -> tag = old -> tag;
  switch (old -> tag)
    { case TAGSynonym_type:
	new -> Synonym_type.snr = rdup_int (old -> Synonym_type.snr);
	break;
      case TAGAny_type:
	break;
      case TAGInt_type:
	break;
      case TAGReal_type:
	break;
      case TAGText_type:
	break;
      case TAGLattice_type:
	new -> Lattice_type.dom = rdup_int (old -> Lattice_type.dom);
	break;
      case TAGTree_type:
	new -> Tree_type.alts = rdup_rt_alt_list (old -> Tree_type.alts);
	break;
      default:
	dcg_bad_tag (old -> tag, "rdup_rt_type");
    };
  return (new);
}

/* Recursively duplicate a cset_part */
cset_part rdup_cset_part (cset_part old)
{ /* allocate new record */
  cset_part new;
  if (old == cset_part_nil) return (old);
  new = (cset_part) dcg_malloc (sizeof (struct str_cset_part));

  /* duplicate fixed fields before variant ones */
  new -> tag = old -> tag;
  switch (old -> tag)
    { case TAGPart_match:
	new -> Part_match.ch = rdup_int (old -> Part_match.ch);
	break;
      case TAGPart_range:
	new -> Part_range.first = rdup_int (old -> Part_range.first);
	new -> Part_range.last = rdup_int (old -> Part_range.last);
	break;
      default:
	dcg_bad_tag (old -> tag, "rdup_cset_part");
    };
  return (new);
}

/* Recursively duplicate a cset */
cset rdup_cset (cset old)
{ /* allocate new record */
  cset new;
  if (old == cset_nil) return (old);
  new = (cset) dcg_malloc (sizeof (struct str_cset));

  /* duplicate fixed fields before variant ones */
  new -> invert = rdup_int (old -> invert);
  new -> parts = rdup_cset_part_list (old -> parts);
  return (new);
}

/* Recursively duplicate a terminal */
terminal rdup_terminal (terminal old)
{ /* allocate new record */
  terminal new;
  if (old == terminal_nil) return (old);
  new = (terminal) dcg_malloc (sizeof (struct str_terminal));

  /* duplicate fixed fields before variant ones */
  new -> marker = rdup_int (old -> marker);
  new -> text = rdup_int_list (old -> text);
  new -> origin = rdup_string (old -> origin);
  return (new);
}

/* Recursively duplicate a nfa_state */
nfa_state rdup_nfa_state (nfa_state old)
{ /* allocate new record */
  nfa_state new;
  if (old == nfa_state_nil) return (old);
  new = (nfa_state) dcg_malloc (sizeof (struct str_nfa_state));

  /* duplicate fixed fields before variant ones */
  new -> self = rdup_int (old -> self);
  new -> final = rdup_int (old -> final);
  new -> transitions = rdup_nfa_trans_list (old -> transitions);
  return (new);
}

/* Recursively duplicate a nfa_trans */
nfa_trans rdup_nfa_trans (nfa_trans old)
{ /* allocate new record */
  nfa_trans new;
  if (old == nfa_trans_nil) return (old);
  new = (nfa_trans) dcg_malloc (sizeof (struct str_nfa_trans));

  /* duplicate fixed fields before variant ones */
  new -> dest = rdup_int (old -> dest);
  new -> tag = old -> tag;
  switch (old -> tag)
    { case TAGTrans_char:
	new -> Trans_char.ch = rdup_int (old -> Trans_char.ch);
	break;
      case TAGTrans_cset:
	new -> Trans_cset.cs = rdup_int (old -> Trans_cset.cs);
	break;
      case TAGTrans_anychar:
	break;
      case TAGTrans_whitespace:
	break;
      case TAGTrans_nonwhitespace:
	break;
      case TAGTrans_empty:
	break;
      default:
	dcg_bad_tag (old -> tag, "rdup_nfa_trans");
    };
  return (new);
}

/* Recursively duplicate a nfa */
nfa rdup_nfa (nfa old)
{ /* allocate new record */
  nfa new;
  if (old == nfa_nil) return (old);
  new = (nfa) dcg_malloc (sizeof (struct str_nfa));

  /* duplicate fixed fields before variant ones */
  new -> kind = rdup_int (old -> kind);
  new -> marker = rdup_int (old -> marker);
  new -> origin = rdup_string (old -> origin);
  new -> states = rdup_nfa_state_list (old -> states);
  return (new);
}

/* Recursively duplicate a lex_nont */
lex_nont rdup_lex_nont (lex_nont old)
{ /* allocate new record */
  lex_nont new;
  if (old == lex_nont_nil) return (old);
  new = (lex_nont) dcg_malloc (sizeof (struct str_lex_nont));

  /* duplicate fixed fields before variant ones */
  new -> rule_nr = rdup_int (old -> rule_nr);
  new -> fact_nr = rdup_int (old -> fact_nr);
  new -> name_parts = rdup_string_list (old -> name_parts);
  new -> name_chars = rdup_int_list (old -> name_chars);
  new -> ncrits = rdup_int (old -> ncrits);
  new -> formals = rdup_int_list (old -> formals);
  new -> crits = rdup_int_list (old -> crits);
  return (new);
}

/* Recursively duplicate a rt_nont */
rt_nont rdup_rt_nont (rt_nont old)
{ /* allocate new record */
  rt_nont new;
  if (old == rt_nont_nil) return (old);
  new = (rt_nont) dcg_malloc (sizeof (struct str_rt_nont));

  /* duplicate fixed fields before variant ones */
  new -> name_parts = rdup_string_list (old -> name_parts);
  new -> name_chars = rdup_int_list (old -> name_chars);
  new -> canonic_name = rdup_string (old -> canonic_name);
  new -> formals = rdup_int_list (old -> formals);
  new -> lex_nr = rdup_int (old -> lex_nr);
  return (new);
}

/* Recursively duplicate a ext_nont */
ext_nont rdup_ext_nont (ext_nont old)
{ /* allocate new record */
  ext_nont new;
  if (old == ext_nont_nil) return (old);
  new = (ext_nont) dcg_malloc (sizeof (struct str_ext_nont));

  /* duplicate fixed fields before variant ones */
  new -> canonic_name = rdup_string (old -> canonic_name);
  new -> rule_nr = rdup_int (old -> rule_nr);
  return (new);
}

/* Recursively duplicate a director_set */
director_set rdup_director_set (director_set old)
{ /* allocate new record */
  director_set new;
  if (old == director_set_nil) return (old);
  new = (director_set) dcg_malloc (sizeof (struct str_director_set));

  /* duplicate fixed fields before variant ones */
  new -> min_phase = rdup_int (old -> min_phase);
  new -> set = rdup_trans_pair_list (old -> set);
  return (new);
}

/* Recursively duplicate a trans_pair */
trans_pair rdup_trans_pair (trans_pair old)
{ /* allocate new record */
  trans_pair new;
  if (old == trans_pair_nil) return (old);
  new = (trans_pair) dcg_malloc (sizeof (struct str_trans_pair));

  /* duplicate fixed fields before variant ones */
  new -> class = rdup_int (old -> class);
  new -> number = rdup_int (old -> number);
  return (new);
}

/* Recursively duplicate a affix_value_list */
affix_value_list rdup_affix_value_list (affix_value_list old)
{ affix_value_list new;
  int ix;
  if (old == affix_value_list_nil) return (old);
  new = init_affix_value_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_affix_value_list (new, rdup_affix_value (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a rt_element_list */
rt_element_list rdup_rt_element_list (rt_element_list old)
{ rt_element_list new;
  int ix;
  if (old == rt_element_list_nil) return (old);
  new = init_rt_element_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_rt_element_list (new, rdup_rt_element (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a rt_domain_list */
rt_domain_list rdup_rt_domain_list (rt_domain_list old)
{ rt_domain_list new;
  int ix;
  if (old == rt_domain_list_nil) return (old);
  new = init_rt_domain_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_rt_domain_list (new, rdup_rt_domain (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a rt_elem_list */
rt_elem_list rdup_rt_elem_list (rt_elem_list old)
{ rt_elem_list new;
  int ix;
  if (old == rt_elem_list_nil) return (old);
  new = init_rt_elem_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_rt_elem_list (new, rdup_rt_elem (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a rt_alt_list */
rt_alt_list rdup_rt_alt_list (rt_alt_list old)
{ rt_alt_list new;
  int ix;
  if (old == rt_alt_list_nil) return (old);
  new = init_rt_alt_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_rt_alt_list (new, rdup_rt_alt (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a rt_type_list */
rt_type_list rdup_rt_type_list (rt_type_list old)
{ rt_type_list new;
  int ix;
  if (old == rt_type_list_nil) return (old);
  new = init_rt_type_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_rt_type_list (new, rdup_rt_type (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a cset_part_list */
cset_part_list rdup_cset_part_list (cset_part_list old)
{ cset_part_list new;
  int ix;
  if (old == cset_part_list_nil) return (old);
  new = init_cset_part_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_cset_part_list (new, rdup_cset_part (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a cset_list */
cset_list rdup_cset_list (cset_list old)
{ cset_list new;
  int ix;
  if (old == cset_list_nil) return (old);
  new = init_cset_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_cset_list (new, rdup_cset (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a terminal_list */
terminal_list rdup_terminal_list (terminal_list old)
{ terminal_list new;
  int ix;
  if (old == terminal_list_nil) return (old);
  new = init_terminal_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_terminal_list (new, rdup_terminal (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a nfa_state_list */
nfa_state_list rdup_nfa_state_list (nfa_state_list old)
{ nfa_state_list new;
  int ix;
  if (old == nfa_state_list_nil) return (old);
  new = init_nfa_state_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_nfa_state_list (new, rdup_nfa_state (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a nfa_trans_list */
nfa_trans_list rdup_nfa_trans_list (nfa_trans_list old)
{ nfa_trans_list new;
  int ix;
  if (old == nfa_trans_list_nil) return (old);
  new = init_nfa_trans_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_nfa_trans_list (new, rdup_nfa_trans (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a nfa_list */
nfa_list rdup_nfa_list (nfa_list old)
{ nfa_list new;
  int ix;
  if (old == nfa_list_nil) return (old);
  new = init_nfa_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_nfa_list (new, rdup_nfa (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a lex_nont_list */
lex_nont_list rdup_lex_nont_list (lex_nont_list old)
{ lex_nont_list new;
  int ix;
  if (old == lex_nont_list_nil) return (old);
  new = init_lex_nont_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_lex_nont_list (new, rdup_lex_nont (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a rt_nont_list */
rt_nont_list rdup_rt_nont_list (rt_nont_list old)
{ rt_nont_list new;
  int ix;
  if (old == rt_nont_list_nil) return (old);
  new = init_rt_nont_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_rt_nont_list (new, rdup_rt_nont (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a ext_nont_list */
ext_nont_list rdup_ext_nont_list (ext_nont_list old)
{ ext_nont_list new;
  int ix;
  if (old == ext_nont_list_nil) return (old);
  new = init_ext_nont_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_ext_nont_list (new, rdup_ext_nont (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a trans_pair_list */
trans_pair_list rdup_trans_pair_list (trans_pair_list old)
{ trans_pair_list new;
  int ix;
  if (old == trans_pair_list_nil) return (old);
  new = init_trans_pair_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_trans_pair_list (new, rdup_trans_pair (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a int_list_list */
int_list_list rdup_int_list_list (int_list_list old)
{ int_list_list new;
  int ix;
  if (old == int_list_list_nil) return (old);
  new = init_int_list_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_int_list_list (new, rdup_int_list (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a u_int64_list */
u_int64_list rdup_u_int64_list (u_int64_list old)
{ u_int64_list new;
  int ix;
  if (old == u_int64_list_nil) return (old);
  new = init_u_int64_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_u_int64_list (new, rdup_u_int64 (old -> array[ix]));
  return (new);
}

/* Recursively check the ref counts of a affix_value */
void check_not_freed_affix_value (affix_value curr)
{ if (curr == affix_value_nil) return;
  check_not_freed_int (curr -> rule_nr);
  switch (curr -> tag)
    { case TAGNull_value:
	break;
      case TAGText_value:
	check_not_freed_string (curr -> Text_value.text);
	break;
      case TAGInt_value:
	check_not_freed_int (curr -> Int_value.ival);
	break;
      case TAGReal_value:
	check_not_freed_real (curr -> Real_value.rval);
	break;
      case TAGSmall_lattice:
	check_not_freed_int (curr -> Small_lattice.dom);
	check_not_freed_u_int64 (curr -> Small_lattice.slat);
	break;
      case TAGLarge_lattice:
	check_not_freed_int (curr -> Large_lattice.dom);
	check_not_freed_u_int64_list (curr -> Large_lattice.llat);
	break;
      case TAGList_lattice:
	check_not_freed_int_list (curr -> List_lattice.llat);
	break;
      case TAGComposed_value:
	check_not_freed_int (curr -> Composed_value.marker);
	check_not_freed_affix_value_list (curr -> Composed_value.parts);
	break;
      default:
	dcg_bad_tag (curr -> tag, "check_not_freed_affix_value");
    };
}

/* Recursively check the ref counts of a rt_element */
void check_not_freed_rt_element (rt_element curr)
{ if (curr == rt_element_nil) return;
  check_not_freed_string (curr -> name);
  check_not_freed_affix_value (curr -> value);
}

/* Recursively check the ref counts of a rt_domain */
void check_not_freed_rt_domain (rt_domain curr)
{ if (curr == rt_domain_nil) return;
  check_not_freed_int (curr -> width);
  check_not_freed_rt_element_list (curr -> elts);
}

/* Recursively check the ref counts of a rt_elem */
void check_not_freed_rt_elem (rt_elem curr)
{ if (curr == rt_elem_nil) return;
  switch (curr -> tag)
    { case TAGMarker:
	check_not_freed_string (curr -> Marker.txt);
	break;
      case TAGRef:
	check_not_freed_int (curr -> Ref.rnr);
	break;
      default:
	dcg_bad_tag (curr -> tag, "check_not_freed_rt_elem");
    };
}

/* Recursively check the ref counts of a rt_alt */
void check_not_freed_rt_alt (rt_alt curr)
{ if (curr == rt_alt_nil) return;
  check_not_freed_int (curr -> marker);
  check_not_freed_rt_elem_list (curr -> elems);
}

/* Recursively check the ref counts of a rt_type */
void check_not_freed_rt_type (rt_type curr)
{ if (curr == rt_type_nil) return;
  check_not_freed_int (curr -> rule_nr);
  check_not_freed_string (curr -> name);
  check_not_freed_int (curr -> lexgen);
  check_not_freed_affix_value (curr -> value);
  switch (curr -> tag)
    { case TAGSynonym_type:
	check_not_freed_int (curr -> Synonym_type.snr);
	break;
      case TAGAny_type:
	break;
      case TAGInt_type:
	break;
      case TAGReal_type:
	break;
      case TAGText_type:
	break;
      case TAGLattice_type:
	check_not_freed_int (curr -> Lattice_type.dom);
	break;
      case TAGTree_type:
	check_not_freed_rt_alt_list (curr -> Tree_type.alts);
	break;
      default:
	dcg_bad_tag (curr -> tag, "check_not_freed_rt_type");
    };
}

/* Recursively check the ref counts of a cset_part */
void check_not_freed_cset_part (cset_part curr)
{ if (curr == cset_part_nil) return;
  switch (curr -> tag)
    { case TAGPart_match:
	check_not_freed_int (curr -> Part_match.ch);
	break;
      case TAGPart_range:
	check_not_freed_int (curr -> Part_range.first);
	check_not_freed_int (curr -> Part_range.last);
	break;
      default:
	dcg_bad_tag (curr -> tag, "check_not_freed_cset_part");
    };
}

/* Recursively check the ref counts of a cset */
void check_not_freed_cset (cset curr)
{ if (curr == cset_nil) return;
  check_not_freed_int (curr -> invert);
  check_not_freed_cset_part_list (curr -> parts);
}

/* Recursively check the ref counts of a terminal */
void check_not_freed_terminal (terminal curr)
{ if (curr == terminal_nil) return;
  check_not_freed_int (curr -> marker);
  check_not_freed_int_list (curr -> text);
  check_not_freed_string (curr -> origin);
}

/* Recursively check the ref counts of a nfa_state */
void check_not_freed_nfa_state (nfa_state curr)
{ if (curr == nfa_state_nil) return;
  check_not_freed_int (curr -> self);
  check_not_freed_int (curr -> final);
  check_not_freed_nfa_trans_list (curr -> transitions);
}

/* Recursively check the ref counts of a nfa_trans */
void check_not_freed_nfa_trans (nfa_trans curr)
{ if (curr == nfa_trans_nil) return;
  check_not_freed_int (curr -> dest);
  switch (curr -> tag)
    { case TAGTrans_char:
	check_not_freed_int (curr -> Trans_char.ch);
	break;
      case TAGTrans_cset:
	check_not_freed_int (curr -> Trans_cset.cs);
	break;
      case TAGTrans_anychar:
	break;
      case TAGTrans_whitespace:
	break;
      case TAGTrans_nonwhitespace:
	break;
      case TAGTrans_empty:
	break;
      default:
	dcg_bad_tag (curr -> tag, "check_not_freed_nfa_trans");
    };
}

/* Recursively check the ref counts of a nfa */
void check_not_freed_nfa (nfa curr)
{ if (curr == nfa_nil) return;
  check_not_freed_int (curr -> kind);
  check_not_freed_int (curr -> marker);
  check_not_freed_string (curr -> origin);
  check_not_freed_nfa_state_list (curr -> states);
}

/* Recursively check the ref counts of a lex_nont */
void check_not_freed_lex_nont (lex_nont curr)
{ if (curr == lex_nont_nil) return;
  check_not_freed_int (curr -> rule_nr);
  check_not_freed_int (curr -> fact_nr);
  check_not_freed_string_list (curr -> name_parts);
  check_not_freed_int_list (curr -> name_chars);
  check_not_freed_int (curr -> ncrits);
  check_not_freed_int_list (curr -> formals);
  check_not_freed_int_list (curr -> crits);
}

/* Recursively check the ref counts of a rt_nont */
void check_not_freed_rt_nont (rt_nont curr)
{ if (curr == rt_nont_nil) return;
  check_not_freed_string_list (curr -> name_parts);
  check_not_freed_int_list (curr -> name_chars);
  check_not_freed_string (curr -> canonic_name);
  check_not_freed_int_list (curr -> formals);
  check_not_freed_int (curr -> lex_nr);
}

/* Recursively check the ref counts of a ext_nont */
void check_not_freed_ext_nont (ext_nont curr)
{ if (curr == ext_nont_nil) return;
  check_not_freed_string (curr -> canonic_name);
  check_not_freed_int (curr -> rule_nr);
}

/* Recursively check the ref counts of a director_set */
void check_not_freed_director_set (director_set curr)
{ if (curr == director_set_nil) return;
  check_not_freed_int (curr -> min_phase);
  check_not_freed_trans_pair_list (curr -> set);
}

/* Recursively check the ref counts of a trans_pair */
void check_not_freed_trans_pair (trans_pair curr)
{ if (curr == trans_pair_nil) return;
  check_not_freed_int (curr -> class);
  check_not_freed_int (curr -> number);
}

/* Recursively check the refcounts of a affix_value_list */
void check_not_freed_affix_value_list (affix_value_list curr)
{ int ix;
  if (curr == affix_value_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_affix_value (curr -> array[ix]);
}

/* Recursively check the refcounts of a rt_element_list */
void check_not_freed_rt_element_list (rt_element_list curr)
{ int ix;
  if (curr == rt_element_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_rt_element (curr -> array[ix]);
}

/* Recursively check the refcounts of a rt_domain_list */
void check_not_freed_rt_domain_list (rt_domain_list curr)
{ int ix;
  if (curr == rt_domain_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_rt_domain (curr -> array[ix]);
}

/* Recursively check the refcounts of a rt_elem_list */
void check_not_freed_rt_elem_list (rt_elem_list curr)
{ int ix;
  if (curr == rt_elem_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_rt_elem (curr -> array[ix]);
}

/* Recursively check the refcounts of a rt_alt_list */
void check_not_freed_rt_alt_list (rt_alt_list curr)
{ int ix;
  if (curr == rt_alt_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_rt_alt (curr -> array[ix]);
}

/* Recursively check the refcounts of a rt_type_list */
void check_not_freed_rt_type_list (rt_type_list curr)
{ int ix;
  if (curr == rt_type_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_rt_type (curr -> array[ix]);
}

/* Recursively check the refcounts of a cset_part_list */
void check_not_freed_cset_part_list (cset_part_list curr)
{ int ix;
  if (curr == cset_part_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_cset_part (curr -> array[ix]);
}

/* Recursively check the refcounts of a cset_list */
void check_not_freed_cset_list (cset_list curr)
{ int ix;
  if (curr == cset_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_cset (curr -> array[ix]);
}

/* Recursively check the refcounts of a terminal_list */
void check_not_freed_terminal_list (terminal_list curr)
{ int ix;
  if (curr == terminal_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_terminal (curr -> array[ix]);
}

/* Recursively check the refcounts of a nfa_state_list */
void check_not_freed_nfa_state_list (nfa_state_list curr)
{ int ix;
  if (curr == nfa_state_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_nfa_state (curr -> array[ix]);
}

/* Recursively check the refcounts of a nfa_trans_list */
void check_not_freed_nfa_trans_list (nfa_trans_list curr)
{ int ix;
  if (curr == nfa_trans_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_nfa_trans (curr -> array[ix]);
}

/* Recursively check the refcounts of a nfa_list */
void check_not_freed_nfa_list (nfa_list curr)
{ int ix;
  if (curr == nfa_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_nfa (curr -> array[ix]);
}

/* Recursively check the refcounts of a lex_nont_list */
void check_not_freed_lex_nont_list (lex_nont_list curr)
{ int ix;
  if (curr == lex_nont_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_lex_nont (curr -> array[ix]);
}

/* Recursively check the refcounts of a rt_nont_list */
void check_not_freed_rt_nont_list (rt_nont_list curr)
{ int ix;
  if (curr == rt_nont_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_rt_nont (curr -> array[ix]);
}

/* Recursively check the refcounts of a ext_nont_list */
void check_not_freed_ext_nont_list (ext_nont_list curr)
{ int ix;
  if (curr == ext_nont_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_ext_nont (curr -> array[ix]);
}

/* Recursively check the refcounts of a trans_pair_list */
void check_not_freed_trans_pair_list (trans_pair_list curr)
{ int ix;
  if (curr == trans_pair_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_trans_pair (curr -> array[ix]);
}

/* Recursively check the refcounts of a int_list_list */
void check_not_freed_int_list_list (int_list_list curr)
{ int ix;
  if (curr == int_list_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_int_list (curr -> array[ix]);
}

/* Recursively check the refcounts of a u_int64_list */
void check_not_freed_u_int64_list (u_int64_list curr)
{ int ix;
  if (curr == u_int64_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_u_int64 (curr -> array[ix]);
}

