/*
   File: ebase_affix_value_utils.h
   Utilities for affix value calculations

   Copyright (C) 2012 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: ebase_affix_value_utils.h,v 1.6 2012/09/21 13:44:01 marcs Exp $
*/
#ifndef IncEbaseAffixValueUtils
#define IncEbaseAffixValueUtils

affix_value ebs_evaluate_dyadic_operation (operator dop, affix_value val1, affix_value val2);
affix_value ebs_evaluate_monadic_operation (operator mop, affix_value val1);
affix_value ebs_concatenate_text_values (affix_value_list vals);
affix_value ebs_replicate_text_value (affix_value val1, affix_value val2);
affix_value ebs_join_lattice_values (affix_value_list vals);
int ebs_meet_lattice_values (affix_value val1, affix_value val2, affix_value *resval);
int ebs_diff_lattice_values (affix_value val1, affix_value val2, affix_value *resval);
int ebs_lattice_value_is_subset (affix_value val1, affix_value val2);

#endif /* IncEbaseAffixValueUtils */
