/*
   File: globals.h
   Defines the global variables of the eag3 lexicon generator

   Copyright (C) 2012 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: globals.h,v 1.16 2012/07/28 20:02:48 marcs Exp $"
*/
#ifndef IncGlobals
#define IncGlobals

/* libdcg includes */
#include <dcg.h>
#include <dcg_string.h>
#include <dcg_plist.h>

/* libeagbase includes */
#include <ebase_ds.h>
#include <ebase_vocabulary.h>

/* Pragmats and flags */
extern int hyphen_convention_active;
extern int hybrid_parsing;
extern int utf8_processing;
extern int translate_option;
extern int empty_white_space_option;
extern string translate_fname;
extern int_list white_spaces;
extern int_list separators;
extern int_list translation_sources;
extern int_list translation_targets;
extern int_list translation_penalties;

/* Suffixes for various kinds of files */
#define BLX_SUFFIX "blx"
#define INFO_SUFFIX "info"
#define BLI_SUFFIX "bli"
#define DAT_SUFFIX "dat"
#define FCT_SUFFIX "fct"
#define TRP_SUFFIX "trp"

/* exported files to be read */
extern string_list all_lexica;
extern string_list all_fact_tables;
extern string_list all_triple_databases;

/* Imported runtime info */
extern rt_domain_list all_rt_domains;
extern rt_type_list all_rt_types;

/* Imported terminals, nonterminals and facts */
extern int nr_facts;
extern lex_nont_list all_lex_nonts;
extern terminal_list all_terminals;
extern string_list all_terminal_texts;

/* Imported character sets and regexp nfas */
extern cset_list all_csets;
extern nfa_list all_regexp_nfas;

/* Collection of all used actual affix values */
extern affix_value_list all_actuals;

/* Collection of all critical affixes */
extern Vocabulary critical_text_vocabulary;
extern string_list all_critical_texts;

/* Collection of all calls */
extern int_list_list all_calls;

/* All entry lists */
extern int nr_entries;
extern int_list_list all_entry_lists;

/* All lexicon vocabularies */
#define MAX_MARKERS 16
extern Vocabulary all_vocabularies[MAX_MARKERS];

/* All fact tables */
extern int_list_list *all_compiled_fact_tables;
extern int_list fact_nr_to_lex_nont_nr;

/* Prepare globals for parsing */
void prepare_globals ();

#endif /* IncGlobals */
