/*
   File: globals.c
   Defines the global variables of the eag3 lexicon generator

   Copyright (C) 2012 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: globals.c,v 1.17 2012/07/28 20:02:48 marcs Exp $"
*/

/* libdcg includes */
#include <dcg.h>
#include <dcg_alloc.h>
#include <dcg_arith.h>
#include <dcg_string.h>

/* libeagbase includes */
#include <ebase_ds.h>
#include <ebase_vocabulary.h>

/* local includes */
#include "globals.h"
#include "options.h"

/* Files to be processed */
string_list all_lexica;
string_list all_fact_tables;
string_list all_triple_databases;

/* Imported pragmats and flags */
int hyphen_convention_active;
int hybrid_parsing;
int utf8_processing;
int translate_option;
int empty_white_space_option;
string translate_fname;
int_list white_spaces;
int_list separators;
int_list translation_sources;
int_list translation_targets;
int_list translation_penalties;

/* Imported runtime info */
rt_domain_list all_rt_domains;
rt_type_list all_rt_types;

/* Imported terminals, nonterminals and facts */
int nr_facts;
terminal_list all_terminals;
lex_nont_list all_lex_nonts;
string_list all_terminal_texts;

/* Imported character sets and regexp nfas */
cset_list all_csets;
nfa_list all_regexp_nfas;

/* Collection of all actual affix values */
affix_value_list all_actuals;

/* Collection of all critical affixes */
Vocabulary critical_text_vocabulary;
string_list all_critical_texts;

/* Collection of all calls */
int_list_list all_calls;

/* All entry lists */
int nr_entries;
int_list_list all_entry_lists;

/* All lexicon vocabularies */
Vocabulary all_vocabularies[MAX_MARKERS];

/* All compiled fact tables */
int_list_list *all_compiled_fact_tables;
int_list fact_nr_to_lex_nont_nr;

/* Initialize for parsing */
#define DEFAULT_NR_TRANSLATIONS 32
void prepare_globals ()
{ int my_nr_of_facts = nr_facts + hybrid_parsing;
  int ix, iy;
  all_terminal_texts = init_string_list (all_terminals -> size);
  all_actuals = init_affix_value_list (affix_hash_size);
  critical_text_vocabulary = ebs_new_vocabulary (my_default_pool);
  all_critical_texts = init_string_list (fact_hash_size);
  app_string_list (all_critical_texts, new_string (""));
  all_calls = init_int_list_list (call_hash_size);
  for (ix = 0; ix < MAX_MARKERS; ix++)
    all_vocabularies[ix] = vocabulary_nil;
  nr_entries = 0;
  all_entry_lists = init_int_list_list (call_hash_size);	/* maybe more */
  app_int_list_list (all_entry_lists, new_int_list ());		/* dummy 0 entry */
  all_compiled_fact_tables = dcg_calloc (max (my_nr_of_facts, 1), sizeof (int_list_list));
  fact_nr_to_lex_nont_nr = init_int_list (nr_facts);
  for (ix = 0; ix < my_nr_of_facts; ix++)
    { all_compiled_fact_tables[ix] = init_int_list_list (fact_hash_size);
      for (iy = 0; iy < fact_hash_size; iy++)
	app_int_list_list (all_compiled_fact_tables[ix], int_list_nil);
    };
  translation_sources = init_int_list (DEFAULT_NR_TRANSLATIONS);
  translation_targets = init_int_list (DEFAULT_NR_TRANSLATIONS);
  translation_penalties = init_int_list (DEFAULT_NR_TRANSLATIONS);
}
