/*
   File: entries.h
   Collects all lexicon and fact entries

   Copyright (C) 2012 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: entries.h,v 1.4 2012/05/30 14:22:53 marcs Exp $"
*/
#ifndef IncEntries
#define IncEntries

/* standard includes */
#include <stdio.h>

/* libdcg includes */
#include <dcg.h>

void prepare_facts ();
int *enter_into_lexicon (char *lexeme, int lexeme_marker);
int *enter_into_fact_table (int fact_nr, int_list crits);
void register_new_entry (int *info_ptr, int call_id, int freq);
char *convert_terminal_to_lexeme (int_list text);

#endif /* IncEntries */
