/*
   File: runtime_info.c
   Collects the information that needs to be forwarded to the runtime system
   Also does some preparations for the code generators.

   Copyright (C) 2012 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: runtime_info.c,v 1.6 2012/12/26 15:43:08 marcs Exp $"
*/

/* standard includes */
#include <stdio.h>

/* libdcg includes */
#include <dcg.h>
#include <dcg_error.h>

/* libeagbase includes */
#include <ebase_version.h>

/* Local includes */
#include "eag_ds.h"
#include "options.h"
#include "globals.h"
#include "affix_rules.h"
#include "runtime_info.h"

static int_list collect_rt_formals (affix_rule_list sig)
{ int_list rt_formals = init_int_list (sig -> size);
  int ix;
  for (ix = 0; ix < sig -> size; ix++)
    app_int_list (rt_formals, sig -> array[ix] -> anr);
  return (rt_formals);
}

static void collect_runtime_nonterminals ()
{ int ix;
  for (ix = 0; ix < all_syntax_rules -> size; ix++)
    { rule srule = all_syntax_rules -> array[ix];
      spec rspec = srule -> rspec;
      int_list rt_formals = collect_rt_formals (rspec -> rsig);
      rt_nont rnont = new_rt_nont (attach_string_list (rspec -> rname_parts),
				   attach_int_list (rspec -> rname_chars),
				   attach_string (rspec -> canonic_name),
				   rt_formals, rspec -> lnr);
      app_rt_nont_list (all_rt_nonts, rnont);

      /* Mark if we want to code this rule at all */
      if (!srule -> reachable) continue;
      if (srule -> tag == TAGExt_rule)
	{ ext_nont et = new_ext_nont (attach_string (rspec -> canonic_name), ix);
	  app_ext_nont_list (all_ext_nonts, et);
	  continue;
	};

      if (rspec -> rkind != r_normal) continue;	/* others: lexicon, fact, external */
      srule -> codable = 1;
    };
}

void collect_runtime_info ()
{ collect_runtime_nonterminals ();
  dcg_warning (0, "   collecting runtime information...");
}
