/*
   File: rules.h
   Checks the syntax rules

   Copyright (C) 2011 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: rules.h,v 1.4 2011/09/28 13:09:08 marcs Exp $"
*/
#ifndef IncRules
#define IncRules

/* standard includes */
#include <stdio.h>

/* libdcg includes */
#include <dcg.h>
#include <dcg_alloc.h>
#include <dcg_string.h>

/* local includes */
#include "eag_ds.h"

/* Exported functions */
rdecl_list pre_identify_rule (string_list rname_parts, int arity);
rdecl_list pre_identify_quasi_rule (string_list rname_parts, int arity);
rule make_anonymous_rule (definition def, group grp, int option);
void analyze_rules ();

#endif /* IncRules */
