/*
   File: rule_tree.c
   Defines a symbol table for syntax rules implemented as a binary tree.

   Copyright (C) 2008-2011 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: rule_tree.c,v 1.5 2011/09/21 09:39:20 marcs Exp $"
*/

/* standard includes */
#include <stdio.h>
#include <string.h>

/* support lib includes */
#include <dcg.h>
#include <dcg_alloc.h>
#include <dcg_string.h>
#include <dcg_dump.h>
#include <dcg_plist.h>

/* local includes */
#include "eag_ds.h"
#include "rule_tree.h"

/* introduce necessary routines and shorthands */
void detach_rule_tree (rule_tree *optr)
{ rule_tree old = (rule_tree) dcg_predetach ((void **) optr);
  if (old == rule_tree_nil) return;
  detach_string_list (&old -> tag);
  detach_rdecl_list (&old -> rdefs);
  detach_rule_tree (&old -> left);
  detach_rule_tree (&old -> right);
  dcg_detach ((void **) &old);
};

/* supplementary routines and shorthands */
static void my_ppp_rule_tree (FILE *f, int ind, rule_tree old)
{ if (old == rule_tree_nil) return;
  my_ppp_rule_tree (f, ind + 2, old -> left);
  pppdelim (f, 0, ind, '<');
  ppp_string_list (f, 1, ind + 2, old -> tag);
  pppdelim (f, 0, ind, '/');
  ppp_int (f, 1, ind + 2, old -> arity);
  pppdelim (f, 0, ind, ',');
  ppp_rdecl_list (f, 0, ind + 2, old -> rdefs);
  pppdelim (f, 0, ind, '>');
  my_ppp_rule_tree (f, ind + 2, old -> right);
};

void ppp_rule_tree (FILE *f, int horiz, int ind, rule_tree old)
{ pppdelim (f, 0, ind, '{');
  my_ppp_rule_tree (f, ind + 2, old);
  pppdelim (f, 0, ind, '}');
};

void save_rule_tree (FILE *f, rule_tree old)
{
};

int load_rule_tree (FILE *f, rule_tree *x)
{ return (0);
};

/* specific routines and shorthands */
rdecl_list enter_rule_tree (rule_tree *root, string_list tag, int arity)
{ rule_tree *ptr = root;
  rule_tree new_rt;
  while (*ptr != rule_tree_nil)
    { rule_tree current = *ptr;
      int cond = cmp_string_list (tag, current -> tag);
      if (cond < 0) ptr = &current -> left;
      else if (cond > 0) ptr = &current -> right;
      else if (arity < current -> arity) ptr = &current -> left;
      else if (arity > current -> arity) ptr = &current -> right;
      else
	/* Found combination of tag parts and arity */
	return (current -> rdefs);
    };

  new_rt = (rule_tree) dcg_malloc (sizeof (struct rule_tree_rec));
  new_rt -> tag = attach_string_list (tag);
  new_rt -> arity = arity;
  new_rt -> rdefs = new_rdecl_list ();
  new_rt -> left = rule_tree_nil;
  new_rt -> right = rule_tree_nil;
  *ptr = new_rt;
  return (new_rt -> rdefs);
};

rdecl_list lookup_rule_tree (rule_tree root, string_list tag, int arity)
{ rule_tree ptr = root;
  while (ptr != rule_tree_nil)
    { int cond = cmp_string_list (tag, ptr -> tag);
      if (cond < 0) ptr = ptr -> left;
      else if (cond > 0) ptr = ptr -> right;
      else if (arity < ptr -> arity) ptr = ptr -> left;
      else if (arity > ptr -> arity) ptr = ptr -> right;
      else
	/* Found combination of tag parts and arity */
	return (ptr -> rdefs);
    };
  return (rdecl_list_nil);
};
