/*
   File: main.c
   Driver for eag3 compiler

   Copyright (C) 2008 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: main.c,v 1.13 2012/12/26 15:43:07 marcs Exp $"
*/

/* global includes */
#include <stdio.h>

/* libdcg includes */
#include <dcg.h>
#include <dcg_error.h>
#include <dcg_alloc.h>

/* local includes */
#include "eag_ds.h"
#include "globals.h"
#include "options.h"
#include "contfree.h"
#include "contsens.h"
#include "properties.h"
#include "bli_writer.h"
#include "rti_writer.h"
#include "coder.h"
#include "backend.h"

static void init_eag3_compiler ()
{ dcg_init_error (stderr, "eag3-compile", NULL);
  dcg_init_alloc ("eag3-compile", 0);
  init_options ();
  init_globals ();
}

static void compile_source ()
{ context_free_analysis ();
  context_sensitive_analysis ();
  calculate_properties ();
  generate_c_code ();
  compile_c_and_link ();
  write_lexgen_interface_file ();
  write_runtime_information_file ();
}

int main (int argc, char **argv)
{ init_eag3_compiler ();
  parse_command_line (argc, argv);
  compile_source ();
  return (0);
}
