/*
   File: lexemes.h
   Checks lexemes and other input related stuff

   Copyright (C) 2011 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: lexemes.h,v 1.7 2012/06/18 19:55:12 marcs Exp $"
*/
#ifndef IncLexemes
#define IncLexemes

/* standard includes */
#include <stdio.h>

/* libdcg includes */
#include <dcg.h>

void prepare_lexeme_gathering ();

/* For the moment */
void analyze_lexeme (int gnr, int line, int col, int rflag, char *text, int longest,
		     int *termnr, int *is_regexp, nullability *empty);
char *normalize_text_constant (char *text, int *warn);
void try_dump_lexemes ();

#endif /* IncLexemes */
