/*
   File: lattices.h
   Analyzes lattice construction and calculates the final superdomains

   Copyright (C) 2011 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: lattices.h,v 1.8 2011/11/18 20:46:27 marcs Exp $"
*/
#ifndef IncLattices
#define IncLattices

/* standard includes */
#include <stdio.h>

/* libdcg includes */
#include <dcg.h>
#include <dcg_string.h>

/* local includes */
#include "eag_ds.h"

/* Pass 1: analysis of the affix rules */
void analyze_lattices_in_affix_rules ();

/* Identification in rules */
element identify_lattice_element (string name);
int element_in_affix_rule (element elt, affix_rule arule);
int subset_of_affix_rule (affix_rule subset, affix_rule arule);
int non_empty_intersection (affix_rule arule1, affix_rule arule2);
void add_element_to_interference_matrix (element elt, affix_rule arule);
void add_arule_to_interference_matrix (affix_rule arule1, affix_rule arule2);

/* Pass 2: construction of the domains by graph coloring */
void construct_lattices ();

#endif /* IncLattices */
