/*
   File: modules.h
   Maintains and checks the list of all modules.

   Copyright (C) 2008-2010 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: grammars.h,v 1.4 2012/11/28 14:41:50 marcs Exp $"
*/
#ifndef IncGrammars
#define IncGrammars

/* standard includes */
#include <stdio.h>

/* libdcg includes */
#include <dcg.h>
#include <dcg_alloc.h>
#include <dcg_string.h>

/* local includes */
#include "eag_ds.h"

/* The name of the predefines grammar is predef.eag */
#define PREDEF_NAME "predef"

/* Module addition and lookup */
void register_grammar (grammar gra);
grammar identify_grammar (string gname);

/* Check for root rules */
void pre_analyze_grammars ();
void dump_grammars ();

#endif /* IncGrammars */
