/*
   File: expr.h
   Checks affix expressions in a simple way.

   Copyright (C) 2011 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: expr.h,v 1.4 2012/08/18 16:14:57 marcs Exp $"
*/
#ifndef IncExpr
#define IncExpr

/* standard includes */
#include <stdio.h>

/* libdcg includes */
#include <dcg.h>
#include <dcg_alloc.h>
#include <dcg_string.h>

/* local includes */
#include "eag_ds.h"

/* Checking of expressions */
int is_an_affix_variable (affix_term term);
int is_a_single_affix_variable (affix_term_list terms);
affix_rule check_affix_variable (definition d, affix_term term);
arule_kind check_expr (definition d, affix_term_list terms);
variable_list duplicate_locals (variable_list locals);
affix_term_list remap_expr (affix_term_list terms, variable_list new_locals);

#endif /* IncExpr */
