/*
   File: contsens.h
   Does context dependent analysis

   Copyright (C) 2009 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: contsens.h,v 1.1 2009/12/26 16:06:10 marcs Exp $"
*/
#ifndef IncContSens
#define IncContSens

/* libdcg and local includes */
#include <dcg.h>
#include "eag_ds.h"

/* exported code */
void contsens_error (grammar gra, int line, int col, char *format, ...);
void contsens_error_by_gnr (int gnr, int line, int col, char *format, ...);
void contsens_warning (grammar gra, int line, int col, char *format, ...);
void contsens_warning_by_gnr (int gnr, int line, int col, char *format, ...);
void contsens_hint (grammar gra, int line, int col, char *format, ...);
void contsens_hint_by_gnr (int gnr, int line, int col, char *format, ...);
void context_sensitive_analysis ();

#endif /* IncContSens */
