/*
   File: coder.c
   Code generator driver

   Copyright (C) 2012 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: coder.c,v 1.4 2012/08/25 11:00:03 marcs Exp $"
*/

/* standard includes */
#include <stdio.h>
#include <string.h>

/* support lib includes */
#include <dcg.h>
#include <dcg_alloc.h>
#include <dcg_error.h>

/* local includes */
#include "eag_ds.h"
#include "ast_utils.h"
#include "options.h"
#include "code_common.h"
#include "code_topdown.h"
#include "code_leftcorner.h"
#include "code_glr.h"
#include "coder.h"

void generate_c_code ()
{ if (no_code) return;

  /* Call the specific code generation preparation */
  dcg_warning (0, "   generating C code...");
  open_code_file (); 
  code_include_headers ();
  
  /* Call the specific code generator */
  if (td_parser) code_topdown_parser ();
  if (lc_parser) code_leftcorner_parser ();
  if (lr_parser) code_glr_parser ();
  code_start_rule ();
  close_code_file ();
}
