/*
   File: code_common.h
   Defines functions shared by all code generators

   Copyright (C) 2012 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: code_common.h,v 1.13 2013/01/11 11:05:43 marcs Exp $"
*/
#ifndef IncCodeCommon
#define IncCodeCommon

#include "eag_ds.h"

/* Coding support */
extern char *c_code_fname;
void open_code_file ();
void close_code_file ();
void code_string (char *format, ...);
void code_line (char *format, ...);
void code_text_constant (char *text);
void code_direct_affix_value (affix_value value);

/* Code common to all coders */
void code_include_headers ();
void code_rule_name (rule srule, int emp);
void code_rule_header (rule srule);
void code_rule_trailer (rule srule);

/* Trace support */
void try_generate_trace_enter (rule srule);
void try_generate_trace_alternative (rule srule, int nr);
void try_generate_trace_leave (rule srule);

/* Coding of locals */
void code_make_locals (variable_list locals);
void code_free_locals (variable_list locals);

/* Coding of affix expressions, calls etc. */
int code_affix_expr (affix_term term, int count_only);
int code_rule_lhs (int node_nr, int nr_sons, fpar_list lhs_pars, int count_only);
void code_anonymous_rule_lhs (int node_nr, int nr_sons);
int code_link_son (int nr, int pred, int count_only);
int code_single_actual (affix_term arg, int count_only);
int code_actuals (affix_term_list args, int count_only);
int code_glue (glue gl, int count_only);

/* Coding of members */
int code_call (member m, int nr, int emp, int pred, int count_only);
int code_terminal (member m, int nr, int count_only);
int code_member (member m, int nr, int emp, int pred, int count_only);

/* Misc coding */
int count_sons (fwo_group_list fwos);
int count_sons_in_fwo (fwo_group fwo);
int register_neg_memo ();
void code_start_rule ();

#endif /* IncCodeCommon */
