/*
   File: ast_utils.h
   Defines some support routines to handle the ast

   Copyright (C) 2011 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: ast_utils.h,v 1.6 2013/01/03 15:21:21 marcs Exp $"
*/
#ifndef IncAstUtils
#define IncAstUtils

/* Libdcg includes */
#include <dcg.h>

/* Local includes */
#include "eag_ds.h"

/* Exported code */
string string_from_arule_kind (arule_kind akind);
arule_kind kind_from_operator (operator op);
affix_rule type_from_kind (arule_kind akind);

/* Nullability errors */
string string_from_rule_type (rule_type type);
string string_from_nullability (nullability nval);

/* Short hands for expression analysis */
int is_an_affix_variable (affix_term term);
int is_a_single_affix_variable (affix_term_list terms);

/* Short hands for anonymous rules */
int is_anonymous_rule (rule srule);
int try_pick_anonymous_group_spec_and_def (rule srule, group *grp,
					   spec *anc_spec, definition *anc_def);

#endif /* IncAstUtils */

