/*
   File: affix_tree.h
   Defines a symbol table for affix rules implemented as a binary tree.

   Copyright (C) 2008 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: affix_tree.h,v 1.3 2011/09/07 10:09:44 marcs Exp $"
*/
#ifndef IncAffixTree
#define IncAffixTree

/* standard includes */
#include <stdio.h>

/* libdcg includes */
#include <dcg.h>
#include <dcg_alloc.h>
#include <dcg_string.h>
#include <dcg_dump.h>

/* local includes */
#include "eag_ds.h"

/* introduce type and nil definitions */
typedef struct affix_tree_rec *affix_tree;
struct affix_tree_rec
	{ string tag;
	  affix_rule def;
	  affix_tree left;
	  affix_tree right;
	};
#define affix_tree_nil ((affix_tree) NULL)

/* introduce necessary routines and shorthands */
#define new_affix_tree() affix_tree_nil
#define attach_affix_tree(orig) (affix_tree) dcg_attach ((char *) orig)
#define att_affix_tree(orig) (void) dcg_attach ((char *) orig)
void detach_affix_tree (affix_tree *optr);
#define det_affix_tree(optr) detach_affix_tree(optr)
#define equal_affix_tree(a,b) ((a) == (b))

/* supplementary routines and shorthands */
#define est_affix_tree(x) MAXWIDTH
void ppp_affix_tree (FILE *f, int horiz, int ind, affix_tree old);
#define pp_affix_tree(f,x) ppp_affix_tree (f,0,0,x)
void save_affix_tree (FILE *f, affix_tree old);
int load_affix_tree (FILE *f, affix_tree *x);

/* specific routines and shorthands */
affix_rule enter_affix_tree (affix_tree *root, affix_rule new_def);
affix_rule lookup_affix_tree (affix_tree root, string aname);

#endif /* IncAffixTree */
