/*
   File: affix_tree.c
   Defines a symbol table for affix rules implemented as a binary tree.

   Copyright (C) 2008 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: affix_tree.c,v 1.4 2011/09/21 09:39:20 marcs Exp $"
*/

/* standard includes */
#include <stdio.h>
#include <string.h>

/* support lib includes */
#include <dcg.h>
#include <dcg_alloc.h>
#include <dcg_string.h>
#include <dcg_dump.h>

/* local includes */
#include "eag_ds.h"
#include "affix_tree.h"

/* introduce necessary routines and shorthands */
void detach_affix_tree (affix_tree *optr)
{ affix_tree old = (affix_tree) dcg_predetach ((void **) optr);
  if (old == affix_tree_nil) return;
  detach_string (&old -> tag);
  detach_affix_tree (&old -> left);
  detach_affix_tree (&old -> right);
  dcg_detach ((void **) &old);
};

/* supplementary routines and shorthands */
static void my_ppp_affix_tree (FILE *f, int ind, affix_tree old)
{ if (old == affix_tree_nil) return;
  my_ppp_affix_tree (f, ind + 2, old -> left);
  pppdelim (f, 0, ind, '<');
  ppp_string (f, 1, ind + 2, old -> tag);
  pppdelim (f, 0, ind, ',');
  ppp_affix_rule (f, 0, ind + 2, old -> def);
  pppdelim (f, 0, ind, '>');
  my_ppp_affix_tree (f, ind + 2, old -> right);
};

void ppp_affix_tree (FILE *f, int horiz, int ind, affix_tree old)
{ pppdelim (f, 0, ind, '{');
  my_ppp_affix_tree (f, ind + 2, old);
  pppdelim (f, 0, ind, '}');
};

void save_affix_tree (FILE *f, affix_tree old)
{
};

int load_affix_tree (FILE *f, affix_tree *x)
{ return (0);
};

/* specific routines and shorthands */
affix_rule enter_affix_tree (affix_tree *root, affix_rule new_def)
{ affix_tree *ptr = root;
  affix_tree new;
  while (*ptr != affix_tree_nil)
    { affix_tree current = *ptr;
      int cond = strcmp (new_def -> aname, current -> tag);
      if (cond < 0) ptr = &current -> left;
      else if (cond > 0) ptr = &current -> right;
      else /* Found affix rule, return the old definition */
	return (current -> def);
    };

  new = (affix_tree) dcg_malloc (sizeof (struct affix_tree_rec));
  new -> tag = attach_string (new_def -> aname);
  new -> def = new_def;
  new -> left = affix_tree_nil;
  new -> right = affix_tree_nil;
  *ptr = new;
  return (affix_rule_nil);
};

affix_rule lookup_affix_tree (affix_tree root, string aname)
{ affix_tree ptr = root;
  while (ptr != affix_tree_nil)
    { int cond = strcmp (aname, ptr -> tag);
      if (cond < 0) ptr = ptr -> left;
      else if (cond > 0) ptr = ptr -> right;
      else /* Found affix rule */ 
	return (ptr -> def);
    };
  return (affix_rule_nil);
};
