/*
   File: affix_rules.h
   Checks and maintains the affix rules

   Copyright (C) 2008 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: affix_rules.h,v 1.11 2011/07/28 19:59:00 marcs Exp $"
*/
#ifndef IncAffixRules
#define IncAffixRules

/* standard includes */
#include <stdio.h>

/* libdcg includes */
#include <dcg.h>
#include <dcg_alloc.h>
#include <dcg_string.h>

/* local includes */
#include "eag_ds.h"

/* One exported constant */
#define AFFIX_ERROR ((affix_rule) (1L))

/* Pass1: affix rule analysis */
void analyze_affix_rules ();

/* Access functions */
affix_rule get_prime_affix_rule (affix_rule arule);
affix_rule get_repr_affix_rule (affix_rule arule);
string get_affix_rule_name (affix_rule arule);
affix_alternative_list pick_rhs_affix_alts (affix_rule arule);

/* Equivalence (note by synonym) */
int is_abstract_synonym (affix_rule arule, affix_rule *orig_arule, affix_rule *rhs);
int equivalent_affix_rule (affix_rule arule1, affix_rule arule2);

/* Support for rule analysis */
typedef affix_rule_list signature;
int similar_affix_rule (affix_rule arule1, affix_rule arule2);
int similar_signatures (signature sig1, signature sig2);
affix_rule identify_affix_instance (string vname);

int is_integer_type (affix_rule arule);
int is_real_type (affix_rule arule);
int is_text_type (affix_rule arule);
int is_a_primitive_type (affix_rule arule);
affix_rule get_primitive_type (arule_kind kind);

#endif /* IncAffixRules */
