/*
   File: options.h
   Defines flags and parameters of the eag3 driver

   Copyright (C) 2013 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: options.h,v 1.1 2013/03/13 10:08:52 marcs Exp $"
*/
#ifndef IncOptions
#define IncOptions

/* libdcg and local includes */
#include <dcg.h>
#include <dcg_string.h>
#include <dcg_plist.h>

/* exported flags and pragmats */
extern int agfl_compatible;
extern int force_lexgen;
extern int non_strict;

/* exported codegen flags */
extern int positive_memoization;
extern int negative_memoization;
extern int td_parser;
extern int lc_parser;
extern int lr_parser;

/* Source file names */
extern string source_name;

/* exported search path */
extern string_list grammar_search_path;

/* other exported strings */
extern string variants_option;

/* exported routines */
void init_options ();
void parse_command_line (int argc, char **argv);

#endif /* IncOptions */
