/*
   File: main.c
   Driver for eag3 compiler and lexgen

   Copyright (C) 2013 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: main.c,v 1.1 2013/03/13 10:08:52 marcs Exp $"
*/

/* global includes */
#include <stdio.h>

/* libdcg includes */
#include <dcg.h>
#include <dcg_error.h>
#include <dcg_alloc.h>
#include <dcg_procutil.h>

/* local includes */
#include "options.h"

/*
   Dump the command line if verbose
*/
static void try_dump_argv (char **argv)
{ char **ptr;
  if (!verbose) return;
  dcg_eprint ("  ");
  for (ptr = argv; (*ptr) != NULL; ptr++)
    { dcg_eprint (" ");
      dcg_eprint (*ptr);
    };
  dcg_wlog ("");
}

#define NR_ARGS 16
static void compile_grammar ()
{ int needed_args = NR_ARGS + 2 * grammar_search_path -> size;
  char **compiler_argv = (char **) dcg_calloc (needed_args, sizeof (char *));
  int nr_args = 0;
  int ix;
  compiler_argv[nr_args++] = "eag3-compile";

  /* Add all options for the compiler */
  if (verbose) 			compiler_argv[nr_args++] = "-v";
  if (positive_memoization)	compiler_argv[nr_args++] = "-P";
  if (negative_memoization)	compiler_argv[nr_args++] = "-N";
  if (td_parser)		compiler_argv[nr_args++] = "-td";
  if (lc_parser)		compiler_argv[nr_args++] = "-lc";
  if (lr_parser)		compiler_argv[nr_args++] = "-lr";
  if (non_strict)		compiler_argv[nr_args++] = "-ns";
  if (agfl_compatible)		compiler_argv[nr_args++] = "-ca";
  for (ix = 0; ix < grammar_search_path -> size; ix++)
    { compiler_argv[nr_args++] = "-I";
      compiler_argv[nr_args++] = grammar_search_path -> array[ix];
    };

  /* To add: code to compile variants */
  
  /* Add the source name as actual argument */
  compiler_argv[nr_args++] = source_name;
  compiler_argv[nr_args] = string_nil;

  /* Execute the cit-and-caboodle */
  try_dump_argv (compiler_argv);
  if (dcg_spawn_and_wait (compiler_argv))
    dcg_exit (4);
  
  /* Cleanup */
  dcg_detach ((void **) &compiler_argv);
}

static void compile_lexica ()
{ char *lexgen_argv[NR_ARGS];
  int nr_args = 0;
  lexgen_argv[nr_args++] = "eag3-lexgen";

  /* Add all options for the lexgen */
  if (verbose) 			lexgen_argv[nr_args++] = "-v";
  if (force_lexgen)		lexgen_argv[nr_args++] = "-f";
  
  /* Add the source name as actual argument */
  lexgen_argv[nr_args++] = source_name;
  lexgen_argv[nr_args] = string_nil;

  /* Execute the cit-and-caboodle */
  try_dump_argv (lexgen_argv);
  if (dcg_spawn_and_wait (lexgen_argv))
    dcg_exit (4);
}

int main (int argc, char **argv)
{ dcg_init_error (stderr, "eag3", NULL);
  dcg_init_alloc ("eag3", 0);
  init_options ();
  parse_command_line (argc, argv);
  compile_grammar ();
  compile_lexica ();
  return (0);
}
