/*
   File: eag3_test_lex.c
   Simple test program to check reading and searching lexica

   Copyright 2011 Radboud University of Nijmegen

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: eag3_test_lex.c,v 1.6 2012/07/28 15:25:47 marcs Exp $"
*/

/* standard includes */
#include <stdio.h>

/* libdcg includes */
#include <dcg_error.h>
#include <dcg_alloc.h>

/* local includes */
#include <ebase_lexicon.h>
#include <ebase_input.h>
#include <ebase_utils.h>
#include <ebase_voc_search.h>

static void test_lexicon (Lexicon lex, char *input)
{ LexiconVocIterator iter;
  char *inp = input;
  int penalty = 0;
  char *end;

  (void) ebs_is_white_spaces (lex, &inp);
  iter = ebs_init_lexicon_voc_match (lex, inp);
  while ((end = ebs_next_lexicon_voc_match (iter, &penalty)) != NULL)
    { int entry_nr, ix, marker;
      int_list entries;
      char *lexeme;
      ebs_get_lexicon_voc_match_info (iter, &entry_nr, &lexeme, &marker);
      dcg_wlog ("Recognized lexeme '%s', marker %d, entry nr: %d, penalty %d",
		lexeme, marker, entry_nr, penalty);

      /* The entries are a list of pairs (call_id, frequency) */
      entries = ebs_get_entries_from_entry_nr (lex, entry_nr);
      dcg_wlog ("Matched %d entries:", entries -> size / 2);
      for (ix = 0; ix < entries -> size; ix += 2)
	{ ebs_dump_call (dcg_error_file (), lex, entries -> array[ix]);
	  dcg_wlog ("");
	};
    };
  ebs_finish_lexicon_voc_match (&iter);
}

int main (int argc, char **argv)
{ char buffer[256];
  Lexicon my_lex;

  /* Initialize the stuff */
  dcg_init_error (stderr, "eag3 test lexicon tool", NULL);
  dcg_init_alloc ("eag3 test lexicon", 0);
  ebs_read_lexicon (".", (argc > 1)?argv[1]:"npx", &my_lex);

  while (fgets (buffer, 255, stdin) != NULL)
    test_lexicon (my_lex, buffer);
  return (0);
}
