/*
   File: erts_trans.h
   Defines the second pass, i.e. transduction of the runtime system

   Copyright 2012 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: erts_trans.h,v 1.3 2012/12/26 12:07:55 marcs Exp $"
*/

#ifndef IncErtsTrans
#define IncErtsTrans

/* local includes */
#include "erts_handle.h"

/* Define ParseResult as an opaque type */
typedef struct parse_result_rec *ParseResult;
#define parse_result_nil ((ParseResult) NULL)

/* If we reach this function, the first pass reached its final continuation */
void erts_pass2 (EagrtsHandle hnd);
State erts_get_final_parse_state (EagrtsHandle hnd);

/* To clean up after parse */
void erts_output_parse_results (EagrtsHandle hnd);
void erts_discard_parse_results (EagrtsHandle hnd);

#endif /* IncErtsTrans */
