/*
   File: erts_misc.h
   Defines various miscellaneous functions for the EAG3 runtime system.

   Copyright 2012 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: erts_misc.h,v 1.6 2013/01/11 11:07:29 marcs Exp $"
*/

#ifndef IncErtsMisc
#define IncErtsMisc

/* local includes */
#include "erts_handle.h"

/* Exported actions */
void erts_end_of_parse (EagrtsHandle hnd);
void erts_glue (EagrtsHandle hnd);
int erts_test_and_set_negative_memo (EagrtsHandle hnd, int nmemo);
void erts_clear_negative_memo (EagrtsHandle hnd);
void erts_penalty (EagrtsHandle hnd);
void erts_penalty_one (EagrtsHandle hnd);
void erts_fail_continuation (EagrtsHandle hnd);
void erts_abort (EagrtsHandle hnd);
void erts_exit (EagrtsHandle hnd);
void erts_confrontation (EagrtsHandle hnd);

#endif /* IncErtsMisc */
