/*
   File: erts_leaf_parser.h
   Defines the functions to parse terminals, lexicon nonterminals,
   regular expressions, the special parse functions for both the
   first and second level of the parse. 

   Copyright 2012 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: erts_leaf_parser.h,v 1.4 2012/11/07 13:56:13 marcs Exp $"
*/
#ifndef IncErtsLeafParser
#define IncErtsLeafParser

#include "erts_handle.h"

/* Export parse functions */
void erts_parse_terminal (EagrtsHandle hnd);
void erts_parse_lex_nont (EagrtsHandle hnd);
void erts_parse_match (EagrtsHandle hnd);
void erts_parse_skip (EagrtsHandle hnd);
void erts_parse_word (EagrtsHandle hnd);
void erts_parse_other (EagrtsHandle hnd);
void erts_parse_any (EagrtsHandle hnd);

/* Export meta parse functions */
void erts_parse_meta_terminal (EagrtsHandle hnd);
void erts_parse_meta_regexp (EagrtsHandle hnd);

/* Export end of text functions */
void erts_parse_eot (EagrtsHandle hnd);

#endif /* IncErtsLeafParser */
