/*
   File: erts_handle_impl.h
   Defines the data structure containing the runtime parametrization
   of the EAG3 runtime system, the EAG3 tree and continuation stack.

   Copyright 2012 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: erts_handle_impl.h,v 1.11 2012/12/27 17:59:52 marcs Exp $"
*/
#ifndef IncErtsHandleImpl
#define IncErtsHandleImpl

/* libebase includes */
#include <ebase_lexicon.h>

#include "erts_tree.h"
#include "erts_cont.h"
#include "erts_trellis.h"
#include "erts_trans.h"

/*
   We call the function parse_trellis in a shared object
   To ease access, we need a proto type for the function.
*/
typedef void (*parse_trellis_proc)(EagrtsHandle hnd);

typedef enum
{ tr_undefined,
  tr_none,
  tr_count,
  tr_affix,
  tr_tree,
  tr_user
} trans_kind;

struct eagrts_handle_rec
{ /* File names */
  char *	dir_name;		/* Directory of grammar, blx, rti, so/dll files */
  char *	grammar_name;		/* Grammar base name */
  char *	input_fname;		/* Input file name or null: stdin */
  char *	output_fname;		/* Output file name or null: stdout */
  char *	input_pos_fname;	/* Input file name to use in $POS */

  /* The Lexicon */
  Lexicon	lexicon;		/* The binary lexicon of the grammar */

  /* Options set by compiler, overrulable by command line options */
  int		hybrid_parsing;		/* Note that the lexicon has an opinion */
  int		partial_parse;		/* Full/Partial parse */
  int		input_mode;		/* Line/Block (Paragraph)/Document mode */
  int		tracing;		/* Tracing enabled, not blockable */
  int		negative_memoization;	/* Negative memoization enabled */
  int		positive_memoization;	/* Positive memoization enabled */
  int		nr_neg_memos;		/* Coded number of negative memos */

  /* Runtime information passed by compiler */
  rt_nont_list	rt_nonts;		/* Map from nonterminal number to nonterminal info */
  ext_nont_list	ext_nonts;		/* Reverse map from canonic_name to nodenr */
  affix_value_list rt_consts;		/* List of constant affix values used in the code */

  /* Runtime options, set from command line */
  trans_kind	transduce_option;	/* Kind of transduction in second pass */
  int		lcsdoc_sync_option;	/* Interpret \001 as document separator */
  int		show_trellis;		/* Show the trellis after processing chunk */
  int		max_parses;		/* Maximum number of acceptable parses */
  int		best_parses;		/* Accept only parses with lowest penalty */

  /* Input/Output handling */
  FILE *	input_file;		/* For line/paragraph/document mode input */
  FILE *	output_file;		/* For all parser output */
  int		interactive;		/* Whether to prompt or not */
  int		linenr;			/* Current line number in input file */
  int		colnr;			/* Current column number in input file */
  int		seen_eof;		/* Whether an end of file has been recognized */
  int		seen_doc_sync;		/* Whether a document separator has been recognized */

  /* Dynamic Input handling */
  char *	input_buffer;		/* Input buffer; gets dynamically enlarged */
  char *	input_bufptr;		/* Pointer to end of dynamic chunk */
  int		input_size;		/* Current size of input buffer */

  /* Chunk handling */
  int		input_length;		/* Length of input */
  int		input_linenr;		/* Starting line number of chunk */
  int		input_colnr;		/* Starting column number of chunk */

  /* The current trellis */
  Trellis	trellis;		/* Current trellis */
  State		start_state;		/* Start state of current parse */
  Penalty	curr_penalty;		/* Current accrued penalty */
  int		curr_depth;		/* Current tracing depth */

  /* Tree stack */
  Tree *	tree_stack;		/* Stack of partial parse trees */
  int 		tree_stack_size;	/* Size of tree stack */
  Tree *	tree_sp;		/* Current tree stack pointer */

  /* Continuation stack */
  cont_ptr	cont_stack;		/* Stack of continuation cells */
  int		cont_stack_size;	/* Size of continuation stack */
  cont_ptr	cont_sp;		/* Current continuation stack pointer */

  /* Parse results */
  ParseResult	all_results;		/* All valid results */
  ParseResult	curr_result;		/* The current parse result, being built */
  int		nr_of_results;		/* To keep track of the number on the list */
  Penalty	max_penalty;		/* Maximum penalty on all_results list */

  /* Link to dynamic code */
  void *	shared_object_handle;	/* Handle to loaded shared parser */
  parse_trellis_proc parse_trellis;	/* Generated code to parse the trellis */
};

#endif /* IncErtsHandleImpl */
