/*
   File: erts_handle.h
   Defines the data structure containing the runtime parametrization
   of the EAG3 runtime system, the EAG3 tree and continuation stack.

   Copyright 2012 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: erts_handle.h,v 1.4 2012/07/27 09:31:13 marcs Exp $"
*/

#ifndef IncErtsHandle
#define IncErtsHandle

/* Define the handle as an opaque type */
typedef struct eagrts_handle_rec *EagrtsHandle;

/* exported functions */
EagrtsHandle erts_init_handle ();
void erts_read_runtime_information (EagrtsHandle hnd);
void erts_release_handle (EagrtsHandle *hnd);
void erts_init_stacks (EagrtsHandle hnd);

#endif /* IncErtsHandle */
