/*
   File: ebase_vocabulary_impl.h
   Stores a vocabulary (by which we mean the datastructure through which
   words can be entered with their appropriate information) for later
   retrieval. Since the number of words in the vocabulary may easily be
   of the order of one million, words are stored in a trie structure.

   Copyright 2009-2011 Marc Seutter
 
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: ebase_vocabulary_impl.h,v 1.2 2012/07/27 09:30:22 marcs Exp $"
*/
#ifndef IncEbaseVocabularyImpl
#define IncEbaseVocabularyImpl

#ifdef __cplusplus
extern "C" {
#endif

/* libdcg includes */
#include <dcg.h>
#include <dcg_alloc.h>

/* local includes */
#include "ebase_vocabulary.h"

/*
   Define the structure of a vocabulary
*/
typedef struct voc_index_tree_rec *VocIndexTree;
typedef struct voc_trie_rec *VocTrie;
typedef int VocInfo;

struct vocabulary_rec
{ VocTrie trie;			/* the actual trie */
  pool my_pool;			/* administration of all used memory */
  int frozen;			/* Vocabulary has been frozen */
};

struct voc_trie_rec
{ char *search_key;		/* Orig search key */
  int rem_offset;		/* Tail index in search key */
  VocInfo info;			/* Associated info: index in feature space */
  VocIndexTree tails;		/* Balanced tree of subtries */
};

struct voc_index_tree_rec
{ VocIndexTree left;		/* Left subtree */
  VocIndexTree right;		/* Right subtree */
  VocTrie sub_trie;		/* Associated subtrie */
  unsigned char key;		/* Search key in index tree */
  signed char balfac;		/* Balance factor */
};

/* Introduce nil pointers */
#define voc_index_tree_nil ((VocIndexTree) NULL)
#define voc_trie_nil ((VocTrie) NULL)

#ifdef __cplusplus
}
#endif
#endif /* IncEbaseVocabularyImpl */
