/*
   File: ebase_vocabulary.h
   Stores a vocabulary (by which we mean the datastructure through which
   words can be entered with their appropriate information) for later
   retrieval. Since the number of words in the vocabulary may easily be
   of the order of one million, words are stored in a trie structure.

   Copyright 2009-2011 Marc Seutter
 
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: ebase_vocabulary.h,v 1.3 2012/07/27 09:30:22 marcs Exp $"
*/
#ifndef IncEbaseVocabulary
#define IncEbaseVocabulary

/* libdcg includes */
#include <dcg.h>
#include <dcg_alloc.h>
#include <dcg_binfile.h>

/*
   Export Vocabulary as an opaque struct pointer with access routines
*/
typedef struct vocabulary_rec *Vocabulary;
#define vocabulary_nil ((Vocabulary) NULL)

/* exported routines */
Vocabulary ebs_new_vocabulary (pool my_pool);
int *ebs_enter_into_vocabulary (Vocabulary voc, char *pattern);
int *ebs_lookup_in_vocabulary (Vocabulary voc, char *pattern);
void ebs_dump_vocabulary (Vocabulary voc);
void ebs_bin_save_vocabulary (BinFile bf, Vocabulary voc);
void ebs_bin_load_vocabulary (BinFile bf, Vocabulary voc);

/* exported iterator */
typedef void (*VocIterProc)(void *arg, char *key, int info);
void ebs_iterate_over_vocabulary (Vocabulary voc, VocIterProc vip, void *arg);

#endif /* IncEbaseVocabulary */
