/*
   File: ebase_voc_search.h
   Implements the search through the vocabularies of a lexicon

   Copyright 2012 Marc Seutter
 
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: ebase_voc_search.h,v 1.4 2012/07/27 09:30:22 marcs Exp $"
*/
#ifndef IncEbaseVocSearch
#define IncEbaseVocSearch

/* Local includes */
#include "ebase_lexicon.h"

/* Introduce LexiconVocIterator as an opaque struct pointer */
typedef struct lexicon_voc_iterator_rec *LexiconVocIterator;

/* Matching of lexicon terminals, using an iterator over the vocabularies of the lexicon */
LexiconVocIterator ebs_init_lexicon_voc_match (Lexicon lex, char *input);
char *ebs_next_lexicon_voc_match (LexiconVocIterator iter, Penalty *rpenalty);
void ebs_finish_lexicon_voc_match (LexiconVocIterator *iter);
void ebs_get_lexicon_voc_match_info (LexiconVocIterator iter, int *entry_nr,
				     char **matched_lexeme, int *matched_marker);

#endif /* IncEbaseVocSearch */
