/*
   File: ebase_regexp_search.h
   Implements the search through the regular expressions of a lexicon

   Copyright 2012 Marc Seutter
 
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: ebase_regexp_search.h,v 1.2 2012/07/27 09:30:22 marcs Exp $"
*/
#ifndef IncEbaseRegexpSearch
#define IncEbaseRegexpSearch

/* Local includes */
#include "ebase_lexicon.h"

/* Introduce LexiconRegexpIterator as an opaque struct pointer */
typedef struct lexicon_regexp_iterator_rec *LexiconRegexpIterator;

/* Matching of regular expressions, using an iterator over the regexps of the lexicon */
LexiconRegexpIterator ebs_init_lexicon_regexp_match (Lexicon lex, char *input, int kind);
char *ebs_next_lexicon_regexp_match (LexiconRegexpIterator iter);
void ebs_finish_lexicon_regexp_match (LexiconRegexpIterator *iter);
void ebs_get_lexicon_regexp_match_info (LexiconRegexpIterator iter,
					int *matched_nr, int *matched_kind, int *matched_marker);

#endif /* IncEbaseRegexpSearch */
